/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

public enum CloseReason {
    CLIENT_ACTION(0),
    SERVICE_ACTION(1),
    TIMEOUT(2),
    NULL_VAL(Integer.MIN_VALUE);

    private final int value;

    private CloseReason(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static CloseReason get(int value) {
        switch (value) {
            case 0: {
                return CLIENT_ACTION;
            }
            case 1: {
                return SERVICE_ACTION;
            }
            case 2: {
                return TIMEOUT;
            }
        }
        if (Integer.MIN_VALUE == value) {
            return NULL_VAL;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

