/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.client;

import io.aeron.Publication;
import io.aeron.cluster.codecs.IngressMessageHeaderEncoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class IngressSessionDecorator {
    public static final int HEADER_LENGTH = 32;
    private final IngressMessageHeaderEncoder ingressMessageHeaderEncoder = new IngressMessageHeaderEncoder();
    private final UnsafeBuffer headerBuffer = new UnsafeBuffer(new byte[32]);

    public IngressSessionDecorator() {
        this(-1L, -1L);
    }

    public IngressSessionDecorator(long clusterSessionId, long leadershipTermId) {
        this.ingressMessageHeaderEncoder.wrapAndApplyHeader(this.headerBuffer, 0, new MessageHeaderEncoder()).leadershipTermId(leadershipTermId).clusterSessionId(clusterSessionId).timestamp(-1L);
    }

    public IngressSessionDecorator clusterSessionId(long clusterSessionId) {
        this.ingressMessageHeaderEncoder.clusterSessionId(clusterSessionId);
        return this;
    }

    public IngressSessionDecorator leadershipTermId(long leadershipTermId) {
        this.ingressMessageHeaderEncoder.leadershipTermId(leadershipTermId);
        return this;
    }

    public long offer(Publication publication, DirectBuffer buffer, int offset, int length) {
        return publication.offer(this.headerBuffer, 0, 32, buffer, offset, length, null);
    }
}

