/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.client;

import io.aeron.ControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.ChallengeDecoder;
import io.aeron.cluster.codecs.EgressMessageHeaderDecoder;
import io.aeron.cluster.codecs.EventCode;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.NewLeaderEventDecoder;
import io.aeron.cluster.codecs.SessionEventDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

public class EgressPoller
implements ControlledFragmentHandler {
    private final int fragmentLimit;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SessionEventDecoder sessionEventDecoder = new SessionEventDecoder();
    private final ChallengeDecoder challengeDecoder = new ChallengeDecoder();
    private final NewLeaderEventDecoder newLeaderEventDecoder = new NewLeaderEventDecoder();
    private final EgressMessageHeaderDecoder egressMessageHeaderDecoder = new EgressMessageHeaderDecoder();
    private final ControlledFragmentAssembler fragmentAssembler = new ControlledFragmentAssembler(this);
    private final Subscription subscription;
    private long clusterSessionId = -1L;
    private long correlationId = -1L;
    private long leadershipTermId = -1L;
    private int leaderMemberId = -1;
    private int templateId = -1;
    private boolean pollComplete = false;
    private EventCode eventCode;
    private String detail = "";
    private byte[] encodedChallenge;

    public EgressPoller(Subscription subscription, int fragmentLimit) {
        this.subscription = subscription;
        this.fragmentLimit = fragmentLimit;
    }

    public Subscription subscription() {
        return this.subscription;
    }

    public int templateId() {
        return this.templateId;
    }

    public long clusterSessionId() {
        return this.clusterSessionId;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public long leadershipTermId() {
        return this.leadershipTermId;
    }

    public int leaderMemberId() {
        return this.leaderMemberId;
    }

    public EventCode eventCode() {
        return this.eventCode;
    }

    public String detail() {
        return this.detail;
    }

    public byte[] encodedChallenge() {
        return this.encodedChallenge;
    }

    public boolean isPollComplete() {
        return this.pollComplete;
    }

    public boolean isChallenged() {
        return 8 == this.templateId;
    }

    public int poll() {
        this.clusterSessionId = -1L;
        this.correlationId = -1L;
        this.leadershipTermId = -1L;
        this.leaderMemberId = -1;
        this.templateId = -1;
        this.eventCode = null;
        this.detail = "";
        this.encodedChallenge = null;
        this.pollComplete = false;
        return this.subscription.controlledPoll(this.fragmentAssembler, this.fragmentLimit);
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.sbeSchemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        this.templateId = this.messageHeaderDecoder.templateId();
        switch (this.templateId) {
            case 3: {
                this.sessionEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.clusterSessionId = this.sessionEventDecoder.clusterSessionId();
                this.correlationId = this.sessionEventDecoder.correlationId();
                this.leadershipTermId = this.sessionEventDecoder.leadershipTermId();
                this.leaderMemberId = this.sessionEventDecoder.leaderMemberId();
                this.eventCode = this.sessionEventDecoder.code();
                this.detail = this.sessionEventDecoder.detail();
                this.pollComplete = true;
                break;
            }
            case 7: {
                this.newLeaderEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.clusterSessionId = this.newLeaderEventDecoder.clusterSessionId();
                this.leadershipTermId = this.newLeaderEventDecoder.leadershipTermId();
                this.leaderMemberId = this.newLeaderEventDecoder.leaderMemberId();
                this.detail = this.newLeaderEventDecoder.memberEndpoints();
                this.pollComplete = true;
                break;
            }
            case 2: {
                this.egressMessageHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.leadershipTermId = this.egressMessageHeaderDecoder.leadershipTermId();
                this.clusterSessionId = this.egressMessageHeaderDecoder.clusterSessionId();
                this.pollComplete = true;
                break;
            }
            case 8: {
                this.challengeDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.encodedChallenge = new byte[this.challengeDecoder.encodedChallengeLength()];
                this.challengeDecoder.getEncodedChallenge(this.encodedChallenge, 0, this.challengeDecoder.encodedChallengeLength());
                this.clusterSessionId = this.challengeDecoder.clusterSessionId();
                this.correlationId = this.challengeDecoder.correlationId();
                this.pollComplete = true;
            }
        }
        return ControlledFragmentHandler.Action.BREAK;
    }
}

