/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.client;

import io.aeron.FragmentAssembler;
import io.aeron.Subscription;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.client.EgressListener;
import io.aeron.cluster.codecs.EgressMessageHeaderDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.NewLeaderEventDecoder;
import io.aeron.cluster.codecs.SessionEventDecoder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

public class EgressAdapter
implements FragmentHandler {
    public static final int SESSION_HEADER_LENGTH = 32;
    private final long clusterSessionId;
    private final int fragmentLimit;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SessionEventDecoder sessionEventDecoder = new SessionEventDecoder();
    private final NewLeaderEventDecoder newLeaderEventDecoder = new NewLeaderEventDecoder();
    private final EgressMessageHeaderDecoder egressMessageHeaderDecoder = new EgressMessageHeaderDecoder();
    private final FragmentAssembler fragmentAssembler = new FragmentAssembler(this);
    private final EgressListener listener;
    private final Subscription subscription;

    public EgressAdapter(EgressListener listener, long clusterSessionId, Subscription subscription, int fragmentLimit) {
        this.clusterSessionId = clusterSessionId;
        this.listener = listener;
        this.subscription = subscription;
        this.fragmentLimit = fragmentLimit;
    }

    public int poll() {
        return this.subscription.poll(this.fragmentAssembler, this.fragmentLimit);
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.sbeSchemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        int templateId = this.messageHeaderDecoder.templateId();
        if (2 == templateId) {
            this.egressMessageHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            long sessionId = this.egressMessageHeaderDecoder.clusterSessionId();
            if (sessionId == this.clusterSessionId) {
                this.listener.onMessage(sessionId, this.egressMessageHeaderDecoder.timestamp(), buffer, offset + 32, length - 32, header);
            }
            return;
        }
        switch (templateId) {
            case 3: {
                this.sessionEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long sessionId = this.sessionEventDecoder.clusterSessionId();
                if (sessionId != this.clusterSessionId) break;
                this.listener.sessionEvent(this.sessionEventDecoder.correlationId(), sessionId, this.sessionEventDecoder.leadershipTermId(), this.sessionEventDecoder.leaderMemberId(), this.sessionEventDecoder.code(), this.sessionEventDecoder.detail());
                break;
            }
            case 7: {
                this.newLeaderEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long sessionId = this.newLeaderEventDecoder.clusterSessionId();
                if (sessionId != this.clusterSessionId) break;
                this.listener.newLeader(sessionId, this.newLeaderEventDecoder.leadershipTermId(), this.newLeaderEventDecoder.leaderMemberId(), this.newLeaderEventDecoder.memberEndpoints());
                break;
            }
        }
    }
}

