/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.client;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.CommonContext;
import io.aeron.ControlledFragmentAssembler;
import io.aeron.DirectBufferVector;
import io.aeron.FragmentAssembler;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.client.ControlledEgressListener;
import io.aeron.cluster.client.EgressListener;
import io.aeron.cluster.client.EgressPoller;
import io.aeron.cluster.codecs.ChallengeResponseEncoder;
import io.aeron.cluster.codecs.EgressMessageHeaderDecoder;
import io.aeron.cluster.codecs.IngressMessageHeaderEncoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.NewLeaderEventDecoder;
import io.aeron.cluster.codecs.SessionCloseRequestEncoder;
import io.aeron.cluster.codecs.SessionConnectRequestEncoder;
import io.aeron.cluster.codecs.SessionEventDecoder;
import io.aeron.cluster.codecs.SessionKeepAliveEncoder;
import io.aeron.exceptions.ConfigurationException;
import io.aeron.exceptions.TimeoutException;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import io.aeron.security.AuthenticationException;
import io.aeron.security.CredentialsSupplier;
import io.aeron.security.NullCredentialsSupplier;
import java.util.concurrent.TimeUnit;
import org.agrona.AsciiEncoding;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.LangUtil;
import org.agrona.SystemUtil;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;

public final class AeronCluster
implements AutoCloseable {
    public static final int INGRESS_HEADER_LENGTH = 32;
    public static final int EGRESS_HEADER_LENGTH = 32;
    private static final int SEND_ATTEMPTS = 3;
    private static final int CONNECT_FRAGMENT_LIMIT = 1;
    private static final int SESSION_FRAGMENT_LIMIT = 10;
    private long leadershipTermId = -1L;
    private final long clusterSessionId;
    private int leaderMemberId = -1;
    private final boolean isUnicast;
    private final Context ctx;
    private final Aeron aeron;
    private final Subscription subscription;
    private Publication publication;
    private final NanoClock nanoClock;
    private final IdleStrategy idleStrategy;
    private Int2ObjectHashMap<MemberEndpoint> endpointByMemberIdMap = new Int2ObjectHashMap();
    private final BufferClaim bufferClaim = new BufferClaim();
    private final UnsafeBuffer headerBuffer = new UnsafeBuffer(new byte[32]);
    private final DirectBufferVector headerVector = new DirectBufferVector(this.headerBuffer, 0, this.headerBuffer.capacity());
    private final UnsafeBuffer keepaliveMsgBuffer;
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final IngressMessageHeaderEncoder ingressMessageHeaderEncoder = new IngressMessageHeaderEncoder();
    private final SessionKeepAliveEncoder sessionKeepAliveEncoder = new SessionKeepAliveEncoder();
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final EgressMessageHeaderDecoder egressMessageHeaderDecoder = new EgressMessageHeaderDecoder();
    private final NewLeaderEventDecoder newLeaderEventDecoder = new NewLeaderEventDecoder();
    private final SessionEventDecoder sessionEventDecoder = new SessionEventDecoder();
    private final FragmentAssembler fragmentAssembler;
    private final EgressListener egressListener;
    private final ControlledFragmentAssembler controlledFragmentAssembler;
    private final ControlledEgressListener controlledEgressListener;

    public static AeronCluster connect() {
        return AeronCluster.connect(new Context());
    }

    public static AeronCluster connect(Context ctx) {
        return new AeronCluster(ctx);
    }

    private AeronCluster(Context ctx) {
        Subscription subscription = null;
        try {
            this.ctx = ctx;
            ctx.conclude();
            this.aeron = ctx.aeron();
            this.idleStrategy = ctx.idleStrategy();
            this.nanoClock = this.aeron.context().nanoClock();
            this.isUnicast = ctx.clusterMemberEndpoints() != null;
            this.egressListener = ctx.egressListener();
            this.fragmentAssembler = new FragmentAssembler(this::onFragment, 0, ctx.isDirectAssemblers());
            this.controlledEgressListener = ctx.controlledEgressListener();
            this.controlledFragmentAssembler = new ControlledFragmentAssembler(this::onControlledFragment, 0, ctx.isDirectAssemblers());
            this.subscription = subscription = this.aeron.addSubscription(ctx.egressChannel(), ctx.egressStreamId());
            this.clusterSessionId = this.connectToCluster();
            this.ingressMessageHeaderEncoder.wrapAndApplyHeader(this.headerBuffer, 0, this.messageHeaderEncoder).clusterSessionId(this.clusterSessionId).leadershipTermId(this.leadershipTermId);
            this.keepaliveMsgBuffer = new UnsafeBuffer(new byte[24]);
            this.sessionKeepAliveEncoder.wrapAndApplyHeader(this.keepaliveMsgBuffer, 0, this.messageHeaderEncoder).leadershipTermId(this.leadershipTermId).clusterSessionId(this.clusterSessionId);
        }
        catch (Exception ex) {
            if (!ctx.ownsAeronClient()) {
                this.endpointByMemberIdMap.values().forEach(MemberEndpoint::disconnect);
                CloseHelper.quietClose(this.publication);
                CloseHelper.quietClose(subscription);
            }
            ctx.close();
            throw ex;
        }
    }

    @Override
    public void close() {
        if (null != this.publication && this.publication.isConnected()) {
            this.closeSession();
        }
        if (!this.ctx.ownsAeronClient()) {
            CloseHelper.close(this.subscription);
            CloseHelper.close(this.publication);
        }
        this.ctx.close();
    }

    public Context context() {
        return this.ctx;
    }

    public long clusterSessionId() {
        return this.clusterSessionId;
    }

    public long leadershipTermId() {
        return this.leadershipTermId;
    }

    public int leaderMemberId() {
        return this.leaderMemberId;
    }

    public Publication ingressPublication() {
        return this.publication;
    }

    public Subscription egressSubscription() {
        return this.subscription;
    }

    public long offer(DirectBuffer buffer, int offset, int length) {
        return this.publication.offer(this.headerBuffer, 0, 32, buffer, offset, length, null);
    }

    public long offer(DirectBufferVector[] vectors) {
        if (this.headerVector != vectors[0]) {
            vectors[0] = this.headerVector;
        }
        return this.publication.offer(vectors, null);
    }

    public boolean sendKeepAlive() {
        this.idleStrategy.reset();
        int attempts = 3;
        while (true) {
            long result;
            if ((result = this.publication.offer(this.keepaliveMsgBuffer, 0, this.keepaliveMsgBuffer.capacity(), null)) > 0L) {
                return true;
            }
            if (result == -1L || result == -4L) {
                return false;
            }
            if (result == -5L) {
                throw new ClusterException("unexpected publication state: " + result);
            }
            if (--attempts <= 0) break;
            this.idleStrategy.idle();
        }
        return false;
    }

    public int pollEgress() {
        return this.subscription.poll(this.fragmentAssembler, 10);
    }

    public int controlledPollEgress() {
        return this.subscription.controlledPoll(this.controlledFragmentAssembler, 10);
    }

    public void onNewLeader(long clusterSessionId, long leadershipTermId, int leaderMemberId, String memberEndpoints) {
        if (clusterSessionId != this.clusterSessionId) {
            throw new ClusterException("invalid clusterSessionId=" + clusterSessionId + " expected " + this.clusterSessionId);
        }
        this.leadershipTermId = leadershipTermId;
        this.leaderMemberId = leaderMemberId;
        this.ingressMessageHeaderEncoder.leadershipTermId(leadershipTermId);
        this.sessionKeepAliveEncoder.leadershipTermId(leadershipTermId);
        if (this.isUnicast) {
            CloseHelper.close(this.publication);
            this.ctx.clusterMemberEndpoints(memberEndpoints);
            this.updateMemberEndpoints(memberEndpoints, leaderMemberId);
        }
        this.fragmentAssembler.clear();
        this.controlledFragmentAssembler.clear();
        this.egressListener.newLeader(clusterSessionId, leadershipTermId, leaderMemberId, memberEndpoints);
        this.controlledEgressListener.newLeader(clusterSessionId, leadershipTermId, leaderMemberId, memberEndpoints);
    }

    private void updateMemberEndpoints(String memberEndpoints, int leaderMemberId) {
        Int2ObjectHashMap<MemberEndpoint> tempMap = new Int2ObjectHashMap<MemberEndpoint>();
        for (String endpoint : memberEndpoints.split(",")) {
            int i = endpoint.indexOf(61);
            if (-1 == i) {
                throw new ConfigurationException("invalid format - endpoint missing '=' separator: " + memberEndpoints);
            }
            int memberId = AsciiEncoding.parseIntAscii(endpoint, 0, i);
            tempMap.put(memberId, new MemberEndpoint(memberId, endpoint.substring(i + 1)));
        }
        MemberEndpoint existingLeaderEndpoint = this.endpointByMemberIdMap.get(leaderMemberId);
        MemberEndpoint leaderEndpoint = (MemberEndpoint)tempMap.get(leaderMemberId);
        if (null != existingLeaderEndpoint && null != existingLeaderEndpoint.publication && null != leaderEndpoint && leaderEndpoint.endpoint.equals(existingLeaderEndpoint.endpoint)) {
            leaderEndpoint.publication = existingLeaderEndpoint.publication;
            existingLeaderEndpoint.publication = null;
            this.publication = leaderEndpoint.publication;
        }
        if (null != leaderEndpoint && null == leaderEndpoint.publication) {
            ChannelUri channelUri = ChannelUri.parse(this.ctx.ingressChannel());
            channelUri.put("endpoint", leaderEndpoint.endpoint);
            leaderEndpoint.publication = this.publication = this.addIngressPublication(channelUri.toString(), this.ctx.ingressStreamId());
        }
        this.endpointByMemberIdMap.values().forEach(MemberEndpoint::disconnect);
        this.endpointByMemberIdMap = tempMap;
    }

    private void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int templateId = this.messageHeaderDecoder.templateId();
        if (2 == templateId) {
            this.egressMessageHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            long sessionId = this.egressMessageHeaderDecoder.clusterSessionId();
            if (sessionId == this.clusterSessionId) {
                this.egressListener.onMessage(sessionId, this.egressMessageHeaderDecoder.timestamp(), buffer, offset + 32, length - 32, header);
            }
        } else if (7 == templateId) {
            this.newLeaderEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            long sessionId = this.newLeaderEventDecoder.clusterSessionId();
            if (sessionId == this.clusterSessionId) {
                this.onNewLeader(sessionId, this.newLeaderEventDecoder.leadershipTermId(), this.newLeaderEventDecoder.leaderMemberId(), this.newLeaderEventDecoder.memberEndpoints());
            }
        } else if (3 == templateId) {
            this.sessionEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            long sessionId = this.sessionEventDecoder.clusterSessionId();
            if (sessionId == this.clusterSessionId) {
                this.egressListener.sessionEvent(this.sessionEventDecoder.correlationId(), sessionId, this.sessionEventDecoder.leadershipTermId(), this.sessionEventDecoder.leaderMemberId(), this.sessionEventDecoder.code(), this.sessionEventDecoder.detail());
            }
        }
    }

    private ControlledFragmentHandler.Action onControlledFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int templateId = this.messageHeaderDecoder.templateId();
        if (2 == templateId) {
            this.egressMessageHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            long sessionId = this.egressMessageHeaderDecoder.clusterSessionId();
            if (sessionId == this.clusterSessionId) {
                return this.controlledEgressListener.onMessage(sessionId, this.egressMessageHeaderDecoder.timestamp(), buffer, offset + 32, length - 32, header);
            }
        } else if (7 == templateId) {
            this.newLeaderEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            long sessionId = this.newLeaderEventDecoder.clusterSessionId();
            if (sessionId == this.clusterSessionId) {
                this.onNewLeader(sessionId, this.newLeaderEventDecoder.leadershipTermId(), this.newLeaderEventDecoder.leaderMemberId(), this.newLeaderEventDecoder.memberEndpoints());
                return ControlledFragmentHandler.Action.COMMIT;
            }
        } else if (3 == templateId) {
            this.sessionEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            long sessionId = this.sessionEventDecoder.clusterSessionId();
            if (sessionId == this.clusterSessionId) {
                this.controlledEgressListener.sessionEvent(this.sessionEventDecoder.correlationId(), sessionId, this.sessionEventDecoder.leadershipTermId(), this.sessionEventDecoder.leaderMemberId(), this.sessionEventDecoder.code(), this.sessionEventDecoder.detail());
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void closeSession() {
        this.idleStrategy.reset();
        int length = 24;
        SessionCloseRequestEncoder sessionCloseRequestEncoder = new SessionCloseRequestEncoder();
        int attempts = 3;
        while (true) {
            long result;
            if ((result = this.publication.tryClaim(24, this.bufferClaim)) > 0L) {
                sessionCloseRequestEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).clusterSessionId(this.clusterSessionId);
                this.bufferClaim.commit();
                break;
            }
            AeronCluster.checkResult(result);
            if (--attempts <= 0) break;
            this.idleStrategy.idle();
        }
    }

    private long connectToCluster() {
        long deadlineNs = this.nanoClock.nanoTime() + this.ctx.messageTimeoutNs();
        if (this.isUnicast) {
            this.updateMemberEndpoints(this.ctx.clusterMemberEndpoints(), -1);
            ChannelUri channelUri = ChannelUri.parse(this.ctx.ingressChannel());
            for (Object member : this.endpointByMemberIdMap.values()) {
                channelUri.put("endpoint", ((MemberEndpoint)member).endpoint);
                ((MemberEndpoint)member).publication = this.addIngressPublication(channelUri.toString(), this.ctx.ingressStreamId());
            }
            while (true) {
                MemberEndpoint connectedMember = null;
                for (MemberEndpoint member : this.endpointByMemberIdMap.values()) {
                    if (!member.publication.isConnected()) continue;
                    connectedMember = member;
                    break;
                }
                if (null != connectedMember) {
                    this.publication = connectedMember.publication;
                    EgressPoller poller = new EgressPoller(this.subscription, 1);
                    byte[] encodedCredentials = this.ctx.credentialsSupplier().encodedCredentials();
                    long clusterSessionId = this.openSession(deadlineNs, poller, encodedCredentials);
                    this.endpointByMemberIdMap.get((int)this.leaderMemberId).publication = null;
                    this.endpointByMemberIdMap.values().forEach(MemberEndpoint::disconnect);
                    return clusterSessionId;
                }
                this.checkDeadline(deadlineNs, "awaiting connection to cluster");
                this.idleStrategy.idle();
            }
        }
        this.publication = this.addIngressPublication(this.ctx.ingressChannel(), this.ctx.ingressStreamId());
        this.awaitConnectedPublication(deadlineNs);
        byte[] encodedCredentials = this.ctx.credentialsSupplier().encodedCredentials();
        return this.openSession(deadlineNs, new EgressPoller(this.subscription, 1), encodedCredentials);
    }

    private Publication addIngressPublication(String channel, int streamId) {
        if (this.ctx.isIngressExclusive()) {
            return this.aeron.addExclusivePublication(channel, streamId);
        }
        return this.aeron.addPublication(channel, streamId);
    }

    private long openSession(long deadlineNs, EgressPoller poller, byte[] encodedCredentials) {
        long correlationId = this.sendConnectRequest(this.publication, encodedCredentials, deadlineNs);
        while (true) {
            this.pollNextResponse(deadlineNs, poller);
            if (poller.correlationId() != correlationId) continue;
            if (poller.isChallenged()) {
                correlationId = this.sendChallengeResponse(poller.clusterSessionId(), this.ctx.credentialsSupplier().onChallenge(poller.encodedChallenge()), deadlineNs);
                continue;
            }
            switch (poller.eventCode()) {
                case OK: {
                    this.leadershipTermId = poller.leadershipTermId();
                    this.leaderMemberId = poller.leaderMemberId();
                    return poller.clusterSessionId();
                }
                case ERROR: {
                    throw new ClusterException(poller.detail());
                }
                case REDIRECT: {
                    this.updateMemberEndpoints(poller.detail(), poller.leaderMemberId());
                    this.awaitConnectedPublication(deadlineNs);
                    return this.openSession(deadlineNs, poller, encodedCredentials);
                }
                case AUTHENTICATION_REJECTED: {
                    throw new AuthenticationException(poller.detail());
                }
            }
        }
    }

    private void awaitConnectedPublication(long deadlineNs) {
        while (!this.publication.isConnected()) {
            this.checkDeadline(deadlineNs, "awaiting connection to cluster");
            this.idleStrategy.idle();
        }
    }

    private void pollNextResponse(long deadlineNs, EgressPoller poller) {
        this.idleStrategy.reset();
        while (poller.poll() <= 0 && !poller.isPollComplete()) {
            this.checkDeadline(deadlineNs, "awaiting response");
            this.idleStrategy.idle();
        }
    }

    private long sendConnectRequest(Publication publication, byte[] encodedCredentials, long deadlineNs) {
        long result;
        long correlationId = this.aeron.nextCorrelationId();
        SessionConnectRequestEncoder sessionConnectRequestEncoder = new SessionConnectRequestEncoder();
        ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
        sessionConnectRequestEncoder.wrapAndApplyHeader(buffer, 0, this.messageHeaderEncoder).correlationId(correlationId).responseStreamId(this.ctx.egressStreamId()).responseChannel(this.ctx.egressChannel()).putEncodedCredentials(encodedCredentials, 0, encodedCredentials.length);
        this.idleStrategy.reset();
        while ((result = publication.offer(buffer)) <= 0L) {
            if (-4L == result) {
                throw new ClusterException("unexpected close from cluster");
            }
            this.checkDeadline(deadlineNs, "failed to connect to cluster");
            this.idleStrategy.idle();
        }
        return correlationId;
    }

    private long sendChallengeResponse(long sessionId, byte[] encodedCredentials, long deadlineNs) {
        long result;
        long correlationId = this.aeron.nextCorrelationId();
        ChallengeResponseEncoder challengeResponseEncoder = new ChallengeResponseEncoder();
        ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
        challengeResponseEncoder.wrapAndApplyHeader(buffer, 0, this.messageHeaderEncoder).correlationId(correlationId).clusterSessionId(sessionId).putEncodedCredentials(encodedCredentials, 0, encodedCredentials.length);
        this.idleStrategy.reset();
        while ((result = this.publication.offer(buffer)) <= 0L) {
            AeronCluster.checkResult(result);
            this.checkDeadline(deadlineNs, "failed to connect to cluster");
            this.idleStrategy.idle();
        }
        return correlationId;
    }

    private void checkDeadline(long deadlineNs, String errorMessage) {
        if (Thread.interrupted()) {
            LangUtil.rethrowUnchecked(new InterruptedException());
        }
        if (deadlineNs - this.nanoClock.nanoTime() < 0L) {
            throw new TimeoutException(errorMessage);
        }
    }

    private static void checkResult(long result) {
        if (result == -1L || result == -4L || result == -5L) {
            throw new ClusterException("unexpected publication state: " + result);
        }
    }

    static final class MemberEndpoint {
        final int memberId;
        final String endpoint;
        Publication publication;

        MemberEndpoint(int memberId, String endpoint) {
            this.memberId = memberId;
            this.endpoint = endpoint;
        }

        void disconnect() {
            CloseHelper.close(this.publication);
            this.publication = null;
        }

        public String toString() {
            return "MemberEndpoint{memberId=" + this.memberId + ", endpoint='" + this.endpoint + '\'' + ", publication=" + this.publication + '}';
        }
    }

    public static class Context
    implements Cloneable {
        private long messageTimeoutNs = Configuration.messageTimeoutNs();
        private String clusterMemberEndpoints = Configuration.clusterMemberEndpoints();
        private String ingressChannel = Configuration.ingressChannel();
        private int ingressStreamId = Configuration.ingressStreamId();
        private String egressChannel = Configuration.egressChannel();
        private int egressStreamId = Configuration.egressStreamId();
        private IdleStrategy idleStrategy;
        private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
        private Aeron aeron;
        private CredentialsSupplier credentialsSupplier;
        private boolean ownsAeronClient = false;
        private boolean isIngressExclusive = false;
        private ErrorHandler errorHandler = Aeron.Configuration.DEFAULT_ERROR_HANDLER;
        private boolean isDirectAssemblers = false;
        private EgressListener egressListener;
        private ControlledEgressListener controlledEgressListener;

        public Context clone() {
            try {
                return (Context)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void conclude() {
            if (null == this.aeron) {
                this.aeron = Aeron.connect(new Aeron.Context().aeronDirectoryName(this.aeronDirectoryName).errorHandler(this.errorHandler));
                this.ownsAeronClient = true;
            }
            if (null == this.idleStrategy) {
                this.idleStrategy = new BackoffIdleStrategy(1L, 10L, 1000L, 1000L);
            }
            if (null == this.credentialsSupplier) {
                this.credentialsSupplier = new NullCredentialsSupplier();
            }
            if (null == this.egressListener) {
                this.egressListener = (clusterSessionId, timestamp, buffer, offset, length, header) -> {
                    throw new ConfigurationException("egressListener must be specified on AeronCluster.Context");
                };
            }
            if (null == this.controlledEgressListener) {
                this.controlledEgressListener = (clusterSessionId, timestamp, buffer, offset, length, header) -> {
                    throw new ConfigurationException("controlledEgressListener must be specified on AeronCluster.Context");
                };
            }
        }

        public Context messageTimeoutNs(long messageTimeoutNs) {
            this.messageTimeoutNs = messageTimeoutNs;
            return this;
        }

        public long messageTimeoutNs() {
            return this.messageTimeoutNs;
        }

        public Context clusterMemberEndpoints(String clusterMembers) {
            this.clusterMemberEndpoints = clusterMembers;
            return this;
        }

        public String clusterMemberEndpoints() {
            return this.clusterMemberEndpoints;
        }

        public Context ingressChannel(String channel) {
            this.ingressChannel = channel;
            return this;
        }

        public String ingressChannel() {
            return this.ingressChannel;
        }

        public Context ingressStreamId(int streamId) {
            this.ingressStreamId = streamId;
            return this;
        }

        public int ingressStreamId() {
            return this.ingressStreamId;
        }

        public Context egressChannel(String channel) {
            this.egressChannel = channel;
            return this;
        }

        public String egressChannel() {
            return this.egressChannel;
        }

        public Context egressStreamId(int streamId) {
            this.egressStreamId = streamId;
            return this;
        }

        public int egressStreamId() {
            return this.egressStreamId;
        }

        public Context idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Context aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Context aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public Aeron aeron() {
            return this.aeron;
        }

        public Context ownsAeronClient(boolean ownsAeronClient) {
            this.ownsAeronClient = ownsAeronClient;
            return this;
        }

        public boolean ownsAeronClient() {
            return this.ownsAeronClient;
        }

        public Context isIngressExclusive(boolean isIngressExclusive) {
            this.isIngressExclusive = isIngressExclusive;
            return this;
        }

        public boolean isIngressExclusive() {
            return this.isIngressExclusive;
        }

        public Context credentialsSupplier(CredentialsSupplier credentialsSupplier) {
            this.credentialsSupplier = credentialsSupplier;
            return this;
        }

        public CredentialsSupplier credentialsSupplier() {
            return this.credentialsSupplier;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context isDirectAssemblers(boolean isDirectAssemblers) {
            this.isDirectAssemblers = isDirectAssemblers;
            return this;
        }

        public boolean isDirectAssemblers() {
            return this.isDirectAssemblers;
        }

        public Context egressListener(EgressListener listener) {
            this.egressListener = listener;
            return this;
        }

        public EgressListener egressListener() {
            return this.egressListener;
        }

        public Context controlledEgressListener(ControlledEgressListener listener) {
            this.controlledEgressListener = listener;
            return this;
        }

        public ControlledEgressListener controlledEgressListener() {
            return this.controlledEgressListener;
        }

        public void close() {
            if (this.ownsAeronClient) {
                CloseHelper.close(this.aeron);
            }
        }
    }

    public static class Configuration {
        public static final String MESSAGE_TIMEOUT_PROP_NAME = "aeron.cluster.message.timeout";
        public static final long MESSAGE_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(5L);
        public static final String CLUSTER_MEMBER_ENDPOINTS_PROP_NAME = "aeron.cluster.member.endpoints";
        public static final String CLUSTER_MEMBER_ENDPOINTS_DEFAULT = null;
        public static final String INGRESS_CHANNEL_PROP_NAME = "aeron.cluster.ingress.channel";
        public static final String INGRESS_CHANNEL_DEFAULT = "aeron:udp?endpoint=localhost:9010";
        public static final String INGRESS_STREAM_ID_PROP_NAME = "aeron.cluster.ingress.stream.id";
        public static final int INGRESS_STREAM_ID_DEFAULT = 101;
        public static final String EGRESS_CHANNEL_PROP_NAME = "aeron.cluster.egress.channel";
        public static final String EGRESS_CHANNEL_DEFAULT = "aeron:udp?endpoint=localhost:9020";
        public static final String EGRESS_STREAM_ID_PROP_NAME = "aeron.cluster.egress.stream.id";
        public static final int EGRESS_STREAM_ID_DEFAULT = 102;

        public static long messageTimeoutNs() {
            return SystemUtil.getDurationInNanos(MESSAGE_TIMEOUT_PROP_NAME, MESSAGE_TIMEOUT_DEFAULT_NS);
        }

        public static String clusterMemberEndpoints() {
            return System.getProperty(CLUSTER_MEMBER_ENDPOINTS_PROP_NAME, CLUSTER_MEMBER_ENDPOINTS_DEFAULT);
        }

        public static String ingressChannel() {
            return System.getProperty(INGRESS_CHANNEL_PROP_NAME, INGRESS_CHANNEL_DEFAULT);
        }

        public static int ingressStreamId() {
            return Integer.getInteger(INGRESS_STREAM_ID_PROP_NAME, 101);
        }

        public static String egressChannel() {
            return System.getProperty(EGRESS_CHANNEL_PROP_NAME, EGRESS_CHANNEL_DEFAULT);
        }

        public static int egressStreamId() {
            return Integer.getInteger(EGRESS_STREAM_ID_PROP_NAME, 102);
        }
    }
}

