/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.ConsensusModuleSnapshotTaker;
import java.util.concurrent.TimeUnit;
import org.agrona.DeadlineTimerWheel;
import org.agrona.collections.Long2LongHashMap;

class TimerService
implements DeadlineTimerWheel.TimerHandler {
    private static final int MAX_ITERATIONS_PER_POLL = 10000000;
    private final ConsensusModuleAgent consensusModuleAgent;
    private final DeadlineTimerWheel timerWheel = new DeadlineTimerWheel(TimeUnit.MILLISECONDS, 0L, 1, 128);
    private final Long2LongHashMap timerIdByCorrelationIdMap = new Long2LongHashMap(Long.MAX_VALUE);
    private final Long2LongHashMap correlationIdByTimerIdMap = new Long2LongHashMap(Long.MAX_VALUE);

    TimerService(ConsensusModuleAgent consensusModuleAgent) {
        this.consensusModuleAgent = consensusModuleAgent;
    }

    int poll(long nowMs) {
        int expired = 0;
        int iterations = 0;
        while ((expired += this.timerWheel.poll(nowMs, this, 10)) < 10 && this.currentTickTimeMs() < nowMs && ++iterations < 10000000) {
        }
        return expired;
    }

    long timerCount() {
        return this.timerWheel.timerCount();
    }

    long currentTickTimeMs() {
        return this.timerWheel.currentTickTime();
    }

    void resetStartTime(long startTime) {
        this.timerWheel.resetStartTime(startTime);
    }

    @Override
    public boolean onTimerExpiry(TimeUnit timeUnit, long now, long timerId) {
        long correlationId = this.correlationIdByTimerIdMap.remove(timerId);
        this.timerIdByCorrelationIdMap.remove(correlationId);
        return this.consensusModuleAgent.onTimerEvent(correlationId, now);
    }

    void scheduleTimer(long correlationId, long deadlineMs) {
        this.cancelTimer(correlationId);
        long timerId = this.timerWheel.scheduleTimer(deadlineMs);
        this.timerIdByCorrelationIdMap.put(correlationId, timerId);
        this.correlationIdByTimerIdMap.put(timerId, correlationId);
    }

    boolean cancelTimer(long correlationId) {
        long timerId = this.timerIdByCorrelationIdMap.remove(correlationId);
        if (Long.MAX_VALUE != timerId) {
            this.timerWheel.cancelTimer(timerId);
            this.correlationIdByTimerIdMap.remove(timerId);
            return true;
        }
        return false;
    }

    void snapshot(ConsensusModuleSnapshotTaker snapshotTaker) {
        Long2LongHashMap.EntryIterator iter = this.timerIdByCorrelationIdMap.entrySet().iterator();
        while (iter.hasNext()) {
            iter.next();
            long correlationId = iter.getLongKey();
            long deadline = this.timerWheel.deadline(iter.getLongValue());
            snapshotTaker.snapshotTimer(correlationId, deadline);
        }
    }
}

