/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Publication;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.ClusterMembersResponseEncoder;
import io.aeron.cluster.codecs.ElectionStartEventEncoder;
import io.aeron.cluster.codecs.JoinLogEncoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.ServiceTerminationPositionEncoder;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.CloseHelper;

final class ServiceProxy
implements AutoCloseable {
    private static final int SEND_ATTEMPTS = 3;
    private final BufferClaim bufferClaim = new BufferClaim();
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final JoinLogEncoder joinLogEncoder = new JoinLogEncoder();
    private final ClusterMembersResponseEncoder clusterMembersResponseEncoder = new ClusterMembersResponseEncoder();
    private final ServiceTerminationPositionEncoder serviceTerminationPositionEncoder = new ServiceTerminationPositionEncoder();
    private final ElectionStartEventEncoder electionStartEventEncoder = new ElectionStartEventEncoder();
    private final Publication publication;

    ServiceProxy(Publication publication) {
        this.publication = publication;
    }

    @Override
    public void close() {
        CloseHelper.close(this.publication);
    }

    void joinLog(long leadershipTermId, long logPosition, long maxLogPosition, int memberId, int logSessionId, int logStreamId, String channel) {
        int length = 44 + JoinLogEncoder.logChannelHeaderLength() + channel.length();
        int attempts = 6;
        do {
            long result;
            if ((result = this.publication.tryClaim(length, this.bufferClaim)) > 0L) {
                this.joinLogEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).maxLogPosition(maxLogPosition).memberId(memberId).logSessionId(logSessionId).logStreamId(logStreamId).logChannel(channel);
                this.bufferClaim.commit();
                return;
            }
            ServiceProxy.checkResult(result);
        } while (--attempts > 0);
        throw new ClusterException("failed to send join log request");
    }

    void clusterMembersResponse(long correlationId, int leaderMemberId, String activeMembers, String passiveFollowers) {
        int length = 20 + ClusterMembersResponseEncoder.activeMembersHeaderLength() + activeMembers.length() + ClusterMembersResponseEncoder.passiveFollowersHeaderLength() + passiveFollowers.length();
        int attempts = 6;
        do {
            long result;
            if ((result = this.publication.tryClaim(length, this.bufferClaim)) > 0L) {
                this.clusterMembersResponseEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).leaderMemberId(leaderMemberId).activeMembers(activeMembers).passiveFollowers(passiveFollowers);
                this.bufferClaim.commit();
                return;
            }
            ServiceProxy.checkResult(result);
        } while (--attempts > 0);
        throw new ClusterException("failed to send cluster members response");
    }

    void terminationPosition(long logPosition) {
        int length = 16;
        int attempts = 6;
        do {
            long result;
            if ((result = this.publication.tryClaim(16, this.bufferClaim)) > 0L) {
                this.serviceTerminationPositionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logPosition(logPosition);
                this.bufferClaim.commit();
                return;
            }
            ServiceProxy.checkResult(result);
        } while (--attempts > 0);
        throw new ClusterException("failed to send service termination position");
    }

    void electionStartEvent(long logPosition) {
        int length = 16;
        int attempts = 6;
        do {
            long result;
            if ((result = this.publication.tryClaim(16, this.bufferClaim)) > 0L) {
                this.electionStartEventEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logPosition(logPosition);
                this.bufferClaim.commit();
                return;
            }
            ServiceProxy.checkResult(result);
        } while (--attempts > 0);
        throw new ClusterException("failed to send election start event");
    }

    private static void checkResult(long result) {
        if (result == -1L || result == -4L || result == -5L) {
            throw new AeronException("unexpected publication state: " + result);
        }
    }
}

