/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.archive.client.AeronArchive;
import io.aeron.cluster.RecordingExtent;
import io.aeron.cluster.client.ClusterException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.UnsafeBuffer;

public class RecordingLog
implements AutoCloseable {
    public static final String RECORDING_LOG_FILE_NAME = "recording.log";
    public static final int ENTRY_TYPE_TERM = 0;
    public static final int ENTRY_TYPE_SNAPSHOT = 1;
    public static final int RECORDING_ID_OFFSET = 0;
    public static final int LEADERSHIP_TERM_ID_OFFSET = 8;
    public static final int TERM_BASE_LOG_POSITION_OFFSET = 16;
    public static final int LOG_POSITION_OFFSET = 24;
    public static final int TIMESTAMP_OFFSET = 32;
    public static final int SERVICE_ID_OFFSET = 40;
    public static final int ENTRY_TYPE_OFFSET = 44;
    private static final int ENTRY_LENGTH = BitUtil.align(48, 64);
    private int nextEntryIndex;
    private final FileChannel fileChannel;
    private final ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4096).order(ByteOrder.LITTLE_ENDIAN);
    private final UnsafeBuffer buffer = new UnsafeBuffer(this.byteBuffer);
    private final ArrayList<Entry> entries = new ArrayList();
    private final Long2LongHashMap indexByLeadershipTermIdMap = new Long2LongHashMap(-1L);

    public RecordingLog(File parentDir) {
        File logFile = new File(parentDir, RECORDING_LOG_FILE_NAME);
        boolean newFile = !logFile.exists();
        try {
            this.fileChannel = FileChannel.open(logFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
            if (newFile) {
                RecordingLog.syncDirectory(parentDir);
            } else {
                this.reload();
            }
        }
        catch (IOException ex) {
            throw new ClusterException(ex);
        }
    }

    @Override
    public void close() {
        CloseHelper.close(this.fileChannel);
    }

    public void force() {
        try {
            this.fileChannel.force(true);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public int nextEntryIndex() {
        return this.nextEntryIndex;
    }

    public void reload() {
        this.entries.clear();
        this.indexByLeadershipTermIdMap.clear();
        this.indexByLeadershipTermIdMap.compact();
        this.nextEntryIndex = 0;
        this.byteBuffer.clear();
        try {
            int bytes;
            do {
                bytes = this.fileChannel.read(this.byteBuffer);
                if (this.byteBuffer.remaining() != 0) continue;
                this.byteBuffer.flip();
                this.captureEntriesFromBuffer(this.byteBuffer, this.buffer, this.entries);
                this.byteBuffer.clear();
            } while (-1 != bytes);
            if (this.byteBuffer.position() > 0) {
                this.byteBuffer.flip();
                this.captureEntriesFromBuffer(this.byteBuffer, this.buffer, this.entries);
                this.byteBuffer.clear();
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    public Entry getTermEntry(long leadershipTermId) {
        int index = (int)this.indexByLeadershipTermIdMap.get(leadershipTermId);
        if (-1 == index) {
            throw new ClusterException("unknown leadershipTermId=" + leadershipTermId);
        }
        return this.entries.get(index);
    }

    public Entry getLatestSnapshot(int serviceId) {
        for (int i = this.entries.size() - 1; i >= 0; --i) {
            Entry entry = this.entries.get(i);
            if (1 != entry.type || serviceId != entry.serviceId) continue;
            return entry;
        }
        return null;
    }

    public RecoveryPlan createRecoveryPlan(AeronArchive archive, int serviceCount) {
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        ArrayList<Log> logs = new ArrayList<Log>();
        RecordingLog.planRecovery(snapshots, logs, this.entries, archive, serviceCount);
        long lastLeadershipTermId = -1L;
        long lastTermBaseLogPosition = 0L;
        long committedLogPosition = -1L;
        long appendedLogPosition = 0L;
        int snapshotStepsSize = snapshots.size();
        if (snapshotStepsSize > 0) {
            Snapshot snapshot = snapshots.get(0);
            lastLeadershipTermId = snapshot.leadershipTermId;
            lastTermBaseLogPosition = snapshot.termBaseLogPosition;
            appendedLogPosition = snapshot.logPosition;
            committedLogPosition = snapshot.logPosition;
        }
        if (!logs.isEmpty()) {
            Log log = logs.get(0);
            lastLeadershipTermId = log.leadershipTermId;
            lastTermBaseLogPosition = log.termBaseLogPosition;
            appendedLogPosition = log.stopPosition;
            committedLogPosition = log.logPosition;
        }
        return new RecoveryPlan(lastLeadershipTermId, lastTermBaseLogPosition, appendedLogPosition, committedLogPosition, snapshots, logs);
    }

    public static RecoveryPlan createRecoveryPlan(ArrayList<Snapshot> snapshots) {
        long lastLeadershipTermId = -1L;
        long lastTermBaseLogPosition = 0L;
        long committedLogPosition = -1L;
        long appendedLogPosition = 0L;
        int snapshotStepsSize = snapshots.size();
        if (snapshotStepsSize > 0) {
            Snapshot snapshot = snapshots.get(0);
            lastLeadershipTermId = snapshot.leadershipTermId;
            lastTermBaseLogPosition = snapshot.termBaseLogPosition;
            appendedLogPosition = snapshot.logPosition;
            committedLogPosition = snapshot.logPosition;
        }
        return new RecoveryPlan(lastLeadershipTermId, lastTermBaseLogPosition, appendedLogPosition, committedLogPosition, snapshots, new ArrayList<Log>());
    }

    public boolean hasTermBeenAppended(long leadershipTermId) {
        int index = (int)this.indexByLeadershipTermIdMap.get(leadershipTermId);
        return -1 != index;
    }

    public void appendTerm(long recordingId, long leadershipTermId, long termBaseLogPosition, long timestamp) {
        int size = this.entries.size();
        if (size > 0) {
            Entry lastEntry = this.entries.get(size - 1);
            if (lastEntry.type != -1 && lastEntry.leadershipTermId >= leadershipTermId) {
                throw new ClusterException("leadershipTermId out of sequence: previous " + lastEntry.leadershipTermId + " this " + leadershipTermId);
            }
        }
        this.indexByLeadershipTermIdMap.put(leadershipTermId, this.nextEntryIndex);
        this.append(0, recordingId, leadershipTermId, termBaseLogPosition, -1L, timestamp, -1);
    }

    public void appendSnapshot(long recordingId, long leadershipTermId, long termBaseLogPosition, long logPosition, long timestamp, int serviceId) {
        int size = this.entries.size();
        if (size > 0) {
            Entry entry = this.entries.get(size - 1);
            if (entry.type == 0 && entry.leadershipTermId != leadershipTermId) {
                throw new ClusterException("leadershipTermId out of sequence: previous " + entry.leadershipTermId + " this " + leadershipTermId);
            }
        }
        this.append(1, recordingId, leadershipTermId, termBaseLogPosition, logPosition, timestamp, serviceId);
    }

    public void commitLogPosition(long leadershipTermId, long logPosition) {
        int index = this.getLeadershipTermEntryIndex(leadershipTermId);
        this.commitEntryValue(index, logPosition, 24);
        Entry entry = this.entries.get(index);
        this.entries.set(index, new Entry(entry.recordingId, entry.leadershipTermId, entry.termBaseLogPosition, logPosition, entry.timestamp, entry.serviceId, entry.type, entry.entryIndex));
    }

    public void tombstoneEntry(long leadershipTermId, int entryIndex) {
        int index = -1;
        int size = this.entries.size();
        for (int i = 0; i < size; ++i) {
            Entry entry = this.entries.get(i);
            if (entry.leadershipTermId != leadershipTermId || entry.entryIndex != entryIndex) continue;
            index = entry.entryIndex;
            if (0 != entry.type) break;
            this.indexByLeadershipTermIdMap.remove(leadershipTermId);
            break;
        }
        if (-1 == index) {
            throw new ClusterException("unknown entry index: " + entryIndex);
        }
        this.buffer.putInt(0, -1, ByteOrder.LITTLE_ENDIAN);
        this.byteBuffer.limit(4).position(0);
        long filePosition = (long)index * (long)ENTRY_LENGTH + 44L;
        try {
            if (4 != this.fileChannel.write(this.byteBuffer, filePosition)) {
                throw new ClusterException("failed to write field atomically");
            }
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    public String toString() {
        return "RecordingLog{entries=" + this.entries + '}';
    }

    private void append(int entryType, long recordingId, long leadershipTermId, long termBaseLogPosition, long logPosition, long timestamp, int serviceId) {
        this.buffer.putLong(0, recordingId, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putLong(8, leadershipTermId, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putLong(16, termBaseLogPosition, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putLong(24, logPosition, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putLong(32, timestamp, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putInt(40, serviceId, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putInt(44, entryType, ByteOrder.LITTLE_ENDIAN);
        this.byteBuffer.limit(ENTRY_LENGTH).position(0);
        try {
            if (ENTRY_LENGTH != this.fileChannel.write(this.byteBuffer)) {
                throw new ClusterException("failed to write entry atomically");
            }
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        this.entries.add(new Entry(recordingId, leadershipTermId, termBaseLogPosition, logPosition, timestamp, serviceId, entryType, this.nextEntryIndex++));
    }

    private void captureEntriesFromBuffer(ByteBuffer byteBuffer, UnsafeBuffer buffer, ArrayList<Entry> entries) {
        int length = byteBuffer.limit();
        for (int i = 0; i < length; i += ENTRY_LENGTH) {
            int entryType = buffer.getInt(i + 44);
            if (-1 != entryType) {
                Entry entry = new Entry(buffer.getLong(i + 0, ByteOrder.LITTLE_ENDIAN), buffer.getLong(i + 8, ByteOrder.LITTLE_ENDIAN), buffer.getLong(i + 16, ByteOrder.LITTLE_ENDIAN), buffer.getLong(i + 24, ByteOrder.LITTLE_ENDIAN), buffer.getLong(i + 32, ByteOrder.LITTLE_ENDIAN), buffer.getInt(i + 40, ByteOrder.LITTLE_ENDIAN), entryType, this.nextEntryIndex);
                entries.add(entry);
                if (0 == entryType) {
                    this.indexByLeadershipTermIdMap.put(entry.leadershipTermId, this.nextEntryIndex);
                }
            }
            ++this.nextEntryIndex;
        }
    }

    private static void syncDirectory(File dir) {
        try (FileChannel fileChannel = FileChannel.open(dir.toPath(), new OpenOption[0]);){
            fileChannel.force(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void getRecordingExtent(AeronArchive archive, RecordingExtent recordingExtent, Entry entry) {
        if (archive.listRecording(entry.recordingId, recordingExtent) == 0) {
            throw new ClusterException("unknown recording id: " + entry.recordingId);
        }
    }

    private int getLeadershipTermEntryIndex(long leadershipTermId) {
        int size = this.entries.size();
        for (int i = 0; i < size; ++i) {
            Entry entry = this.entries.get(i);
            if (entry.leadershipTermId != leadershipTermId || entry.type != 0) continue;
            return entry.entryIndex;
        }
        throw new ClusterException("unknown leadershipTermId: " + leadershipTermId);
    }

    private void commitEntryValue(int entryIndex, long value, int fieldOffset) {
        this.buffer.putLong(0, value, ByteOrder.LITTLE_ENDIAN);
        this.byteBuffer.limit(8).position(0);
        long filePosition = (long)entryIndex * (long)ENTRY_LENGTH + (long)fieldOffset;
        try {
            if (8 != this.fileChannel.write(this.byteBuffer, filePosition)) {
                throw new ClusterException("failed to write field atomically");
            }
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    private static void planRecovery(ArrayList<Snapshot> snapshots, ArrayList<Log> logs, ArrayList<Entry> entries, AeronArchive archive, int serviceCount) {
        Entry entry;
        if (entries.isEmpty()) {
            return;
        }
        int logIndex = -1;
        int snapshotIndex = -1;
        for (int i = entries.size() - 1; i >= 0; --i) {
            entry = entries.get(i);
            if (-1 == snapshotIndex && 1 == entry.type) {
                snapshotIndex = i;
                continue;
            }
            if (-1 == logIndex && 0 == entry.type && -1L != entry.recordingId) {
                logIndex = i;
                continue;
            }
            if (-1 != snapshotIndex && -1 != logIndex) break;
        }
        RecordingExtent recordingExtent = new RecordingExtent();
        if (-1 != snapshotIndex) {
            RecordingLog.addSnapshots(snapshots, entries, serviceCount, snapshotIndex);
        }
        if (-1 != logIndex) {
            entry = entries.get(logIndex);
            RecordingLog.getRecordingExtent(archive, recordingExtent, entry);
            long startPosition = -1 == snapshotIndex ? recordingExtent.startPosition : snapshots.get((int)0).logPosition;
            logs.add(new Log(entry.recordingId, entry.leadershipTermId, entry.termBaseLogPosition, entry.logPosition, startPosition, recordingExtent.stopPosition, recordingExtent.initialTermId, recordingExtent.termBufferLength, recordingExtent.mtuLength, recordingExtent.sessionId));
        }
    }

    static void addSnapshots(ArrayList<Snapshot> snapshots, ArrayList<Entry> entries, int serviceCount, int snapshotIndex) {
        Entry snapshot = entries.get(snapshotIndex);
        snapshots.add(new Snapshot(snapshot.recordingId, snapshot.leadershipTermId, snapshot.termBaseLogPosition, snapshot.logPosition, snapshot.timestamp, snapshot.serviceId));
        for (int i = 1; i <= serviceCount; ++i) {
            if (snapshotIndex - i < 0) {
                throw new ClusterException("snapshot missing for service at index " + i + " in " + entries);
            }
            Entry entry = entries.get(snapshotIndex - i);
            if (1 != entry.type || entry.leadershipTermId != snapshot.leadershipTermId || entry.logPosition != snapshot.logPosition) continue;
            snapshots.add(entry.serviceId + 1, new Snapshot(entry.recordingId, entry.leadershipTermId, entry.termBaseLogPosition, entry.logPosition, entry.timestamp, entry.serviceId));
        }
    }

    public static class RecoveryPlan {
        public final long lastLeadershipTermId;
        public final long lastTermBaseLogPosition;
        public final long appendedLogPosition;
        public final long committedLogPosition;
        public final ArrayList<Snapshot> snapshots;
        public final ArrayList<Log> logs;

        public RecoveryPlan(long lastLeadershipTermId, long lastTermBaseLogPosition, long appendedLogPosition, long committedLogPosition, ArrayList<Snapshot> snapshots, ArrayList<Log> logs) {
            this.lastLeadershipTermId = lastLeadershipTermId;
            this.lastTermBaseLogPosition = lastTermBaseLogPosition;
            this.appendedLogPosition = appendedLogPosition;
            this.committedLogPosition = committedLogPosition;
            this.snapshots = snapshots;
            this.logs = logs;
        }

        public boolean hasReplay() {
            boolean hasReplay = false;
            if (this.logs.size() > 0) {
                Log log = this.logs.get(0);
                hasReplay = log.stopPosition > log.startPosition;
            }
            return hasReplay;
        }

        public String toString() {
            return "RecoveryPlan{lastLeadershipTermId=" + this.lastLeadershipTermId + ", lastTermBaseLogPosition=" + this.lastTermBaseLogPosition + ", appendedLogPosition=" + this.appendedLogPosition + ", committedLogPosition=" + this.committedLogPosition + ", snapshots=" + this.snapshots + ", logs=" + this.logs + '}';
        }
    }

    public static final class Log {
        public final long recordingId;
        public final long leadershipTermId;
        public final long termBaseLogPosition;
        public final long logPosition;
        public final long startPosition;
        public final long stopPosition;
        public final int initialTermId;
        public final int termBufferLength;
        public final int mtuLength;
        public final int sessionId;

        public Log(long recordingId, long leadershipTermId, long termBaseLogPosition, long logPosition, long startPosition, long stopPosition, int initialTermId, int termBufferLength, int mtuLength, int sessionId) {
            this.recordingId = recordingId;
            this.leadershipTermId = leadershipTermId;
            this.termBaseLogPosition = termBaseLogPosition;
            this.logPosition = logPosition;
            this.startPosition = startPosition;
            this.stopPosition = stopPosition;
            this.initialTermId = initialTermId;
            this.termBufferLength = termBufferLength;
            this.mtuLength = mtuLength;
            this.sessionId = sessionId;
        }

        public String toString() {
            return "Log{recordingId=" + this.recordingId + ", leadershipTermId=" + this.leadershipTermId + ", termBaseLogPosition=" + this.termBaseLogPosition + ", logPosition=" + this.logPosition + ", startPosition=" + this.startPosition + ", stopPosition=" + this.stopPosition + ", initialTermId=" + this.initialTermId + ", termBufferLength=" + this.termBufferLength + ", mtuLength=" + this.mtuLength + ", sessionId=" + this.sessionId + '}';
        }
    }

    public static final class Snapshot {
        public final long recordingId;
        public final long leadershipTermId;
        public final long termBaseLogPosition;
        public final long logPosition;
        public final long timestamp;
        public final int serviceId;

        public Snapshot(long recordingId, long leadershipTermId, long termBaseLogPosition, long logPosition, long timestamp, int serviceId) {
            this.recordingId = recordingId;
            this.leadershipTermId = leadershipTermId;
            this.termBaseLogPosition = termBaseLogPosition;
            this.logPosition = logPosition;
            this.timestamp = timestamp;
            this.serviceId = serviceId;
        }

        public String toString() {
            return "Snapshot{recordingId=" + this.recordingId + ", leadershipTermId=" + this.leadershipTermId + ", termBaseLogPosition=" + this.termBaseLogPosition + ", logPosition=" + this.logPosition + ", timestamp=" + this.timestamp + ", serviceId=" + this.serviceId + '}';
        }
    }

    public static final class Entry {
        public final long recordingId;
        public final long leadershipTermId;
        public final long termBaseLogPosition;
        public final long logPosition;
        public final long timestamp;
        public final int serviceId;
        public final int type;
        public final int entryIndex;

        public Entry(long recordingId, long leadershipTermId, long termBaseLogPosition, long logPosition, long timestamp, int serviceId, int type, int entryIndex) {
            this.recordingId = recordingId;
            this.leadershipTermId = leadershipTermId;
            this.termBaseLogPosition = termBaseLogPosition;
            this.logPosition = logPosition;
            this.timestamp = timestamp;
            this.serviceId = serviceId;
            this.type = type;
            this.entryIndex = entryIndex;
        }

        public String toString() {
            return "Entry{recordingId=" + this.recordingId + ", leadershipTermId=" + this.leadershipTermId + ", termBaseLogPosition=" + this.termBaseLogPosition + ", logPosition=" + this.logPosition + ", timestamp=" + this.timestamp + ", serviceId=" + this.serviceId + ", type=" + this.type + ", entryIndex=" + this.entryIndex + '}';
        }
    }
}

