/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.FragmentAssembler;
import io.aeron.Subscription;
import io.aeron.cluster.MemberStatusListener;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.AddPassiveMemberDecoder;
import io.aeron.cluster.codecs.AppendedPositionDecoder;
import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.CanvassPositionDecoder;
import io.aeron.cluster.codecs.CatchupPositionDecoder;
import io.aeron.cluster.codecs.ClusterMembersChangeDecoder;
import io.aeron.cluster.codecs.CommitPositionDecoder;
import io.aeron.cluster.codecs.JoinClusterDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.NewLeadershipTermDecoder;
import io.aeron.cluster.codecs.RequestVoteDecoder;
import io.aeron.cluster.codecs.SnapshotRecordingQueryDecoder;
import io.aeron.cluster.codecs.SnapshotRecordingsDecoder;
import io.aeron.cluster.codecs.StopCatchupDecoder;
import io.aeron.cluster.codecs.TerminationAckDecoder;
import io.aeron.cluster.codecs.TerminationPositionDecoder;
import io.aeron.cluster.codecs.VoteDecoder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;

class MemberStatusAdapter
implements FragmentHandler,
AutoCloseable {
    private static final int FRAGMENT_POLL_LIMIT = 10;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final CanvassPositionDecoder canvassPositionDecoder = new CanvassPositionDecoder();
    private final RequestVoteDecoder requestVoteDecoder = new RequestVoteDecoder();
    private final VoteDecoder voteDecoder = new VoteDecoder();
    private final NewLeadershipTermDecoder newLeadershipTermDecoder = new NewLeadershipTermDecoder();
    private final AppendedPositionDecoder appendedPositionDecoder = new AppendedPositionDecoder();
    private final CommitPositionDecoder commitPositionDecoder = new CommitPositionDecoder();
    private final CatchupPositionDecoder catchupPositionDecoder = new CatchupPositionDecoder();
    private final StopCatchupDecoder stopCatchupDecoder = new StopCatchupDecoder();
    private final AddPassiveMemberDecoder addPassiveMemberDecoder = new AddPassiveMemberDecoder();
    private final ClusterMembersChangeDecoder clusterMembersChangeDecoder = new ClusterMembersChangeDecoder();
    private final SnapshotRecordingQueryDecoder snapshotRecordingQueryDecoder = new SnapshotRecordingQueryDecoder();
    private final SnapshotRecordingsDecoder snapshotRecordingsDecoder = new SnapshotRecordingsDecoder();
    private final JoinClusterDecoder joinClusterDecoder = new JoinClusterDecoder();
    private final TerminationPositionDecoder terminationPositionDecoder = new TerminationPositionDecoder();
    private final TerminationAckDecoder terminationAckDecoder = new TerminationAckDecoder();
    private final FragmentAssembler fragmentAssembler = new FragmentAssembler(this);
    private final Subscription subscription;
    private final MemberStatusListener memberStatusListener;

    MemberStatusAdapter(Subscription subscription, MemberStatusListener memberStatusListener) {
        this.subscription = subscription;
        this.memberStatusListener = memberStatusListener;
    }

    @Override
    public void close() {
        CloseHelper.close(this.subscription);
    }

    public int poll() {
        return this.subscription.poll(this.fragmentAssembler, 10);
    }

    public int poll(int limit) {
        return this.subscription.poll(this.fragmentAssembler, limit);
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.sbeSchemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        int templateId = this.messageHeaderDecoder.templateId();
        switch (templateId) {
            case 50: {
                this.canvassPositionDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.memberStatusListener.onCanvassPosition(this.canvassPositionDecoder.logLeadershipTermId(), this.canvassPositionDecoder.logPosition(), this.canvassPositionDecoder.followerMemberId());
                break;
            }
            case 51: {
                this.requestVoteDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.memberStatusListener.onRequestVote(this.requestVoteDecoder.logLeadershipTermId(), this.requestVoteDecoder.logPosition(), this.requestVoteDecoder.candidateTermId(), this.requestVoteDecoder.candidateMemberId());
                break;
            }
            case 52: {
                this.voteDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.memberStatusListener.onVote(this.voteDecoder.candidateTermId(), this.voteDecoder.logLeadershipTermId(), this.voteDecoder.logPosition(), this.voteDecoder.candidateMemberId(), this.voteDecoder.followerMemberId(), this.voteDecoder.vote() == BooleanType.TRUE);
                break;
            }
            case 53: {
                this.newLeadershipTermDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.memberStatusListener.onNewLeadershipTerm(this.newLeadershipTermDecoder.logLeadershipTermId(), this.newLeadershipTermDecoder.logPosition(), this.newLeadershipTermDecoder.leadershipTermId(), this.newLeadershipTermDecoder.maxLogPosition(), this.newLeadershipTermDecoder.leaderMemberId(), this.newLeadershipTermDecoder.logSessionId());
                break;
            }
            case 54: {
                this.appendedPositionDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.memberStatusListener.onAppendedPosition(this.appendedPositionDecoder.leadershipTermId(), this.appendedPositionDecoder.logPosition(), this.appendedPositionDecoder.followerMemberId());
                break;
            }
            case 55: {
                this.commitPositionDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.memberStatusListener.onCommitPosition(this.commitPositionDecoder.leadershipTermId(), this.commitPositionDecoder.logPosition(), this.commitPositionDecoder.leaderMemberId());
                break;
            }
            case 56: {
                this.catchupPositionDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.memberStatusListener.onCatchupPosition(this.catchupPositionDecoder.leadershipTermId(), this.catchupPositionDecoder.logPosition(), this.catchupPositionDecoder.followerMemberId());
                break;
            }
            case 57: {
                this.stopCatchupDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.memberStatusListener.onStopCatchup(this.stopCatchupDecoder.leadershipTermId(), this.stopCatchupDecoder.logPosition(), this.stopCatchupDecoder.followerMemberId());
                break;
            }
            case 70: {
                this.addPassiveMemberDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.memberStatusListener.onAddPassiveMember(this.addPassiveMemberDecoder.correlationId(), this.addPassiveMemberDecoder.memberEndpoints());
                break;
            }
            case 71: {
                this.clusterMembersChangeDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.memberStatusListener.onClusterMembersChange(this.clusterMembersChangeDecoder.correlationId(), this.clusterMembersChangeDecoder.leaderMemberId(), this.clusterMembersChangeDecoder.activeMembers(), this.clusterMembersChangeDecoder.passiveMembers());
                break;
            }
            case 72: {
                this.snapshotRecordingQueryDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.memberStatusListener.onSnapshotRecordingQuery(this.snapshotRecordingQueryDecoder.correlationId(), this.snapshotRecordingQueryDecoder.requestMemberId());
                break;
            }
            case 73: {
                this.snapshotRecordingsDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.memberStatusListener.onSnapshotRecordings(this.snapshotRecordingsDecoder.correlationId(), this.snapshotRecordingsDecoder);
                break;
            }
            case 74: {
                this.joinClusterDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.memberStatusListener.onJoinCluster(this.joinClusterDecoder.leadershipTermId(), this.joinClusterDecoder.memberId());
                break;
            }
            case 75: {
                this.terminationPositionDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.memberStatusListener.onTerminationPosition(this.terminationPositionDecoder.logPosition());
                break;
            }
            case 76: {
                this.terminationAckDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.memberStatusListener.onTerminationAck(this.terminationAckDecoder.logPosition(), this.terminationAckDecoder.memberId());
            }
        }
    }
}

