/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Subscription;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.ClusterMembersResponseDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;

class MemberServiceAdapter
implements FragmentHandler,
AutoCloseable {
    private final Subscription subscription;
    private final MemberServiceHandler handler;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ClusterMembersResponseDecoder clusterMembersResponseDecoder = new ClusterMembersResponseDecoder();

    MemberServiceAdapter(Subscription subscription, MemberServiceHandler handler) {
        this.subscription = subscription;
        this.handler = handler;
    }

    @Override
    public void close() {
        CloseHelper.close(this.subscription);
    }

    public int poll() {
        return this.subscription.poll(this, 1);
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.sbeSchemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        int templateId = this.messageHeaderDecoder.templateId();
        if (templateId == 41) {
            this.clusterMembersResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            this.handler.onClusterMembersResponse(this.clusterMembersResponseDecoder.correlationId(), this.clusterMembersResponseDecoder.leaderMemberId(), this.clusterMembersResponseDecoder.activeMembers(), this.clusterMembersResponseDecoder.passiveFollowers());
        }
    }

    static interface MemberServiceHandler {
        public void onClusterMembersResponse(long var1, int var3, String var4, String var5);
    }
}

