/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.LogAdapter;
import org.agrona.CloseHelper;

class LogReplay
implements AutoCloseable {
    private final long recordingId;
    private final long startPosition;
    private final long stopPosition;
    private final long leadershipTermId;
    private final int logSessionId;
    private final int replayStreamId;
    private final AeronArchive archive;
    private final ConsensusModuleAgent consensusModuleAgent;
    private final String channel;
    private int replaySessionId = -1;
    private State state = State.INIT;
    private Subscription logSubscription;
    private LogAdapter logAdapter;

    LogReplay(AeronArchive archive, long recordingId, long startPosition, long stopPosition, long leadershipTermId, int logSessionId, ConsensusModuleAgent consensusModuleAgent, ConsensusModule.Context ctx) {
        this.archive = archive;
        this.recordingId = recordingId;
        this.startPosition = startPosition;
        this.stopPosition = stopPosition;
        this.leadershipTermId = leadershipTermId;
        this.logSessionId = logSessionId;
        this.consensusModuleAgent = consensusModuleAgent;
        this.replayStreamId = ctx.replayStreamId();
        Aeron aeron = ctx.aeron();
        ChannelUri channelUri = ChannelUri.parse(ctx.replayChannel());
        channelUri.put("session-id", Integer.toString(logSessionId));
        this.channel = channelUri.toString();
        this.logSubscription = aeron.addSubscription(this.channel, this.replayStreamId);
    }

    @Override
    public void close() {
        CloseHelper.close(this.logSubscription);
        CloseHelper.close(this.logAdapter);
    }

    int doWork(long nowMs) {
        int workCount = 0;
        if (State.INIT == this.state) {
            this.consensusModuleAgent.awaitServicesReadyForReplay(this.channel, this.replayStreamId, this.logSessionId, this.leadershipTermId, this.startPosition, this.stopPosition);
            long length = this.stopPosition - this.startPosition;
            this.replaySessionId = (int)this.archive.startReplay(this.recordingId, this.startPosition, length, this.channel, this.replayStreamId);
            this.state = State.REPLAY;
            workCount = 1;
        } else if (State.REPLAY == this.state) {
            if (null == this.logAdapter) {
                Image image = this.logSubscription.imageBySessionId(this.replaySessionId);
                if (null != image) {
                    this.logAdapter = new LogAdapter(image, this.consensusModuleAgent);
                    workCount = 1;
                }
            } else {
                this.consensusModuleAgent.replayLogPoll(this.logAdapter, this.stopPosition);
                if (this.logAdapter.position() == this.stopPosition) {
                    this.consensusModuleAgent.awaitServicesReplayComplete(this.stopPosition);
                    this.logSubscription.close();
                    this.logSubscription = null;
                    this.logAdapter.close();
                    this.logAdapter = null;
                    this.state = State.DONE;
                    workCount = 1;
                }
            }
        }
        return workCount;
    }

    boolean isDone() {
        return State.DONE == this.state;
    }

    static enum State {
        INIT,
        REPLAY,
        DONE;

    }
}

