/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ChannelUriStringBuilder;
import io.aeron.Publication;
import io.aeron.cluster.ClusterSession;
import io.aeron.cluster.codecs.ChangeType;
import io.aeron.cluster.codecs.ClusterAction;
import io.aeron.cluster.codecs.ClusterActionRequestEncoder;
import io.aeron.cluster.codecs.MembershipChangeEventEncoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.NewLeadershipTermEventEncoder;
import io.aeron.cluster.codecs.SessionCloseEventEncoder;
import io.aeron.cluster.codecs.SessionHeaderEncoder;
import io.aeron.cluster.codecs.SessionOpenEventEncoder;
import io.aeron.cluster.codecs.TimerEventEncoder;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.concurrent.UnsafeBuffer;

class LogPublisher {
    private static final int SEND_ATTEMPTS = 3;
    public static final int SESSION_HEADER_LENGTH = 32;
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final SessionHeaderEncoder sessionHeaderEncoder = new SessionHeaderEncoder();
    private final SessionOpenEventEncoder sessionOpenEventEncoder = new SessionOpenEventEncoder();
    private final SessionCloseEventEncoder sessionCloseEventEncoder = new SessionCloseEventEncoder();
    private final TimerEventEncoder timerEventEncoder = new TimerEventEncoder();
    private final ClusterActionRequestEncoder clusterActionRequestEncoder = new ClusterActionRequestEncoder();
    private final NewLeadershipTermEventEncoder newLeadershipTermEventEncoder = new NewLeadershipTermEventEncoder();
    private final MembershipChangeEventEncoder membershipChangeEventEncoder = new MembershipChangeEventEncoder();
    private final UnsafeBuffer sessionHeaderBuffer = new UnsafeBuffer(new byte[32]);
    private final ExpandableArrayBuffer expandableArrayBuffer = new ExpandableArrayBuffer();
    private final BufferClaim bufferClaim = new BufferClaim();
    private Publication publication;

    LogPublisher() {
        this.sessionHeaderEncoder.wrapAndApplyHeader(this.sessionHeaderBuffer, 0, new MessageHeaderEncoder());
    }

    void connect(Publication publication) {
        this.publication = publication;
    }

    void disconnect() {
        if (null != this.publication) {
            this.publication.close();
            this.publication = null;
        }
    }

    long position() {
        if (null == this.publication) {
            return 0L;
        }
        return this.publication.position();
    }

    int sessionId() {
        return this.publication.sessionId();
    }

    void addPassiveFollower(String followerLogEndpoint) {
        if (null != this.publication) {
            ChannelUriStringBuilder builder = new ChannelUriStringBuilder().media("udp");
            this.publication.addDestination(builder.endpoint(followerLogEndpoint).build());
        }
    }

    void removePassiveFollower(String followerLogEndpoint) {
        if (null != this.publication) {
            ChannelUriStringBuilder builder = new ChannelUriStringBuilder().media("udp");
            this.publication.removeDestination(builder.endpoint(followerLogEndpoint).build());
        }
    }

    boolean appendMessage(long leadershipTermId, long clusterSessionId, long timestampMs, DirectBuffer buffer, int offset, int length) {
        this.sessionHeaderEncoder.leadershipTermId(leadershipTermId).clusterSessionId(clusterSessionId).timestamp(timestampMs);
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.offer(this.sessionHeaderBuffer, 0, 32, buffer, offset, length, null)) > 0L) {
                return true;
            }
            LogPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    long appendSessionOpen(ClusterSession session, long leadershipTermId, long nowMs) {
        long result;
        byte[] encodedPrincipal = session.encodedPrincipal();
        String channel = session.responseChannel();
        this.sessionOpenEventEncoder.wrapAndApplyHeader(this.expandableArrayBuffer, 0, this.messageHeaderEncoder).leadershipTermId(leadershipTermId).clusterSessionId(session.id()).correlationId(session.correlationId()).timestamp(nowMs).responseStreamId(session.responseStreamId()).responseChannel(channel).putEncodedPrincipal(encodedPrincipal, 0, encodedPrincipal.length);
        int length = this.sessionOpenEventEncoder.encodedLength() + 8;
        int attempts = 3;
        do {
            if ((result = this.publication.offer(this.expandableArrayBuffer, 0, length, null)) > 0L) {
                return result;
            }
            LogPublisher.checkResult(result);
        } while (--attempts > 0);
        return result;
    }

    boolean appendSessionClose(ClusterSession session, long leadershipTermId, long nowMs) {
        int length = 36;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(36, this.bufferClaim)) > 0L) {
                this.sessionCloseEventEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).clusterSessionId(session.id()).timestamp(nowMs).closeReason(session.closeReason());
                this.bufferClaim.commit();
                return true;
            }
            LogPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    boolean appendTimer(long correlationId, long leadershipTermId, long nowMs) {
        int length = 32;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(32, this.bufferClaim)) > 0L) {
                this.timerEventEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).correlationId(correlationId).timestamp(nowMs);
                this.bufferClaim.commit();
                return true;
            }
            LogPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    boolean appendClusterAction(long leadershipTermId, long logPosition, long nowMs, ClusterAction action) {
        int length = 36;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(36, this.bufferClaim)) > 0L) {
                this.clusterActionRequestEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).timestamp(nowMs).action(action);
                this.bufferClaim.commit();
                return true;
            }
            LogPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    boolean appendNewLeadershipTermEvent(long leadershipTermId, long logPosition, long nowMs, int leaderMemberId, int logSessionId) {
        int length = 40;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(40, this.bufferClaim)) > 0L) {
                this.newLeadershipTermEventEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).timestamp(nowMs).leaderMemberId(leaderMemberId).logSessionId(logSessionId);
                this.bufferClaim.commit();
                return true;
            }
            LogPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    long calculatePositionForMembershipChangeEvent(String clusterMembers) {
        int length = 80 + MembershipChangeEventEncoder.clusterMembersHeaderLength() + clusterMembers.length();
        return this.position() + (long)BitUtil.align(length, 32);
    }

    boolean appendMembershipChangeEvent(long leadershipTermId, long logPosition, long nowMs, int leaderMemberId, int clusterSize, ChangeType changeType, int memberId, String clusterMembers) {
        this.membershipChangeEventEncoder.wrapAndApplyHeader(this.expandableArrayBuffer, 0, this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).timestamp(nowMs).leaderMemberId(leaderMemberId).clusterSize(clusterSize).changeType(changeType).memberId(memberId).clusterMembers(clusterMembers);
        int length = this.membershipChangeEventEncoder.encodedLength() + 8;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.offer(this.expandableArrayBuffer, 0, length, null)) > 0L) {
                return true;
            }
            LogPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    private static void checkResult(long result) {
        if (result == -1L || result == -4L || result == -5L) {
            throw new AeronException("unexpected publication state: " + result);
        }
    }
}

