/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Image;
import io.aeron.ImageControlledFragmentAssembler;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.ClusterActionRequestDecoder;
import io.aeron.cluster.codecs.MembershipChangeEventDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.NewLeadershipTermEventDecoder;
import io.aeron.cluster.codecs.SessionCloseEventDecoder;
import io.aeron.cluster.codecs.SessionHeaderDecoder;
import io.aeron.cluster.codecs.SessionOpenEventDecoder;
import io.aeron.cluster.codecs.TimerEventDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

final class LogAdapter
implements ControlledFragmentHandler,
AutoCloseable {
    public static final int SESSION_HEADER_LENGTH = 32;
    private static final int FRAGMENT_LIMIT = 100;
    private final ImageControlledFragmentAssembler fragmentAssembler = new ImageControlledFragmentAssembler(this);
    private final Image image;
    private final ConsensusModuleAgent consensusModuleAgent;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SessionOpenEventDecoder sessionOpenEventDecoder = new SessionOpenEventDecoder();
    private final SessionCloseEventDecoder sessionCloseEventDecoder = new SessionCloseEventDecoder();
    private final SessionHeaderDecoder sessionHeaderDecoder = new SessionHeaderDecoder();
    private final TimerEventDecoder timerEventDecoder = new TimerEventDecoder();
    private final ClusterActionRequestDecoder clusterActionRequestDecoder = new ClusterActionRequestDecoder();
    private final NewLeadershipTermEventDecoder newLeadershipTermEventDecoder = new NewLeadershipTermEventDecoder();
    private final MembershipChangeEventDecoder membershipChangeEventDecoder = new MembershipChangeEventDecoder();

    LogAdapter(Image image, ConsensusModuleAgent consensusModuleAgent) {
        this.image = image;
        this.consensusModuleAgent = consensusModuleAgent;
    }

    @Override
    public void close() {
        this.image.subscription().close();
    }

    long position() {
        return this.image.position();
    }

    int poll(long boundPosition) {
        return this.image.boundedControlledPoll(this.fragmentAssembler, boundPosition, 100);
    }

    boolean isImageClosed() {
        return this.image.isClosed();
    }

    Image image() {
        return this.image;
    }

    void removeDestination(String destination) {
        if (null != this.image) {
            this.image.subscription().removeDestination(destination);
        }
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.sbeSchemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        int templateId = this.messageHeaderDecoder.templateId();
        if (templateId == 20) {
            this.sessionHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            this.consensusModuleAgent.onReplaySessionMessage(this.sessionHeaderDecoder.clusterSessionId(), this.sessionHeaderDecoder.timestamp(), buffer, offset + 32, length - 32, header);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        switch (templateId) {
            case 21: {
                this.timerEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onReplayTimerEvent(this.timerEventDecoder.correlationId(), this.timerEventDecoder.timestamp());
                break;
            }
            case 22: {
                this.sessionOpenEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onReplaySessionOpen(header.position(), this.sessionOpenEventDecoder.correlationId(), this.sessionOpenEventDecoder.clusterSessionId(), this.sessionOpenEventDecoder.timestamp(), this.sessionOpenEventDecoder.responseStreamId(), this.sessionOpenEventDecoder.responseChannel());
                break;
            }
            case 23: {
                this.sessionCloseEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onReplaySessionClose(this.sessionCloseEventDecoder.clusterSessionId(), this.sessionCloseEventDecoder.timestamp(), this.sessionCloseEventDecoder.closeReason());
                break;
            }
            case 25: {
                this.newLeadershipTermEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onReplayNewLeadershipTermEvent(this.newLeadershipTermEventDecoder.leadershipTermId(), this.newLeadershipTermEventDecoder.logPosition(), this.newLeadershipTermEventDecoder.timestamp(), this.newLeadershipTermEventDecoder.leaderMemberId(), this.newLeadershipTermEventDecoder.logSessionId());
                break;
            }
            case 26: {
                this.membershipChangeEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onMembershipClusterChange(this.membershipChangeEventDecoder.leadershipTermId(), this.membershipChangeEventDecoder.logPosition(), this.membershipChangeEventDecoder.timestamp(), this.membershipChangeEventDecoder.leaderMemberId(), this.membershipChangeEventDecoder.clusterSize(), this.membershipChangeEventDecoder.changeType(), this.membershipChangeEventDecoder.memberId(), this.membershipChangeEventDecoder.clusterMembers());
                break;
            }
            case 24: {
                this.clusterActionRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onReplayClusterAction(this.clusterActionRequestDecoder.leadershipTermId(), this.clusterActionRequestDecoder.logPosition(), this.clusterActionRequestDecoder.timestamp(), this.clusterActionRequestDecoder.action());
                return ControlledFragmentHandler.Action.BREAK;
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

