/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.ChallengeResponseDecoder;
import io.aeron.cluster.codecs.IngressMessageHeaderDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.SessionCloseRequestDecoder;
import io.aeron.cluster.codecs.SessionConnectRequestDecoder;
import io.aeron.cluster.codecs.SessionKeepAliveDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.status.AtomicCounter;

class IngressAdapter
implements ControlledFragmentHandler,
AutoCloseable {
    private static final int INGRESS_HEADER = 32;
    private static final int FRAGMENT_POLL_LIMIT = 10;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SessionConnectRequestDecoder connectRequestDecoder = new SessionConnectRequestDecoder();
    private final SessionCloseRequestDecoder closeRequestDecoder = new SessionCloseRequestDecoder();
    private final IngressMessageHeaderDecoder ingressMessageHeaderDecoder = new IngressMessageHeaderDecoder();
    private final SessionKeepAliveDecoder sessionKeepAliveDecoder = new SessionKeepAliveDecoder();
    private final ChallengeResponseDecoder challengeResponseDecoder = new ChallengeResponseDecoder();
    private Subscription subscription;
    private final ControlledFragmentAssembler fragmentAssembler = new ControlledFragmentAssembler(this);
    private final ConsensusModuleAgent consensusModuleAgent;
    private final AtomicCounter invalidRequests;

    IngressAdapter(ConsensusModuleAgent consensusModuleAgent, AtomicCounter invalidRequests) {
        this.consensusModuleAgent = consensusModuleAgent;
        this.invalidRequests = invalidRequests;
    }

    @Override
    public void close() {
        CloseHelper.close(this.subscription);
        this.subscription = null;
        this.fragmentAssembler.clear();
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.sbeSchemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        int templateId = this.messageHeaderDecoder.templateId();
        if (templateId == 1) {
            this.ingressMessageHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            return this.consensusModuleAgent.onIngressMessage(this.ingressMessageHeaderDecoder.leadershipTermId(), this.ingressMessageHeaderDecoder.clusterSessionId(), buffer, offset + 32, length - 32);
        }
        switch (templateId) {
            case 4: {
                this.connectRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                String responseChannel = this.connectRequestDecoder.responseChannel();
                byte[] credentials = new byte[this.connectRequestDecoder.encodedCredentialsLength()];
                this.connectRequestDecoder.getEncodedCredentials(credentials, 0, credentials.length);
                this.consensusModuleAgent.onSessionConnect(this.connectRequestDecoder.correlationId(), this.connectRequestDecoder.responseStreamId(), responseChannel, credentials);
                break;
            }
            case 5: {
                this.closeRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onSessionClose(this.closeRequestDecoder.clusterSessionId());
                break;
            }
            case 6: {
                this.sessionKeepAliveDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onSessionKeepAlive(this.sessionKeepAliveDecoder.clusterSessionId(), this.sessionKeepAliveDecoder.leadershipTermId());
                break;
            }
            case 9: {
                this.challengeResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                byte[] credentials = new byte[this.challengeResponseDecoder.encodedCredentialsLength()];
                this.challengeResponseDecoder.getEncodedCredentials(credentials, 0, credentials.length);
                this.consensusModuleAgent.onChallengeResponse(this.challengeResponseDecoder.correlationId(), this.challengeResponseDecoder.clusterSessionId(), credentials);
                break;
            }
            default: {
                this.invalidRequests.incrementOrdered();
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    void connect(Subscription subscription) {
        this.subscription = subscription;
    }

    int poll() {
        if (null == this.subscription) {
            return 0;
        }
        return this.subscription.controlledPoll(this.fragmentAssembler, 10);
    }

    void freeSessionBuffer(int imageSessionId) {
        this.fragmentAssembler.freeSessionBuffer(imageSessionId);
    }
}

