/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ChannelUri;
import io.aeron.ChannelUriStringBuilder;
import io.aeron.Counter;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.LogReplay;
import io.aeron.cluster.MemberStatusAdapter;
import io.aeron.cluster.MemberStatusPublisher;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.service.Cluster;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.agrona.CloseHelper;
import org.agrona.collections.Int2ObjectHashMap;

class Election
implements AutoCloseable {
    static final int NOMINATION_TIMEOUT_MULTIPLIER = 7;
    static final int ELECTION_STATE_TYPE_ID = 207;
    private boolean isStartup;
    private boolean shouldReplay;
    private final long electionStatusIntervalMs;
    private final long electionTimeoutMs;
    private final long leaderHeartbeatIntervalMs;
    private final long leaderHeartbeatTimeoutMs;
    private final ClusterMember[] clusterMembers;
    private final ClusterMember thisMember;
    private final Int2ObjectHashMap<ClusterMember> clusterMemberByIdMap;
    private final MemberStatusAdapter memberStatusAdapter;
    private final MemberStatusPublisher memberStatusPublisher;
    private final ConsensusModule.Context ctx;
    private final ConsensusModuleAgent consensusModuleAgent;
    private final Random random;
    private long timeOfLastStateChangeMs;
    private long timeOfLastUpdateMs;
    private long nominationDeadlineMs;
    private long logPosition;
    private long catchupLogPosition = -1L;
    private long leadershipTermId;
    private long logLeadershipTermId;
    private long candidateTermId = -1L;
    private int logSessionId = -1;
    private ClusterMember leaderMember = null;
    private State state = State.INIT;
    private Counter stateCounter;
    private Subscription logSubscription;
    private String liveLogDestination;
    private LogReplay logReplay = null;

    Election(boolean isStartup, long leadershipTermId, long logPosition, ClusterMember[] clusterMembers, Int2ObjectHashMap<ClusterMember> clusterMemberByIdMap, ClusterMember thisMember, MemberStatusAdapter memberStatusAdapter, MemberStatusPublisher memberStatusPublisher, ConsensusModule.Context ctx, ConsensusModuleAgent consensusModuleAgent) {
        this.isStartup = isStartup;
        this.shouldReplay = isStartup;
        this.electionStatusIntervalMs = TimeUnit.NANOSECONDS.toMillis(ctx.electionStatusIntervalNs());
        this.electionTimeoutMs = TimeUnit.NANOSECONDS.toMillis(ctx.electionTimeoutNs());
        this.leaderHeartbeatIntervalMs = TimeUnit.NANOSECONDS.toMillis(ctx.leaderHeartbeatIntervalNs());
        this.leaderHeartbeatTimeoutMs = TimeUnit.NANOSECONDS.toMillis(ctx.leaderHeartbeatTimeoutNs());
        this.logPosition = logPosition;
        this.logLeadershipTermId = leadershipTermId;
        this.leadershipTermId = leadershipTermId;
        this.clusterMembers = clusterMembers;
        this.clusterMemberByIdMap = clusterMemberByIdMap;
        this.thisMember = thisMember;
        this.memberStatusAdapter = memberStatusAdapter;
        this.memberStatusPublisher = memberStatusPublisher;
        this.ctx = ctx;
        this.consensusModuleAgent = consensusModuleAgent;
        this.random = ctx.random();
    }

    @Override
    public void close() {
        CloseHelper.close(this.stateCounter);
    }

    int doWork(long nowMs) {
        int workCount = State.INIT == this.state ? this.init(nowMs) : 0;
        workCount += this.memberStatusAdapter.poll();
        switch (this.state) {
            case CANVASS: {
                workCount += this.canvass(nowMs);
                break;
            }
            case NOMINATE: {
                workCount += this.nominate(nowMs);
                break;
            }
            case CANDIDATE_BALLOT: {
                workCount += this.candidateBallot(nowMs);
                break;
            }
            case FOLLOWER_BALLOT: {
                workCount += this.followerBallot(nowMs);
                break;
            }
            case LEADER_REPLAY: {
                workCount += this.leaderReplay(nowMs);
                break;
            }
            case LEADER_TRANSITION: {
                workCount += this.leaderTransition(nowMs);
                break;
            }
            case LEADER_READY: {
                workCount += this.leaderReady(nowMs);
                break;
            }
            case FOLLOWER_REPLAY: {
                workCount += this.followerReplay(nowMs);
                break;
            }
            case FOLLOWER_CATCHUP_TRANSITION: {
                workCount += this.followerCatchupTransition(nowMs);
                break;
            }
            case FOLLOWER_CATCHUP: {
                workCount += this.followerCatchup(nowMs);
                break;
            }
            case FOLLOWER_TRANSITION: {
                workCount += this.followerTransition(nowMs);
                break;
            }
            case FOLLOWER_READY: {
                workCount += this.followerReady(nowMs);
            }
        }
        return workCount;
    }

    void onCanvassPosition(long logLeadershipTermId, long logPosition, int followerMemberId) {
        ClusterMember follower = this.clusterMemberByIdMap.get(followerMemberId);
        if (null == follower) {
            return;
        }
        follower.leadershipTermId(logLeadershipTermId).logPosition(logPosition);
        if (State.LEADER_READY == this.state && logLeadershipTermId < this.leadershipTermId) {
            if (this.logLeadershipTermId == logLeadershipTermId) {
                this.publishNewLeadershipTerm(follower.publication(), this.leadershipTermId);
            } else {
                this.memberStatusPublisher.newLeadershipTerm(follower.publication(), logLeadershipTermId, this.consensusModuleAgent.logStopPosition(logLeadershipTermId), this.logLeadershipTermId + 1L, this.logPosition, this.thisMember.id(), this.logSessionId);
            }
        } else if (State.CANVASS != this.state && logLeadershipTermId > this.leadershipTermId) {
            this.state(State.CANVASS, this.ctx.epochClock().time());
        }
    }

    void onRequestVote(long logLeadershipTermId, long logPosition, long candidateTermId, int candidateId) {
        if (candidateTermId <= this.leadershipTermId || candidateTermId <= this.candidateTermId) {
            this.placeVote(candidateTermId, candidateId, false);
        } else if (ClusterMember.compareLog(this.logLeadershipTermId, this.logPosition, logLeadershipTermId, logPosition) > 0) {
            this.candidateTermId = candidateTermId;
            this.ctx.clusterMarkFile().candidateTermId(candidateTermId);
            this.state(State.CANVASS, this.ctx.epochClock().time());
            this.placeVote(candidateTermId, candidateId, false);
        } else {
            this.candidateTermId = candidateTermId;
            this.ctx.clusterMarkFile().candidateTermId(candidateTermId);
            this.state(State.FOLLOWER_BALLOT, this.ctx.epochClock().time());
            this.placeVote(candidateTermId, candidateId, true);
        }
    }

    void onVote(long candidateTermId, long logLeadershipTermId, long logPosition, int candidateMemberId, int followerMemberId, boolean vote) {
        ClusterMember follower = this.clusterMemberByIdMap.get(followerMemberId);
        if (State.CANDIDATE_BALLOT == this.state && candidateTermId == this.candidateTermId && candidateMemberId == this.thisMember.id() && null != follower) {
            follower.candidateTermId(candidateTermId).leadershipTermId(logLeadershipTermId).logPosition(logPosition).vote(vote ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    void onNewLeadershipTerm(long logLeadershipTermId, long logPosition, long leadershipTermId, long maxLogPosition, int leaderMemberId, int logSessionId) {
        ClusterMember leader = this.clusterMemberByIdMap.get(leaderMemberId);
        if (null == leader) {
            return;
        }
        if ((State.FOLLOWER_BALLOT == this.state || State.CANDIDATE_BALLOT == this.state || State.CANVASS == this.state) && leadershipTermId == this.candidateTermId) {
            this.leadershipTermId = leadershipTermId;
            this.leaderMember = leader;
            this.logSessionId = logSessionId;
            if (this.logPosition < logPosition && -1L == this.catchupLogPosition) {
                this.catchupLogPosition = logPosition;
                this.state(State.FOLLOWER_REPLAY, this.ctx.epochClock().time());
            } else if (this.logPosition > logPosition && this.logLeadershipTermId == logLeadershipTermId) {
                this.consensusModuleAgent.truncateLogEntry(logLeadershipTermId, logPosition);
                this.consensusModuleAgent.prepareForNewLeadership(logPosition);
                this.logPosition = logPosition;
                this.state(State.FOLLOWER_REPLAY, this.ctx.epochClock().time());
            } else {
                this.catchupLogPosition = logPosition;
                this.state(State.FOLLOWER_REPLAY, this.ctx.epochClock().time());
            }
        } else if (0 != ClusterMember.compareLog(this.logLeadershipTermId, this.logPosition, logLeadershipTermId, logPosition)) {
            if (this.logPosition > logPosition && this.logLeadershipTermId == logLeadershipTermId) {
                this.consensusModuleAgent.truncateLogEntry(logLeadershipTermId, logPosition);
                this.consensusModuleAgent.prepareForNewLeadership(logPosition);
                this.logPosition = logPosition;
                this.state(State.FOLLOWER_REPLAY, this.ctx.epochClock().time());
            } else if (this.logPosition < logPosition && -1L == this.catchupLogPosition) {
                this.leadershipTermId = leadershipTermId;
                this.candidateTermId = -1L;
                this.leaderMember = leader;
                this.logSessionId = logSessionId;
                this.catchupLogPosition = logPosition;
                this.state(State.FOLLOWER_REPLAY, this.ctx.epochClock().time());
            } else if (logPosition == this.logPosition && -1L == this.catchupLogPosition) {
                ++this.leadershipTermId;
                ++this.candidateTermId;
            }
        }
    }

    void onAppendedPosition(long leadershipTermId, long logPosition, int followerMemberId) {
        ClusterMember follower = this.clusterMemberByIdMap.get(followerMemberId);
        if (null != follower) {
            follower.logPosition(logPosition).leadershipTermId(leadershipTermId).timeOfLastAppendPositionMs(this.ctx.epochClock().time());
            this.consensusModuleAgent.checkCatchupStop(follower);
        }
    }

    void onCommitPosition(long leadershipTermId, long logPosition, int leaderMemberId) {
        if (State.FOLLOWER_BALLOT == this.state && leadershipTermId > this.leadershipTermId) {
            if (this.logPosition > logPosition) {
                this.consensusModuleAgent.truncateLogEntry(this.logLeadershipTermId, logPosition);
            } else {
                this.catchupLogPosition = logPosition;
                this.state(State.FOLLOWER_REPLAY, this.ctx.epochClock().time());
            }
        } else if (State.FOLLOWER_CATCHUP == this.state && -1L != this.catchupLogPosition) {
            this.catchupLogPosition = Math.max(this.catchupLogPosition, logPosition);
        }
    }

    void onReplayNewLeadershipTermEvent(long logRecordingId, long leadershipTermId, long logPosition, long nowMs) {
        if (State.FOLLOWER_CATCHUP == this.state) {
            this.logLeadershipTermId = leadershipTermId;
            this.logPosition = logPosition;
            if (!this.ctx.recordingLog().hasTermBeenAppended(leadershipTermId)) {
                this.ctx.recordingLog().appendTerm(logRecordingId, leadershipTermId, logPosition, nowMs);
                this.ctx.recordingLog().force();
            }
        }
    }

    State state() {
        return this.state;
    }

    ClusterMember leader() {
        return this.leaderMember;
    }

    long leadershipTermId() {
        return this.leadershipTermId;
    }

    long candidateTermId() {
        return this.candidateTermId;
    }

    void logSessionId(int logSessionId) {
        this.logSessionId = logSessionId;
    }

    long logPosition() {
        return this.logPosition;
    }

    private int init(long nowMs) {
        this.stateCounter = this.ctx.aeron().addCounter(207, "Election State");
        if (!this.isStartup) {
            this.consensusModuleAgent.prepareForNewLeadership(this.logPosition);
        }
        this.candidateTermId = Math.max(this.ctx.clusterMarkFile().candidateTermId(), this.leadershipTermId);
        if (this.clusterMembers.length == 1) {
            this.candidateTermId = Math.max(this.leadershipTermId + 1L, this.candidateTermId + 1L);
            this.leaderMember = this.thisMember;
            this.state(State.LEADER_REPLAY, nowMs);
        } else {
            this.state(State.CANVASS, nowMs);
        }
        return 1;
    }

    private int canvass(long nowMs) {
        int workCount = 0;
        if (nowMs >= this.timeOfLastUpdateMs + this.electionStatusIntervalMs) {
            this.timeOfLastUpdateMs = nowMs;
            for (ClusterMember member : this.clusterMembers) {
                if (member == this.thisMember) continue;
                this.memberStatusPublisher.canvassPosition(member.publication(), this.leadershipTermId, this.logPosition, this.thisMember.id());
            }
            ++workCount;
        }
        if (this.ctx.appointedLeaderId() != -1 && this.ctx.appointedLeaderId() != this.thisMember.id()) {
            return workCount;
        }
        long canvassDeadlineMs = (this.isStartup ? TimeUnit.NANOSECONDS.toMillis(this.ctx.startupCanvassTimeoutNs()) : this.electionTimeoutMs) + this.timeOfLastStateChangeMs;
        if (ClusterMember.isUnanimousCandidate(this.clusterMembers, this.thisMember) || ClusterMember.isQuorumCandidate(this.clusterMembers, this.thisMember) && nowMs >= canvassDeadlineMs) {
            this.nominationDeadlineMs = nowMs + (long)this.random.nextInt((int)this.electionStatusIntervalMs * 7);
            this.state(State.NOMINATE, nowMs);
            ++workCount;
        }
        return workCount;
    }

    private int nominate(long nowMs) {
        if (nowMs >= this.nominationDeadlineMs) {
            this.candidateTermId = Math.max(this.leadershipTermId + 1L, this.candidateTermId + 1L);
            ClusterMember.becomeCandidate(this.clusterMembers, this.candidateTermId, this.thisMember.id());
            this.ctx.clusterMarkFile().candidateTermId(this.candidateTermId);
            this.state(State.CANDIDATE_BALLOT, nowMs);
            return 1;
        }
        return 0;
    }

    private int candidateBallot(long nowMs) {
        int workCount = 0;
        if (ClusterMember.hasWonVoteOnFullCount(this.clusterMembers, this.candidateTermId) || ClusterMember.hasMajorityVoteWithCanvassMembers(this.clusterMembers, this.candidateTermId)) {
            this.leaderMember = this.thisMember;
            this.state(State.LEADER_REPLAY, nowMs);
            ++workCount;
        } else if (nowMs >= this.timeOfLastStateChangeMs + this.electionTimeoutMs) {
            if (ClusterMember.hasMajorityVote(this.clusterMembers, this.candidateTermId)) {
                this.leaderMember = this.thisMember;
                this.state(State.LEADER_REPLAY, nowMs);
            } else {
                this.state(State.CANVASS, nowMs);
            }
            ++workCount;
        } else {
            for (ClusterMember member : this.clusterMembers) {
                if (member.isBallotSent()) continue;
                ++workCount;
                member.isBallotSent(this.memberStatusPublisher.requestVote(member.publication(), this.leadershipTermId, this.logPosition, this.candidateTermId, this.thisMember.id()));
            }
        }
        return workCount;
    }

    private int followerBallot(long nowMs) {
        int workCount = 0;
        if (nowMs >= this.timeOfLastStateChangeMs + this.electionTimeoutMs) {
            this.state(State.CANVASS, nowMs);
            ++workCount;
        }
        return workCount;
    }

    private int leaderReplay(long nowMs) {
        int workCount = 0;
        if (null == this.logReplay) {
            this.consensusModuleAgent.followerCommitPosition(this.logPosition);
            this.logSessionId = this.consensusModuleAgent.addNewLogPublication().sessionId();
            ClusterMember.resetLogPositions(this.clusterMembers, -1L);
            this.thisMember.logPosition(this.logPosition).leadershipTermId(this.candidateTermId);
            if (!this.shouldReplay || (this.logReplay = this.consensusModuleAgent.newLogReplay(this.logPosition)) == null) {
                this.shouldReplay = false;
                this.state(State.LEADER_TRANSITION, nowMs);
                workCount = 1;
            }
        } else {
            workCount += this.logReplay.doWork(nowMs);
            if (this.logReplay.isDone()) {
                this.logReplay.close();
                this.logReplay = null;
                this.shouldReplay = false;
                this.state(State.LEADER_TRANSITION, nowMs);
            } else if (nowMs > this.timeOfLastUpdateMs + this.leaderHeartbeatIntervalMs) {
                this.timeOfLastUpdateMs = nowMs;
                for (ClusterMember member : this.clusterMembers) {
                    if (member == this.thisMember) continue;
                    this.publishNewLeadershipTerm(member.publication(), this.candidateTermId);
                }
                ++workCount;
            }
        }
        return workCount;
    }

    private int leaderTransition(long nowMs) {
        this.consensusModuleAgent.becomeLeader(this.candidateTermId, this.logPosition, this.logSessionId);
        for (long termId = this.leadershipTermId + 1L; termId < this.candidateTermId; ++termId) {
            this.ctx.recordingLog().appendTerm(-1L, termId, this.logPosition, nowMs);
        }
        this.leadershipTermId = this.candidateTermId;
        this.ctx.recordingLog().appendTerm(this.consensusModuleAgent.logRecordingId(), this.leadershipTermId, this.logPosition, nowMs);
        this.ctx.recordingLog().force();
        this.state(State.LEADER_READY, nowMs);
        return 1;
    }

    private int leaderReady(long nowMs) {
        int workCount = 0;
        if (ClusterMember.haveVotersReachedPosition(this.clusterMembers, this.logPosition, this.leadershipTermId)) {
            if (this.consensusModuleAgent.electionComplete(nowMs)) {
                this.consensusModuleAgent.updateMemberDetails(this);
                this.close();
            }
            ++workCount;
        } else if (nowMs > this.timeOfLastUpdateMs + this.leaderHeartbeatIntervalMs) {
            this.timeOfLastUpdateMs = nowMs;
            for (ClusterMember member : this.clusterMembers) {
                if (member == this.thisMember) continue;
                this.publishNewLeadershipTerm(member.publication(), this.leadershipTermId);
            }
            ++workCount;
        }
        return workCount;
    }

    private int followerReplay(long nowMs) {
        State nextState;
        int workCount = 0;
        State state = nextState = -1L != this.catchupLogPosition ? State.FOLLOWER_CATCHUP_TRANSITION : State.FOLLOWER_TRANSITION;
        if (null == this.logReplay) {
            if (!this.shouldReplay || (this.logReplay = this.consensusModuleAgent.newLogReplay(this.logPosition)) == null) {
                this.shouldReplay = false;
                this.state(nextState, nowMs);
                workCount = 1;
            }
        } else {
            workCount += this.logReplay.doWork(nowMs);
            if (this.logReplay.isDone()) {
                this.logReplay.close();
                this.logReplay = null;
                this.shouldReplay = false;
                this.state(nextState, nowMs);
            }
        }
        return workCount;
    }

    private int followerCatchupTransition(long nowMs) {
        if (null == this.logSubscription) {
            ChannelUri logChannelUri = Election.followerLogChannel(this.ctx.logChannel(), this.logSessionId);
            this.logSubscription = this.consensusModuleAgent.createAndRecordLogSubscriptionAsFollower(logChannelUri.toString());
            this.consensusModuleAgent.awaitServicesReady(logChannelUri, this.logSessionId, this.logPosition);
            String replayDestination = new ChannelUriStringBuilder().media("udp").endpoint(this.thisMember.transferEndpoint()).build();
            this.logSubscription.addDestination(replayDestination);
            this.consensusModuleAgent.replayLogDestination(replayDestination);
        }
        if (this.catchupPosition(this.leadershipTermId, this.logPosition)) {
            this.state(State.FOLLOWER_CATCHUP, nowMs);
        }
        return 1;
    }

    private int followerCatchup(long nowMs) {
        int workCount = 0;
        this.consensusModuleAgent.catchupLogPoll(this.logSubscription, this.logSessionId, this.catchupLogPosition);
        if (null == this.liveLogDestination && this.consensusModuleAgent.hasAppendReachedLivePosition(this.logSubscription, this.logSessionId, this.catchupLogPosition)) {
            this.addLiveLogDestination();
        }
        if (this.consensusModuleAgent.hasAppendReachedPosition(this.logSubscription, this.logSessionId, this.catchupLogPosition)) {
            this.logPosition = this.catchupLogPosition;
            this.state(State.FOLLOWER_TRANSITION, nowMs);
            ++workCount;
        }
        return workCount;
    }

    private int followerTransition(long nowMs) {
        if (null == this.logSubscription) {
            ChannelUri logChannelUri = Election.followerLogChannel(this.ctx.logChannel(), this.logSessionId);
            this.logSubscription = this.consensusModuleAgent.createAndRecordLogSubscriptionAsFollower(logChannelUri.toString());
            this.consensusModuleAgent.awaitServicesReady(logChannelUri, this.logSessionId, this.logPosition);
        }
        if (null == this.liveLogDestination) {
            this.addLiveLogDestination();
        }
        this.consensusModuleAgent.awaitImageAndCreateFollowerLogAdapter(this.logSubscription, this.logSessionId);
        if (!this.ctx.recordingLog().hasTermBeenAppended(this.leadershipTermId)) {
            this.ctx.recordingLog().appendTerm(this.consensusModuleAgent.logRecordingId(), this.leadershipTermId, this.logPosition, nowMs);
            this.ctx.recordingLog().force();
        }
        this.state(State.FOLLOWER_READY, nowMs);
        return 1;
    }

    private int followerReady(long nowMs) {
        Publication publication = this.leaderMember.publication();
        if (this.memberStatusPublisher.appendedPosition(publication, this.leadershipTermId, this.logPosition, this.thisMember.id())) {
            if (this.consensusModuleAgent.electionComplete(nowMs)) {
                this.consensusModuleAgent.updateMemberDetails(this);
                this.close();
            }
        } else if (nowMs >= this.timeOfLastStateChangeMs + this.leaderHeartbeatTimeoutMs) {
            if (null != this.liveLogDestination) {
                this.logSubscription.removeDestination(this.liveLogDestination);
                this.liveLogDestination = null;
                this.consensusModuleAgent.liveLogDestination(null);
            }
            this.state(State.CANVASS, nowMs);
        }
        return 1;
    }

    private void placeVote(long candidateTermId, int candidateId, boolean vote) {
        ClusterMember candidate = this.clusterMemberByIdMap.get(candidateId);
        if (null != candidate) {
            this.memberStatusPublisher.placeVote(candidate.publication(), candidateTermId, this.logLeadershipTermId, this.logPosition, candidateId, this.thisMember.id(), vote);
        }
    }

    private void publishNewLeadershipTerm(Publication publication, long leadershipTermId) {
        this.memberStatusPublisher.newLeadershipTerm(publication, this.logLeadershipTermId, this.logPosition, leadershipTermId, this.logPosition, this.thisMember.id(), this.logSessionId);
    }

    private boolean catchupPosition(long leadershipTermId, long logPosition) {
        return this.memberStatusPublisher.catchupPosition(this.leaderMember.publication(), leadershipTermId, logPosition, this.thisMember.id());
    }

    private void addLiveLogDestination() {
        ChannelUri channelUri = Election.followerLogDestination(this.ctx.logChannel(), this.thisMember.logEndpoint());
        this.liveLogDestination = channelUri.toString();
        this.logSubscription.addDestination(this.liveLogDestination);
        this.consensusModuleAgent.liveLogDestination(this.liveLogDestination);
    }

    private static ChannelUri followerLogChannel(String logChannel, int sessionId) {
        ChannelUri channelUri = ChannelUri.parse(logChannel);
        channelUri.remove("control");
        channelUri.put("control-mode", "manual");
        channelUri.put("session-id", Integer.toString(sessionId));
        channelUri.put("tags", "3,4");
        return channelUri;
    }

    private static ChannelUri followerLogDestination(String logChannel, String logEndpoint) {
        ChannelUri channelUri = ChannelUri.parse(logChannel);
        channelUri.remove("control");
        channelUri.put("endpoint", logEndpoint);
        return channelUri;
    }

    private void state(State newState, long nowMs) {
        if (State.CANVASS == newState) {
            this.consensusModuleAgent.stopAllCatchups();
            ClusterMember.reset(this.clusterMembers);
            this.thisMember.leadershipTermId(this.leadershipTermId).logPosition(this.logPosition);
            this.consensusModuleAgent.role(Cluster.Role.FOLLOWER);
        }
        if (State.CANVASS == this.state) {
            this.isStartup = false;
        }
        if (State.CANDIDATE_BALLOT == newState) {
            this.consensusModuleAgent.role(Cluster.Role.CANDIDATE);
        }
        if (State.CANDIDATE_BALLOT == this.state && State.LEADER_REPLAY != newState) {
            this.consensusModuleAgent.role(Cluster.Role.FOLLOWER);
        }
        if (State.LEADER_TRANSITION == newState) {
            this.consensusModuleAgent.role(Cluster.Role.LEADER);
        }
        this.state = newState;
        this.stateCounter.setOrdered(newState.code());
        this.timeOfLastStateChangeMs = nowMs;
    }

    static enum State {
        INIT(0),
        CANVASS(1),
        NOMINATE(2),
        CANDIDATE_BALLOT(3),
        FOLLOWER_BALLOT(4),
        LEADER_REPLAY(5),
        LEADER_TRANSITION(6),
        LEADER_READY(7),
        FOLLOWER_REPLAY(8),
        FOLLOWER_CATCHUP_TRANSITION(9),
        FOLLOWER_CATCHUP(10),
        FOLLOWER_TRANSITION(11),
        FOLLOWER_READY(12);

        static final State[] STATES;
        private final int code;

        private State(int code) {
            this.code = code;
        }

        int code() {
            return this.code;
        }

        static State get(int code) {
            if (code < 0 || code > STATES.length - 1) {
                throw new ClusterException("invalid state counter code: " + code);
            }
            return STATES[code];
        }

        static {
            State[] states = State.values();
            STATES = new State[states.length];
            for (State state : states) {
                int code = state.code();
                if (null != STATES[code]) {
                    throw new ClusterException("code already in use: " + code);
                }
                State.STATES[code] = state;
            }
        }
    }
}

