/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ChannelUri;
import io.aeron.ChannelUriStringBuilder;
import io.aeron.Counter;
import io.aeron.ExclusivePublication;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ControlResponsePoller;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.archive.status.RecordingPos;
import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.MemberStatusAdapter;
import io.aeron.cluster.MemberStatusPublisher;
import io.aeron.cluster.RecordingLog;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.SnapshotMarkerDecoder;
import io.aeron.cluster.codecs.SnapshotRecordingsDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.status.CountersReader;

class DynamicJoin
implements AutoCloseable {
    private final AeronArchive localArchive;
    private final MemberStatusAdapter memberStatusAdapter;
    private final MemberStatusPublisher memberStatusPublisher;
    private final ConsensusModule.Context ctx;
    private final ConsensusModuleAgent consensusModuleAgent;
    private final String[] clusterMemberStatusEndpoints;
    private final String memberEndpoints;
    private final String memberStatusEndpoint;
    private final String transferEndpoint;
    private final ArrayList<RecordingLog.Snapshot> leaderSnapshots = new ArrayList();
    private final long intervalMs;
    private ExclusivePublication clusterPublication;
    private State state = State.INIT;
    private ClusterMember[] clusterMembers;
    private ClusterMember leaderMember;
    private AeronArchive.AsyncConnect leaderArchiveAsyncConnect;
    private AeronArchive leaderArchive;
    private Subscription snapshotRetrieveSubscription;
    private Image snapshotRetrieveImage;
    private SnapshotReader snapshotReader;
    private Counter recoveryStateCounter;
    private long timeOfLastActivityMs = 0L;
    private long correlationId = -1L;
    private long snapshotRetrieveSubscriptionId = -1L;
    private int memberId = -1;
    private int clusterMembersStatusEndpointsCursor = -1;
    private int snapshotCursor = 0;
    private int snapshotReplaySessionId = -1;

    DynamicJoin(String clusterMemberStatusEndpoints, AeronArchive localArchive, MemberStatusAdapter memberStatusAdapter, MemberStatusPublisher memberStatusPublisher, ConsensusModule.Context ctx, ConsensusModuleAgent consensusModuleAgent) {
        ClusterMember thisMember = ClusterMember.parseEndpoints(-1, ctx.memberEndpoints());
        this.localArchive = localArchive;
        this.memberStatusAdapter = memberStatusAdapter;
        this.memberStatusPublisher = memberStatusPublisher;
        this.ctx = ctx;
        this.consensusModuleAgent = consensusModuleAgent;
        this.intervalMs = TimeUnit.NANOSECONDS.toMillis(ctx.dynamicJoinIntervalNs());
        this.memberEndpoints = ctx.memberEndpoints();
        this.memberStatusEndpoint = thisMember.memberFacingEndpoint();
        this.transferEndpoint = thisMember.transferEndpoint();
        this.clusterMemberStatusEndpoints = clusterMemberStatusEndpoints.split(",");
    }

    @Override
    public void close() {
        CloseHelper.close(this.clusterPublication);
        CloseHelper.close(this.snapshotRetrieveSubscription);
        CloseHelper.close(this.leaderArchive);
        CloseHelper.close(this.leaderArchiveAsyncConnect);
    }

    public ClusterMember[] clusterMembers() {
        return this.clusterMembers;
    }

    public ClusterMember leader() {
        return this.leaderMember;
    }

    public int memberId() {
        return this.memberId;
    }

    int doWork(long nowMs) {
        int workCount = 0;
        workCount += this.memberStatusAdapter.poll();
        switch (this.state) {
            case INIT: {
                workCount += this.init(nowMs);
                break;
            }
            case PASSIVE_FOLLOWER: {
                workCount += this.passiveFollower(nowMs);
                break;
            }
            case SNAPSHOT_RETRIEVE: {
                workCount += this.snapshotRetrieve();
                break;
            }
            case SNAPSHOT_LOAD: {
                workCount += this.snapshotLoad();
                break;
            }
            case JOIN_CLUSTER: {
                workCount += this.joinCluster();
            }
        }
        return workCount;
    }

    public void onClusterMembersChange(long correlationId, int leaderMemberId, String activeMembers, String passiveMembers) {
        if (State.INIT == this.state && correlationId == this.correlationId) {
            ClusterMember[] passiveFollowers;
            for (ClusterMember follower : passiveFollowers = ClusterMember.parse(passiveMembers)) {
                if (!this.memberStatusEndpoint.equals(follower.memberFacingEndpoint())) continue;
                this.memberId = follower.id();
                this.clusterMembers = ClusterMember.parse(activeMembers);
                this.leaderMember = ClusterMember.findMember(this.clusterMembers, leaderMemberId);
                if (null == this.leaderMember) break;
                if (!this.leaderMember.memberFacingEndpoint().equals(this.clusterMemberStatusEndpoints[this.clusterMembersStatusEndpointsCursor])) {
                    this.clusterPublication.close();
                    ChannelUri memberStatusUri = ChannelUri.parse(this.ctx.memberStatusChannel());
                    memberStatusUri.put("endpoint", this.leaderMember.memberFacingEndpoint());
                    this.clusterPublication = this.ctx.aeron().addExclusivePublication(memberStatusUri.toString(), this.ctx.memberStatusStreamId());
                }
                this.timeOfLastActivityMs = 0L;
                this.state(State.PASSIVE_FOLLOWER);
                break;
            }
        }
    }

    public void onSnapshotRecordings(long correlationId, SnapshotRecordingsDecoder snapshotRecordingsDecoder) {
        if (State.PASSIVE_FOLLOWER == this.state && correlationId == this.correlationId) {
            SnapshotRecordingsDecoder.SnapshotsDecoder snapshotsDecoder = snapshotRecordingsDecoder.snapshots();
            if (snapshotsDecoder.count() > 0) {
                for (SnapshotRecordingsDecoder.SnapshotsDecoder snapshot : snapshotsDecoder) {
                    if (snapshot.serviceId() > this.ctx.serviceCount()) continue;
                    this.leaderSnapshots.add(new RecordingLog.Snapshot(snapshot.recordingId(), snapshot.leadershipTermId(), snapshot.termBaseLogPosition(), snapshot.logPosition(), snapshot.timestamp(), snapshot.serviceId()));
                }
            }
            this.timeOfLastActivityMs = 0L;
            this.snapshotCursor = 0;
            this.correlationId = -1L;
            if (this.leaderSnapshots.isEmpty()) {
                this.state(State.SNAPSHOT_LOAD);
            } else {
                ChannelUri leaderArchiveUri = ChannelUri.parse(this.ctx.archiveContext().controlRequestChannel());
                ChannelUri localArchiveUri = ChannelUri.parse(this.ctx.archiveContext().controlResponseChannel());
                leaderArchiveUri.put("endpoint", this.leaderMember.archiveEndpoint());
                AeronArchive.Context leaderArchiveCtx = new AeronArchive.Context().aeron(this.ctx.aeron()).controlRequestChannel(leaderArchiveUri.toString()).controlRequestStreamId(this.ctx.archiveContext().controlRequestStreamId()).controlResponseChannel(localArchiveUri.toString()).controlResponseStreamId(this.ctx.archiveContext().controlResponseStreamId());
                this.leaderArchiveAsyncConnect = AeronArchive.asyncConnect(leaderArchiveCtx);
                this.state(State.SNAPSHOT_RETRIEVE);
            }
        }
    }

    private int init(long nowMs) {
        if (nowMs > this.timeOfLastActivityMs + this.intervalMs) {
            this.clusterMembersStatusEndpointsCursor = Math.min(this.clusterMembersStatusEndpointsCursor + 1, this.clusterMemberStatusEndpoints.length - 1);
            CloseHelper.close(this.clusterPublication);
            ChannelUri memberStatusUri = ChannelUri.parse(this.ctx.memberStatusChannel());
            memberStatusUri.put("endpoint", this.clusterMemberStatusEndpoints[this.clusterMembersStatusEndpointsCursor]);
            this.clusterPublication = this.ctx.aeron().addExclusivePublication(memberStatusUri.toString(), this.ctx.memberStatusStreamId());
            this.correlationId = this.ctx.aeron().nextCorrelationId();
            if (this.memberStatusPublisher.addPassiveMember(this.clusterPublication, this.correlationId, this.memberEndpoints)) {
                this.timeOfLastActivityMs = nowMs;
                return 1;
            }
        }
        return 0;
    }

    private int passiveFollower(long nowMs) {
        if (nowMs > this.timeOfLastActivityMs + this.intervalMs) {
            this.correlationId = this.ctx.aeron().nextCorrelationId();
            if (this.memberStatusPublisher.snapshotRecordingQuery(this.clusterPublication, this.correlationId, this.memberId)) {
                this.timeOfLastActivityMs = nowMs;
                return 1;
            }
        }
        return 0;
    }

    private int snapshotRetrieve() {
        int workCount = 0;
        if (null == this.leaderArchive) {
            this.leaderArchive = this.leaderArchiveAsyncConnect.poll();
            return null == this.leaderArchive ? 0 : 1;
        }
        if (null != this.snapshotReader) {
            if (this.snapshotReader.poll() == 0) {
                if (this.snapshotReader.isDone()) {
                    this.consensusModuleAgent.retrievedSnapshot(this.snapshotReader.recordingId(), this.leaderSnapshots.get(this.snapshotCursor));
                    CloseHelper.close(this.snapshotRetrieveSubscription);
                    this.localArchive.stopRecording(this.snapshotRetrieveSubscriptionId);
                    this.snapshotRetrieveSubscription = null;
                    this.snapshotRetrieveImage = null;
                    this.snapshotReader = null;
                    this.correlationId = -1L;
                    this.snapshotReplaySessionId = -1;
                    if (++this.snapshotCursor >= this.leaderSnapshots.size()) {
                        this.state(State.SNAPSHOT_LOAD);
                        ++workCount;
                    }
                } else if (null != this.snapshotRetrieveImage && this.snapshotRetrieveImage.isClosed()) {
                    throw new ClusterException("retrieval of snapshot image ended unexpectedly");
                }
            } else {
                ++workCount;
            }
        } else if (null == this.snapshotRetrieveImage && null != this.snapshotRetrieveSubscription) {
            this.snapshotRetrieveImage = this.snapshotRetrieveSubscription.imageBySessionId(this.snapshotReplaySessionId);
            if (null != this.snapshotRetrieveImage) {
                this.snapshotReader = new SnapshotReader(this.snapshotRetrieveImage, this.ctx.aeron().countersReader());
                ++workCount;
            }
        } else if (-1L == this.correlationId) {
            long replayId = this.ctx.aeron().nextCorrelationId();
            RecordingLog.Snapshot snapshot = this.leaderSnapshots.get(this.snapshotCursor);
            String transferChannel = new ChannelUriStringBuilder().media("udp").endpoint(this.transferEndpoint).build();
            if (this.leaderArchive.archiveProxy().replay(snapshot.recordingId, 0L, -1L, transferChannel, this.ctx.replayStreamId(), replayId, this.leaderArchive.controlSessionId())) {
                this.correlationId = replayId;
                ++workCount;
            }
        } else if (DynamicJoin.pollForResponse(this.leaderArchive, this.correlationId)) {
            this.snapshotReplaySessionId = (int)this.leaderArchive.controlResponsePoller().relevantId();
            String replaySubscriptionChannel = new ChannelUriStringBuilder().media("udp").endpoint(this.transferEndpoint).sessionId(this.snapshotReplaySessionId).build();
            this.snapshotRetrieveSubscription = this.ctx.aeron().addSubscription(replaySubscriptionChannel, this.ctx.replayStreamId());
            this.snapshotRetrieveSubscriptionId = this.localArchive.startRecording(replaySubscriptionChannel, this.ctx.replayStreamId(), SourceLocation.REMOTE);
            ++workCount;
        }
        return workCount;
    }

    private int snapshotLoad() {
        int workCount = 0;
        if (null == this.recoveryStateCounter) {
            this.recoveryStateCounter = this.consensusModuleAgent.loadSnapshotsFromDynamicJoin();
            ++workCount;
        } else if (this.consensusModuleAgent.pollForEndOfSnapshotLoad(this.recoveryStateCounter)) {
            this.recoveryStateCounter.close();
            this.recoveryStateCounter = null;
            this.state(State.JOIN_CLUSTER);
            ++workCount;
        }
        return workCount;
    }

    private int joinCluster() {
        long leadershipTermId;
        int workCount = 0;
        long l = leadershipTermId = this.leaderSnapshots.isEmpty() ? -1L : this.leaderSnapshots.get((int)0).leadershipTermId;
        if (this.memberStatusPublisher.joinCluster(this.clusterPublication, leadershipTermId, this.memberId) && this.consensusModuleAgent.dynamicJoinComplete()) {
            this.state(State.DONE);
            this.close();
            ++workCount;
        }
        return workCount;
    }

    private void state(State state) {
        this.state = state;
    }

    private static boolean pollForResponse(AeronArchive archive, long correlationId) {
        ControlResponsePoller poller = archive.controlResponsePoller();
        if (poller.poll() > 0 && poller.isPollComplete() && poller.controlSessionId() == archive.controlSessionId() && poller.correlationId() == correlationId) {
            if (poller.code() == ControlResponseCode.ERROR) {
                throw new ClusterException("archive response for correlationId=" + correlationId + ", error: " + poller.errorMessage());
            }
            return true;
        }
        return false;
    }

    static class SnapshotReader
    implements ControlledFragmentHandler {
        private static final int FRAGMENT_LIMIT = 10;
        private boolean inSnapshot = false;
        private boolean isDone = false;
        private long endPosition = 0L;
        private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
        private final SnapshotMarkerDecoder snapshotMarkerDecoder = new SnapshotMarkerDecoder();
        private final CountersReader countersReader;
        private final Image image;
        private long recordingId = -1L;
        private long recPos = -1L;
        private int counterId;

        SnapshotReader(Image image, CountersReader countersReader) {
            this.countersReader = countersReader;
            this.image = image;
            this.counterId = RecordingPos.findCounterIdBySession(countersReader, image.sessionId());
        }

        boolean isDone() {
            return this.isDone && this.endPosition <= this.recPos;
        }

        long recordingId() {
            return this.recordingId;
        }

        void pollRecPos() {
            if (-1 == this.counterId) {
                this.counterId = RecordingPos.findCounterIdBySession(this.countersReader, this.image.sessionId());
            } else if (-1L == this.recordingId) {
                this.recordingId = RecordingPos.getRecordingId(this.countersReader, this.counterId);
            } else {
                this.recPos = this.countersReader.getCounterValue(this.counterId);
            }
        }

        int poll() {
            this.pollRecPos();
            return this.image.controlledPoll(this, 10);
        }

        @Override
        public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
            this.messageHeaderDecoder.wrap(buffer, offset);
            if (this.messageHeaderDecoder.templateId() == 100) {
                this.snapshotMarkerDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long typeId = this.snapshotMarkerDecoder.typeId();
                if (typeId != 1L && typeId != 2L) {
                    throw new ClusterException("unexpected snapshot type: " + typeId);
                }
                switch (this.snapshotMarkerDecoder.mark()) {
                    case BEGIN: {
                        if (this.inSnapshot) {
                            throw new ClusterException("already in snapshot");
                        }
                        this.inSnapshot = true;
                        return ControlledFragmentHandler.Action.CONTINUE;
                    }
                    case END: {
                        if (!this.inSnapshot) {
                            throw new ClusterException("missing begin snapshot");
                        }
                        this.isDone = true;
                        this.endPosition = header.position();
                        return ControlledFragmentHandler.Action.BREAK;
                    }
                }
            }
            return ControlledFragmentHandler.Action.CONTINUE;
        }
    }

    static enum State {
        INIT,
        PASSIVE_FOLLOWER,
        SNAPSHOT_RETRIEVE,
        SNAPSHOT_LOAD,
        JOIN_CLUSTER,
        DONE;

    }
}

