/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Publication;
import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.ClusterSession;
import io.aeron.cluster.codecs.ClusterMembersEncoder;
import io.aeron.cluster.codecs.ClusterSessionEncoder;
import io.aeron.cluster.codecs.ConsensusModuleEncoder;
import io.aeron.cluster.codecs.TimerEncoder;
import io.aeron.cluster.service.SnapshotTaker;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.IdleStrategy;

class ConsensusModuleSnapshotTaker
extends SnapshotTaker {
    private static final int ENCODED_TIMER_LENGTH = 24;
    private final ClusterSessionEncoder clusterSessionEncoder = new ClusterSessionEncoder();
    private final TimerEncoder timerEncoder = new TimerEncoder();
    private final ConsensusModuleEncoder consensusModuleEncoder = new ConsensusModuleEncoder();
    private final ClusterMembersEncoder clusterMembersEncoder = new ClusterMembersEncoder();

    ConsensusModuleSnapshotTaker(Publication publication, IdleStrategy idleStrategy, AgentInvoker aeronClientInvoker) {
        super(publication, idleStrategy, aeronClientInvoker);
    }

    void snapshotSession(ClusterSession session) {
        String responseChannel = session.responseChannel();
        int length = 48 + ClusterSessionEncoder.responseChannelHeaderLength() + responseChannel.length();
        this.idleStrategy.reset();
        while (true) {
            long result;
            if ((result = this.publication.tryClaim(length, this.bufferClaim)) > 0L) break;
            this.checkResultAndIdle(result);
        }
        this.clusterSessionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).clusterSessionId(session.id()).correlationId(session.correlationId()).openedLogPosition(session.openedLogPosition()).timeOfLastActivity(session.timeOfLastActivityMs()).closeReason(session.closeReason()).responseStreamId(session.responseStreamId()).responseChannel(responseChannel);
        this.bufferClaim.commit();
    }

    void snapshotTimer(long correlationId, long deadline) {
        this.idleStrategy.reset();
        while (true) {
            long result;
            if ((result = this.publication.tryClaim(24, this.bufferClaim)) > 0L) break;
            this.checkResultAndIdle(result);
        }
        this.timerEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).deadline(deadline);
        this.bufferClaim.commit();
    }

    void consensusModuleState(long nextSessionId) {
        int length = 16;
        this.idleStrategy.reset();
        while (true) {
            long result;
            if ((result = this.publication.tryClaim(16, this.bufferClaim)) > 0L) break;
            this.checkResultAndIdle(result);
        }
        this.consensusModuleEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).nextSessionId(nextSessionId);
        this.bufferClaim.commit();
    }

    void clusterMembers(int memberId, int highMemberId, ClusterMember[] members) {
        String clusterMembers = ClusterMember.encodeAsString(members);
        int length = 16 + ClusterMembersEncoder.clusterMembersHeaderLength() + clusterMembers.length();
        this.idleStrategy.reset();
        while (true) {
            long result;
            if ((result = this.publication.tryClaim(length, this.bufferClaim)) > 0L) break;
            this.checkResultAndIdle(result);
        }
        this.clusterMembersEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).memberId(memberId).highMemberId(highMemberId).clusterMembers(clusterMembers);
        this.bufferClaim.commit();
    }
}

