/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Subscription;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.CancelTimerDecoder;
import io.aeron.cluster.codecs.CloseSessionDecoder;
import io.aeron.cluster.codecs.ClusterMembersQueryDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.RemoveMemberDecoder;
import io.aeron.cluster.codecs.ScheduleTimerDecoder;
import io.aeron.cluster.codecs.ServiceAckDecoder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;

final class ConsensusModuleAdapter
implements FragmentHandler,
AutoCloseable {
    private final Subscription subscription;
    private final ConsensusModuleAgent consensusModuleAgent;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ScheduleTimerDecoder scheduleTimerDecoder = new ScheduleTimerDecoder();
    private final CancelTimerDecoder cancelTimerDecoder = new CancelTimerDecoder();
    private final ServiceAckDecoder serviceAckDecoder = new ServiceAckDecoder();
    private final CloseSessionDecoder closeSessionDecoder = new CloseSessionDecoder();
    private final ClusterMembersQueryDecoder clusterMembersQueryDecoder = new ClusterMembersQueryDecoder();
    private final RemoveMemberDecoder removeMemberDecoder = new RemoveMemberDecoder();

    ConsensusModuleAdapter(Subscription subscription, ConsensusModuleAgent consensusModuleAgent) {
        this.subscription = subscription;
        this.consensusModuleAgent = consensusModuleAgent;
    }

    @Override
    public void close() {
        CloseHelper.close(this.subscription);
    }

    int poll() {
        return this.subscription.poll(this, 1);
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.sbeSchemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        int templateId = this.messageHeaderDecoder.templateId();
        switch (templateId) {
            case 30: {
                this.closeSessionDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onServiceCloseSession(this.closeSessionDecoder.clusterSessionId());
                break;
            }
            case 31: {
                this.scheduleTimerDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onScheduleTimer(this.scheduleTimerDecoder.correlationId(), this.scheduleTimerDecoder.deadline());
                break;
            }
            case 32: {
                this.cancelTimerDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onCancelTimer(this.scheduleTimerDecoder.correlationId());
                break;
            }
            case 33: {
                this.serviceAckDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onServiceAck(this.serviceAckDecoder.logPosition(), this.serviceAckDecoder.ackId(), this.serviceAckDecoder.relevantId(), this.serviceAckDecoder.serviceId());
                break;
            }
            case 34: {
                this.clusterMembersQueryDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onClusterMembersQuery(this.clusterMembersQueryDecoder.correlationId());
                break;
            }
            case 35: {
                this.removeMemberDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onRemoveMember(this.removeMemberDecoder.correlationId(), this.removeMemberDecoder.memberId(), BooleanType.TRUE == this.removeMemberDecoder.isPassive());
            }
        }
    }
}

