/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.archive.Archive;
import io.aeron.cluster.ConsensusModule;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.status.SystemCounterDescriptor;
import org.agrona.CloseHelper;
import org.agrona.SystemUtil;

public class ClusteredMediaDriver
implements AutoCloseable {
    private final MediaDriver driver;
    private final Archive archive;
    private final ConsensusModule consensusModule;

    ClusteredMediaDriver(MediaDriver driver, Archive archive, ConsensusModule consensusModule) {
        this.driver = driver;
        this.archive = archive;
        this.consensusModule = consensusModule;
    }

    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles(args);
        try (ClusteredMediaDriver driver = ClusteredMediaDriver.launch();){
            driver.consensusModule().context().shutdownSignalBarrier().await();
            System.out.println("Shutdown ClusteredMediaDriver...");
        }
    }

    public static ClusteredMediaDriver launch() {
        return ClusteredMediaDriver.launch(new MediaDriver.Context(), new Archive.Context(), new ConsensusModule.Context());
    }

    public static ClusteredMediaDriver launch(MediaDriver.Context driverCtx, Archive.Context archiveCtx, ConsensusModule.Context consensusModuleCtx) {
        MediaDriver driver = MediaDriver.launch(driverCtx.spiesSimulateConnection(true));
        Archive archive = Archive.launch(archiveCtx.mediaDriverAgentInvoker(driver.sharedAgentInvoker()).errorHandler(driverCtx.errorHandler()).errorCounter(driverCtx.systemCounters().get(SystemCounterDescriptor.ERRORS)));
        ConsensusModule consensusModule = ConsensusModule.launch(consensusModuleCtx);
        return new ClusteredMediaDriver(driver, archive, consensusModule);
    }

    public MediaDriver mediaDriver() {
        return this.driver;
    }

    public Archive archive() {
        return this.archive;
    }

    public ConsensusModule consensusModule() {
        return this.consensusModule;
    }

    @Override
    public void close() {
        CloseHelper.close(this.consensusModule);
        CloseHelper.close(this.archive);
        CloseHelper.close(this.driver);
    }
}

