/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.CncFileDescriptor;
import io.aeron.archive.client.AeronArchive;
import io.aeron.cluster.MemberServiceAdapter;
import io.aeron.cluster.RecordingLog;
import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.service.ClusterMarkFile;
import io.aeron.cluster.service.ConsensusModuleProxy;
import io.aeron.exceptions.AeronException;
import java.io.File;
import java.io.PrintStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.MappedByteBuffer;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.agrona.IoUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.collections.MutableLong;
import org.agrona.concurrent.UnsafeBuffer;

public class ClusterTool {
    private static final long TIMEOUT_MS = Long.getLong("aeron.ClusterTool.timeoutMs", 0L);

    public static void main(String[] args) {
        File clusterDir;
        if (args.length < 2) {
            ClusterTool.printHelp(System.out);
            System.exit(-1);
        }
        if (!(clusterDir = new File(args[0])).exists()) {
            System.err.println("ERR: cluster directory not found: " + clusterDir.getAbsolutePath());
            ClusterTool.printHelp(System.out);
            System.exit(-1);
        }
        switch (args[1]) {
            case "describe": {
                ClusterTool.describe(System.out, clusterDir);
                break;
            }
            case "pid": {
                ClusterTool.pid(System.out, clusterDir);
                break;
            }
            case "recovery-plan": {
                if (args.length < 3) {
                    ClusterTool.printHelp(System.out);
                    System.exit(-1);
                }
                ClusterTool.recoveryPlan(System.out, clusterDir, Integer.parseInt(args[2]));
                break;
            }
            case "recording-log": {
                ClusterTool.recordingLog(System.out, clusterDir);
                break;
            }
            case "errors": {
                ClusterTool.errors(System.out, clusterDir);
                break;
            }
            case "list-members": {
                ClusterTool.listMembers(System.out, clusterDir);
                break;
            }
            case "remove-member": {
                if (args.length < 3) {
                    ClusterTool.printHelp(System.out);
                    System.exit(-1);
                }
                ClusterTool.removeMember(System.out, clusterDir, Integer.parseInt(args[2]), false);
                break;
            }
            case "remove-passive": {
                if (args.length < 3) {
                    ClusterTool.printHelp(System.out);
                    System.exit(-1);
                }
                ClusterTool.removeMember(System.out, clusterDir, Integer.parseInt(args[2]), true);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void describe(PrintStream out, File clusterDir) {
        if (ClusterTool.markFileExists(clusterDir)) ** GOTO lbl6
        if (ClusterTool.TIMEOUT_MS > 0L) {
lbl6:
            // 2 sources

            markFile = ClusterTool.openMarkFile(clusterDir, (Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, println(java.lang.String ), (Ljava/lang/String;)V)((PrintStream)out));
            var3_3 = null;
            try {
                ClusterTool.printTypeAndActivityTimestamp(out, markFile);
                out.println(markFile.decoder());
            }
            catch (Throwable var4_5) {
                var3_3 = var4_5;
                throw var4_5;
            }
            finally {
                if (markFile != null) {
                    if (var3_3 != null) {
                        try {
                            markFile.close();
                        }
                        catch (Throwable var4_4) {
                            var3_3.addSuppressed(var4_4);
                        }
                    } else {
                        markFile.close();
                    }
                }
            }
        } else {
            out.println("cluster-mark.dat does not exist.");
        }
        serviceMarkFiles = ClusterTool.openServiceMarkFiles(clusterDir, (Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, println(java.lang.String ), (Ljava/lang/String;)V)((PrintStream)out));
        ClusterTool.describe(out, serviceMarkFiles);
    }

    public static void pid(PrintStream out, File clusterDir) {
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir, null);){
                out.println(markFile.decoder().pid());
            }
        } else {
            System.exit(-1);
        }
    }

    public static void recoveryPlan(PrintStream out, File clusterDir, int serviceCount) {
        try (AeronArchive archive = AeronArchive.connect();
             RecordingLog recordingLog = new RecordingLog(clusterDir);){
            out.println(recordingLog.createRecoveryPlan(archive, serviceCount));
        }
    }

    public static void recordingLog(PrintStream out, File clusterDir) {
        try (RecordingLog recordingLog = new RecordingLog(clusterDir);){
            out.println(recordingLog.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void errors(PrintStream out, File clusterDir) {
        if (ClusterTool.markFileExists(clusterDir)) ** GOTO lbl6
        if (ClusterTool.TIMEOUT_MS > 0L) {
lbl6:
            // 2 sources

            markFile = ClusterTool.openMarkFile(clusterDir, (Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, println(java.lang.String ), (Ljava/lang/String;)V)((PrintStream)System.out));
            var3_3 = null;
            try {
                ClusterTool.printTypeAndActivityTimestamp(out, markFile);
                ClusterTool.printErrors(out, markFile);
            }
            catch (Throwable var4_5) {
                var3_3 = var4_5;
                throw var4_5;
            }
            finally {
                if (markFile != null) {
                    if (var3_3 != null) {
                        try {
                            markFile.close();
                        }
                        catch (Throwable var4_4) {
                            var3_3.addSuppressed(var4_4);
                        }
                    } else {
                        markFile.close();
                    }
                }
            }
        } else {
            out.println("cluster-mark.dat does not exist.");
        }
        serviceMarkFiles = ClusterTool.openServiceMarkFiles(clusterDir, (Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, println(java.lang.String ), (Ljava/lang/String;)V)((PrintStream)out));
        ClusterTool.errors(out, serviceMarkFiles);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void listMembers(PrintStream out, File clusterDir) {
        if (!ClusterTool.markFileExists(clusterDir) && TIMEOUT_MS <= 0L) {
            out.println("cluster-mark.dat does not exist.");
            return;
        }
        try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir, System.out::println);){
            ClusterMembersInfo clusterMembersInfo = new ClusterMembersInfo();
            long timeoutMs = Math.max(TimeUnit.SECONDS.toMillis(1L), TIMEOUT_MS);
            if (ClusterTool.queryClusterMembers(markFile, clusterMembersInfo, timeoutMs)) {
                out.format("leaderMemberId=%d, activeMembers=%s, passiveMembers=%s%n", clusterMembersInfo.leaderMemberId, clusterMembersInfo.activeMembers, clusterMembersInfo.passiveMembers);
                return;
            }
            out.format("timeout waiting for response from node", new Object[0]);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeMember(PrintStream out, File clusterDir, int memberId, boolean isPassive) {
        if (!ClusterTool.markFileExists(clusterDir) && TIMEOUT_MS <= 0L) {
            out.println("cluster-mark.dat does not exist.");
            return;
        }
        try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir, System.out::println);){
            if (ClusterTool.removeMember(markFile, memberId, isPassive)) return;
            out.println("could not send remove member request");
            return;
        }
    }

    public static void describe(PrintStream out, ClusterMarkFile[] serviceMarkFiles) {
        for (ClusterMarkFile serviceMarkFile : serviceMarkFiles) {
            ClusterTool.printTypeAndActivityTimestamp(out, serviceMarkFile);
            out.println(serviceMarkFile.decoder());
            serviceMarkFile.close();
        }
    }

    public static void errors(PrintStream out, ClusterMarkFile[] serviceMarkFiles) {
        for (ClusterMarkFile serviceMarkFile : serviceMarkFiles) {
            ClusterTool.printTypeAndActivityTimestamp(out, serviceMarkFile);
            ClusterTool.printErrors(out, serviceMarkFile);
            serviceMarkFile.close();
        }
    }

    public static boolean markFileExists(File clusterDir) {
        File markFile = new File(clusterDir, "cluster-mark.dat");
        return markFile.exists();
    }

    public static boolean listMembers(ClusterMembersInfo clusterMembersInfo, File clusterDir, long timeoutMs) {
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir, null);){
                boolean bl = ClusterTool.queryClusterMembers(markFile, clusterMembersInfo, timeoutMs);
                return bl;
            }
        }
        return false;
    }

    public static boolean queryClusterMembers(ClusterMarkFile markFile, ClusterMembersInfo clusterMembersInfo, long timeoutMs) {
        MutableLong id;
        block38: {
            String aeronDirectoryName = markFile.decoder().aeronDirectory();
            String archiveChannel = markFile.decoder().archiveChannel();
            String channel = markFile.decoder().serviceControlChannel();
            int toServiceStreamId = markFile.decoder().serviceStreamId();
            int toConsensusModuleStreamId = markFile.decoder().consensusModuleStreamId();
            id = new MutableLong(-1L);
            MemberServiceAdapter.MemberServiceHandler handler = (correlationId, leaderMemberId, activeMembers, passiveMembers) -> {
                if (correlationId == id.longValue()) {
                    clusterMembersInfo.leaderMemberId = leaderMemberId;
                    clusterMembersInfo.activeMembers = activeMembers;
                    clusterMembersInfo.passiveMembers = passiveMembers;
                    id.set(-1L);
                }
            };
            try (Aeron aeron = Aeron.connect(new Aeron.Context().aeronDirectoryName(aeronDirectoryName));
                 ConsensusModuleProxy consensusModuleProxy = new ConsensusModuleProxy(aeron.addPublication(channel, toConsensusModuleStreamId));
                 MemberServiceAdapter memberServiceAdapter = new MemberServiceAdapter(aeron.addSubscription(channel, toServiceStreamId), handler);){
                id.set(aeron.nextCorrelationId());
                if (!consensusModuleProxy.clusterMembersQuery(id.longValue())) break block38;
                long startTime = System.currentTimeMillis();
                do {
                    if (memberServiceAdapter.poll() != 0) continue;
                    if (System.currentTimeMillis() - startTime > timeoutMs) {
                        break;
                    }
                    Thread.yield();
                } while (-1L != id.longValue());
            }
        }
        return id.longValue() == -1L;
    }

    public static boolean removeMember(File clusterDir, int memberId, boolean isPassive) {
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir, null);){
                boolean bl = ClusterTool.removeMember(markFile, memberId, isPassive);
                return bl;
            }
        }
        return false;
    }

    public static boolean removeMember(ClusterMarkFile markFile, int memberId, boolean isPassive) {
        String aeronDirectoryName = markFile.decoder().aeronDirectory();
        String archiveChannel = markFile.decoder().archiveChannel();
        String channel = markFile.decoder().serviceControlChannel();
        int toServiceStreamId = markFile.decoder().serviceStreamId();
        int toConsensusModuleStreamId = markFile.decoder().consensusModuleStreamId();
        try (Aeron aeron = Aeron.connect(new Aeron.Context().aeronDirectoryName(aeronDirectoryName));
             ConsensusModuleProxy consensusModuleProxy = new ConsensusModuleProxy(aeron.addPublication(channel, toConsensusModuleStreamId));){
            if (consensusModuleProxy.removeMember(aeron.nextCorrelationId(), memberId, isPassive ? BooleanType.TRUE : BooleanType.FALSE)) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static ClusterMarkFile openMarkFile(File clusterDir, Consumer<String> logger) {
        return new ClusterMarkFile(clusterDir, "cluster-mark.dat", System::currentTimeMillis, TIMEOUT_MS, logger);
    }

    private static ClusterMarkFile[] openServiceMarkFiles(File clusterDir, Consumer<String> logger) {
        String[] clusterMarkFileNames = clusterDir.list((dir, name) -> name.startsWith("cluster-mark-service-") && name.endsWith(".dat"));
        if (null == clusterMarkFileNames) {
            clusterMarkFileNames = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ClusterMarkFile[] clusterMarkFiles = new ClusterMarkFile[clusterMarkFileNames.length];
        int length = clusterMarkFiles.length;
        for (int i = 0; i < length; ++i) {
            clusterMarkFiles[i] = new ClusterMarkFile(clusterDir, clusterMarkFileNames[i], System::currentTimeMillis, TIMEOUT_MS, logger);
        }
        return clusterMarkFiles;
    }

    private static void printTypeAndActivityTimestamp(PrintStream out, ClusterMarkFile markFile) {
        out.print("Type: " + (Object)((Object)markFile.decoder().componentType()) + " ");
        out.format("%1$tH:%1$tM:%1$tS (start: %2$tF %2$tH:%2$tM:%2$tS, activity: %3$tF %3$tH:%3$tM:%3$tS)%n", new Date(), new Date(markFile.decoder().startTimestamp()), new Date(markFile.activityTimestampVolatile()));
    }

    private static void printErrors(PrintStream out, ClusterMarkFile markFile) {
        out.println("Cluster component error log:");
        ClusterMarkFile.saveErrorLog(out, markFile.errorBuffer());
        String aeronDirectory = markFile.decoder().aeronDirectory();
        out.println("Aeron driver error log (directory: " + aeronDirectory + "):");
        File cncFile = new File(aeronDirectory, "cnc.dat");
        MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile(cncFile, "cnc");
        UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset(0));
        if (15 != cncVersion) {
            throw new AeronException("Aeron CnC version does not match: version=" + cncVersion + " required=" + 15);
        }
        UnsafeBuffer buffer = CncFileDescriptor.createErrorLogBuffer(cncByteBuffer, cncMetaDataBuffer);
        ClusterMarkFile.saveErrorLog(out, buffer);
    }

    private static void printHelp(PrintStream out) {
        out.println("Usage: <cluster-dir> <command> [options]");
        out.println("  describe: prints out all descriptors in the file.");
        out.println("  pid: prints PID of cluster component.");
        out.println("  recovery-plan: [service count] prints recovery plan of cluster component.");
        out.println("  recording-log: prints recording log of cluster component.");
        out.println("  errors: prints Aeron and cluster component error logs.");
    }

    public static class ClusterMembersInfo {
        int leaderMemberId = -1;
        String activeMembers = null;
        String passiveMembers = null;
    }
}

