/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.MemberStatusPublisher;

class ClusterTermination {
    private final MemberStatusPublisher memberStatusPublisher;
    private long deadlineMs;
    private boolean hasServiceTerminated = false;

    ClusterTermination(MemberStatusPublisher memberStatusPublisher, long deadlineMs) {
        this.deadlineMs = deadlineMs;
        this.memberStatusPublisher = memberStatusPublisher;
    }

    void deadlineMs(long deadlineMs) {
        this.deadlineMs = deadlineMs;
    }

    boolean canTerminate(ClusterMember[] members, long terminationPosition, long nowMs) {
        if (!this.hasServiceTerminated) {
            return false;
        }
        return ClusterTermination.haveFollowersTerminated(members, terminationPosition) || nowMs >= this.deadlineMs;
    }

    void hasServiceTerminated(boolean hasServiceTerminated) {
        this.hasServiceTerminated = hasServiceTerminated;
    }

    void terminationPosition(ClusterMember[] members, ClusterMember thisMember, long position) {
        for (ClusterMember member : members) {
            member.hasSentTerminationAck(false);
            if (member == thisMember) continue;
            this.memberStatusPublisher.terminationPosition(member.publication(), position);
        }
    }

    private static boolean haveFollowersTerminated(ClusterMember[] members, long terminationPosition) {
        boolean result = true;
        for (ClusterMember member : members) {
            if (member.hasSentTerminationAck() || member.logPosition() >= terminationPosition) continue;
            result = false;
            break;
        }
        return result;
    }
}

