/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.ClusterSession;
import io.aeron.cluster.EgressPublisher;
import io.aeron.cluster.codecs.EventCode;
import io.aeron.security.SessionProxy;

class ClusterSessionProxy
implements SessionProxy {
    private static final String EMPTY_DETAIL = "";
    private final EgressPublisher egressPublisher;
    private ClusterSession clusterSession;
    private long leadershipTermId;
    private int leaderMemberId;

    ClusterSessionProxy(EgressPublisher egressPublisher) {
        this.egressPublisher = egressPublisher;
    }

    final SessionProxy session(ClusterSession clusterSession) {
        this.clusterSession = clusterSession;
        return this;
    }

    final ClusterSessionProxy leaderMemberId(int leaderMemberId) {
        this.leaderMemberId = leaderMemberId;
        return this;
    }

    final ClusterSessionProxy leadershipTermId(long leadershipTermId) {
        this.leadershipTermId = leadershipTermId;
        return this;
    }

    @Override
    public final long sessionId() {
        return this.clusterSession.id();
    }

    @Override
    public final boolean challenge(byte[] encodedChallenge) {
        if (this.egressPublisher.sendChallenge(this.clusterSession, encodedChallenge)) {
            this.clusterSession.state(ClusterSession.State.CHALLENGED);
            return true;
        }
        return false;
    }

    @Override
    public final boolean authenticate(byte[] encodedPrincipal) {
        ClusterSession.checkEncodedPrincipalLength(encodedPrincipal);
        if (this.egressPublisher.sendEvent(this.clusterSession, this.leadershipTermId, this.leaderMemberId, EventCode.OK, EMPTY_DETAIL)) {
            this.clusterSession.authenticate(encodedPrincipal);
            return true;
        }
        return false;
    }

    @Override
    public final void reject() {
        this.clusterSession.state(ClusterSession.State.REJECTED);
    }
}

