/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.Publication;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.CloseReason;
import io.aeron.driver.exceptions.InvalidChannelException;
import io.aeron.logbuffer.BufferClaim;
import java.util.Arrays;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.collections.ArrayUtil;

class ClusterSession {
    static final byte[] NULL_PRINCIPAL = ArrayUtil.EMPTY_BYTE_ARRAY;
    static final int MAX_ENCODED_PRINCIPAL_LENGTH = 4096;
    static final int MAX_ENCODED_MEMBERSHIP_QUERY_LENGTH = 4096;
    private boolean hasNewLeaderEventPending = false;
    private final long id;
    private long correlationId;
    private long openedLogPosition = -1L;
    private long timeOfLastActivityMs;
    private final int responseStreamId;
    private final String responseChannel;
    private Publication responsePublication;
    private State state = State.INIT;
    private CloseReason closeReason = CloseReason.NULL_VAL;
    private byte[] encodedPrincipal = NULL_PRINCIPAL;

    ClusterSession(long sessionId, int responseStreamId, String responseChannel) {
        this.id = sessionId;
        this.responseStreamId = responseStreamId;
        this.responseChannel = responseChannel;
    }

    ClusterSession(long sessionId, long correlationId, long openedLogPosition, long timeOfLastActivityMs, int responseStreamId, String responseChannel, CloseReason closeReason) {
        this.id = sessionId;
        this.responseStreamId = responseStreamId;
        this.responseChannel = responseChannel;
        this.openedLogPosition = openedLogPosition;
        this.timeOfLastActivityMs = timeOfLastActivityMs;
        this.correlationId = correlationId;
        this.closeReason = closeReason;
        this.state = CloseReason.NULL_VAL != closeReason ? State.CLOSED : State.OPEN;
    }

    public void close() {
        CloseHelper.close(this.responsePublication);
        this.responsePublication = null;
        this.state = State.CLOSED;
    }

    long id() {
        return this.id;
    }

    int responseStreamId() {
        return this.responseStreamId;
    }

    String responseChannel() {
        return this.responseChannel;
    }

    void close(CloseReason closeReason) {
        this.closeReason = closeReason;
        this.close();
    }

    CloseReason closeReason() {
        return this.closeReason;
    }

    void connect(Aeron aeron) {
        if (null != this.responsePublication) {
            throw new ClusterException("response publication already added");
        }
        try {
            this.responsePublication = aeron.addPublication(this.responseChannel, this.responseStreamId);
        }
        catch (InvalidChannelException invalidChannelException) {
            // empty catch block
        }
    }

    boolean isResponsePublicationConnected() {
        return null != this.responsePublication && this.responsePublication.isConnected();
    }

    public long tryClaim(int length, BufferClaim bufferClaim) {
        if (null == this.responsePublication) {
            return -1L;
        }
        return this.responsePublication.tryClaim(length, bufferClaim);
    }

    public long offer(DirectBuffer buffer, int offset, int length) {
        if (null == this.responsePublication) {
            return -1L;
        }
        return this.responsePublication.offer(buffer, offset, length);
    }

    State state() {
        return this.state;
    }

    void state(State state) {
        this.state = state;
    }

    void authenticate(byte[] encodedPrincipal) {
        if (encodedPrincipal != null) {
            this.encodedPrincipal = encodedPrincipal;
        }
        this.state = State.AUTHENTICATED;
    }

    void open(long openedLogPosition) {
        this.openedLogPosition = openedLogPosition;
        this.state = State.OPEN;
        this.encodedPrincipal = null;
    }

    byte[] encodedPrincipal() {
        return this.encodedPrincipal;
    }

    void lastActivity(long timeMs, long correlationId) {
        this.timeOfLastActivityMs = timeMs;
        this.correlationId = correlationId;
    }

    long timeOfLastActivityMs() {
        return this.timeOfLastActivityMs;
    }

    void timeOfLastActivityMs(long timeMs) {
        this.timeOfLastActivityMs = timeMs;
    }

    long correlationId() {
        return this.correlationId;
    }

    long openedLogPosition() {
        return this.openedLogPosition;
    }

    void hasNewLeaderEventPending(boolean flag) {
        this.hasNewLeaderEventPending = flag;
    }

    boolean hasNewLeaderEventPending() {
        return this.hasNewLeaderEventPending;
    }

    static void checkEncodedPrincipalLength(byte[] encodedPrincipal) {
        if (null != encodedPrincipal && encodedPrincipal.length > 4096) {
            throw new ClusterException("Encoded Principal max length 4096 exceeded: length=" + encodedPrincipal.length);
        }
    }

    public String toString() {
        return "ClusterSession{id=" + this.id + ", correlationId=" + this.correlationId + ", openedLogPosition=" + this.openedLogPosition + ", timeOfLastActivityMs=" + this.timeOfLastActivityMs + ", responseStreamId=" + this.responseStreamId + ", responseChannel='" + this.responseChannel + '\'' + ", closeReason=" + (Object)((Object)this.closeReason) + ", state=" + (Object)((Object)this.state) + ", hasNewLeaderEventPending=" + this.hasNewLeaderEventPending + ", encodedPrincipal=" + Arrays.toString(this.encodedPrincipal) + '}';
    }

    static enum State {
        INIT,
        CONNECTED,
        CHALLENGED,
        AUTHENTICATED,
        REJECTED,
        OPEN,
        CLOSED;

    }
}

