/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.Publication;
import io.aeron.cluster.client.ClusterException;
import org.agrona.CloseHelper;
import org.agrona.collections.ArrayUtil;
import org.agrona.collections.Int2ObjectHashMap;

public final class ClusterMember {
    public static final ClusterMember[] EMPTY_CLUSTER_MEMBER_ARRAY = new ClusterMember[0];
    private boolean isBallotSent;
    private boolean isLeader;
    private boolean hasRequestedJoin;
    private boolean hasSentTerminationAck;
    private int id;
    private long leadershipTermId = -1L;
    private long logPosition = -1L;
    private long candidateTermId = -1L;
    private long catchupReplaySessionId = -1L;
    private long changeCorrelationId = -1L;
    private long removalPosition = -1L;
    private long timeOfLastAppendPositionMs = -1L;
    private final String clientFacingEndpoint;
    private final String memberFacingEndpoint;
    private final String logEndpoint;
    private final String transferEndpoint;
    private final String archiveEndpoint;
    private final String endpointsDetail;
    private Publication publication;
    private Boolean vote = null;

    public ClusterMember(int id, String clientFacingEndpoint, String memberFacingEndpoint, String logEndpoint, String transferEndpoint, String archiveEndpoint, String endpointsDetail) {
        this.id = id;
        this.clientFacingEndpoint = clientFacingEndpoint;
        this.memberFacingEndpoint = memberFacingEndpoint;
        this.logEndpoint = logEndpoint;
        this.transferEndpoint = transferEndpoint;
        this.archiveEndpoint = archiveEndpoint;
        this.endpointsDetail = endpointsDetail;
    }

    public void reset() {
        this.isBallotSent = false;
        this.isLeader = false;
        this.hasRequestedJoin = false;
        this.hasSentTerminationAck = false;
        this.vote = null;
        this.candidateTermId = -1L;
        this.leadershipTermId = -1L;
        this.logPosition = -1L;
    }

    public ClusterMember isLeader(boolean isLeader) {
        this.isLeader = isLeader;
        return this;
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public ClusterMember isBallotSent(boolean isBallotSent) {
        this.isBallotSent = isBallotSent;
        return this;
    }

    public boolean isBallotSent() {
        return this.isBallotSent;
    }

    public ClusterMember hasRequestedJoin(boolean hasRequestedJoin) {
        this.hasRequestedJoin = hasRequestedJoin;
        return this;
    }

    public boolean hasRequestedJoin() {
        return this.hasRequestedJoin;
    }

    public ClusterMember hasSentTerminationAck(boolean hasSentTerminationAck) {
        this.hasSentTerminationAck = hasSentTerminationAck;
        return this;
    }

    public boolean hasSentTerminationAck() {
        return this.hasSentTerminationAck;
    }

    public ClusterMember removalPosition(long removalPosition) {
        this.removalPosition = removalPosition;
        return this;
    }

    public long removalPosition() {
        return this.removalPosition;
    }

    public boolean hasRequestedRemove() {
        return this.removalPosition != -1L;
    }

    public ClusterMember id(int id) {
        this.id = id;
        return this;
    }

    public int id() {
        return this.id;
    }

    public ClusterMember vote(Boolean vote) {
        this.vote = vote;
        return this;
    }

    public Boolean vote() {
        return this.vote;
    }

    public ClusterMember leadershipTermId(long leadershipTermId) {
        this.leadershipTermId = leadershipTermId;
        return this;
    }

    public long leadershipTermId() {
        return this.leadershipTermId;
    }

    public ClusterMember logPosition(long logPosition) {
        this.logPosition = logPosition;
        return this;
    }

    public long logPosition() {
        return this.logPosition;
    }

    public ClusterMember candidateTermId(long candidateTermId) {
        this.candidateTermId = candidateTermId;
        return this;
    }

    public long candidateTermId() {
        return this.candidateTermId;
    }

    public ClusterMember catchupReplaySessionId(long replaySessionId) {
        this.catchupReplaySessionId = replaySessionId;
        return this;
    }

    public long catchupReplaySessionId() {
        return this.catchupReplaySessionId;
    }

    public ClusterMember correlationId(long correlationId) {
        this.changeCorrelationId = correlationId;
        return this;
    }

    public long correlationId() {
        return this.changeCorrelationId;
    }

    public ClusterMember timeOfLastAppendPositionMs(long timeMs) {
        this.timeOfLastAppendPositionMs = timeMs;
        return this;
    }

    public long timeOfLastAppendPositionMs() {
        return this.timeOfLastAppendPositionMs;
    }

    public String clientFacingEndpoint() {
        return this.clientFacingEndpoint;
    }

    public String memberFacingEndpoint() {
        return this.memberFacingEndpoint;
    }

    public String logEndpoint() {
        return this.logEndpoint;
    }

    public String transferEndpoint() {
        return this.transferEndpoint;
    }

    public String archiveEndpoint() {
        return this.archiveEndpoint;
    }

    public String endpointsDetail() {
        return this.endpointsDetail;
    }

    public Publication publication() {
        return this.publication;
    }

    public void publication(Publication publication) {
        this.publication = publication;
    }

    public static ClusterMember[] parse(String value) {
        if (null == value || value.length() == 0) {
            return EMPTY_CLUSTER_MEMBER_ARRAY;
        }
        String[] memberValues = value.split("\\|");
        int length = memberValues.length;
        ClusterMember[] members = new ClusterMember[length];
        for (int i = 0; i < length; ++i) {
            String endpointsDetail = memberValues[i];
            String[] memberAttributes = endpointsDetail.split(",");
            if (memberAttributes.length != 6) {
                throw new ClusterException("invalid member value: " + endpointsDetail + " within: " + value);
            }
            String justEndpoints = String.join((CharSequence)",", memberAttributes[1], memberAttributes[2], memberAttributes[3], memberAttributes[4], memberAttributes[5]);
            members[i] = new ClusterMember(Integer.parseInt(memberAttributes[0]), memberAttributes[1], memberAttributes[2], memberAttributes[3], memberAttributes[4], memberAttributes[5], justEndpoints);
        }
        return members;
    }

    public static ClusterMember parseEndpoints(int id, String endpointsDetail) {
        String[] memberAttributes = endpointsDetail.split(",");
        if (memberAttributes.length != 5) {
            throw new ClusterException("invalid member value: " + endpointsDetail);
        }
        return new ClusterMember(id, memberAttributes[0], memberAttributes[1], memberAttributes[2], memberAttributes[3], memberAttributes[4], endpointsDetail);
    }

    public static String encodeAsString(ClusterMember[] clusterMembers) {
        StringBuilder builder = new StringBuilder();
        int length = clusterMembers.length;
        for (int i = 0; i < length; ++i) {
            ClusterMember member = clusterMembers[i];
            builder.append(member.id()).append(',').append(member.endpointsDetail());
            if (length - 1 == i) continue;
            builder.append('|');
        }
        return builder.toString();
    }

    public static void addMemberStatusPublications(ClusterMember[] members, ClusterMember exclude, ChannelUri channelUri, int streamId, Aeron aeron) {
        for (ClusterMember member : members) {
            if (member == exclude) continue;
            channelUri.put("endpoint", member.memberFacingEndpoint());
            String channel = channelUri.toString();
            member.publication(aeron.addExclusivePublication(channel, streamId));
        }
    }

    public static void closeMemberPublications(ClusterMember[] clusterMembers) {
        for (ClusterMember member : clusterMembers) {
            CloseHelper.close(member.publication);
        }
    }

    public static void addMemberStatusPublication(ClusterMember member, ChannelUri channelUri, int streamId, Aeron aeron) {
        channelUri.put("endpoint", member.memberFacingEndpoint());
        String channel = channelUri.toString();
        member.publication(aeron.addExclusivePublication(channel, streamId));
    }

    public static void addClusterMemberIds(ClusterMember[] clusterMembers, Int2ObjectHashMap<ClusterMember> clusterMemberByIdMap) {
        for (ClusterMember member : clusterMembers) {
            clusterMemberByIdMap.put(member.id(), member);
        }
    }

    public static boolean hasActiveQuorum(ClusterMember[] clusterMembers, long nowMs, long timeoutMs) {
        int threshold = ClusterMember.quorumThreshold(clusterMembers.length);
        for (ClusterMember member : clusterMembers) {
            if (!member.isLeader() && nowMs > member.timeOfLastAppendPositionMs() + timeoutMs || --threshold > 0) continue;
            return true;
        }
        return false;
    }

    public static int quorumThreshold(int memberCount) {
        return memberCount / 2 + 1;
    }

    public static long quorumPosition(ClusterMember[] members, long[] rankedPositions) {
        int length = rankedPositions.length;
        for (int i = 0; i < length; ++i) {
            rankedPositions[i] = 0L;
        }
        for (ClusterMember member : members) {
            long newPosition = member.logPosition;
            for (int i = 0; i < length; ++i) {
                long rankedPosition = rankedPositions[i];
                if (newPosition <= rankedPosition) continue;
                rankedPositions[i] = newPosition;
                newPosition = rankedPosition;
            }
        }
        return rankedPositions[length - 1];
    }

    public static void resetLogPositions(ClusterMember[] clusterMembers, long logPosition) {
        for (ClusterMember member : clusterMembers) {
            member.logPosition(logPosition);
        }
    }

    public static boolean haveVotersReachedPosition(ClusterMember[] clusterMembers, long position, long leadershipTermId) {
        for (ClusterMember member : clusterMembers) {
            if (member.vote == null || member.logPosition >= position && member.leadershipTermId == leadershipTermId) continue;
            return false;
        }
        return true;
    }

    public static void reset(ClusterMember[] members) {
        for (ClusterMember member : members) {
            member.reset();
        }
    }

    public static void becomeCandidate(ClusterMember[] members, long candidateTermId, int candidateMemberId) {
        for (ClusterMember member : members) {
            if (member.id == candidateMemberId) {
                member.vote(Boolean.TRUE).candidateTermId(candidateTermId).isBallotSent(true);
                continue;
            }
            member.vote(null).candidateTermId(-1L).isBallotSent(false);
        }
    }

    public static boolean hasWonVoteOnFullCount(ClusterMember[] members, long candidateTermId) {
        int votes = 0;
        for (ClusterMember member : members) {
            if (null == member.vote || member.candidateTermId != candidateTermId) {
                return false;
            }
            votes += member.vote != false ? 1 : 0;
        }
        return votes >= ClusterMember.quorumThreshold(members.length);
    }

    public static boolean hasMajorityVoteWithCanvassMembers(ClusterMember[] members, long candidateTermId) {
        int votes = 0;
        for (ClusterMember member : members) {
            if (-1L != member.logPosition && null == member.vote) {
                return false;
            }
            if (!Boolean.TRUE.equals(member.vote) || member.candidateTermId != candidateTermId) continue;
            ++votes;
        }
        return votes >= ClusterMember.quorumThreshold(members.length);
    }

    public static boolean hasMajorityVote(ClusterMember[] clusterMembers, long candidateTermId) {
        int votes = 0;
        for (ClusterMember member : clusterMembers) {
            if (!Boolean.TRUE.equals(member.vote) || member.candidateTermId != candidateTermId) continue;
            ++votes;
        }
        return votes >= ClusterMember.quorumThreshold(clusterMembers.length);
    }

    public static void checkArchiveEndpoint(ClusterMember member, ChannelUri archiveControlRequestUri) {
        if (!"udp".equals(archiveControlRequestUri.media())) {
            throw new ClusterException("archive control request channel must be udp");
        }
        String archiveEndpoint = archiveControlRequestUri.get("endpoint");
        if (archiveEndpoint != null && !archiveEndpoint.equals(member.archiveEndpoint)) {
            throw new ClusterException("archive control request endpoint must match cluster member configuration: " + archiveEndpoint + " != " + member.archiveEndpoint);
        }
    }

    public static void validateMemberEndpoints(ClusterMember member, String memberEndpoints) {
        ClusterMember endpointMember = ClusterMember.parseEndpoints(-1, memberEndpoints);
        if (!ClusterMember.areSameEndpoints(member, endpointMember)) {
            throw new ClusterException("clusterMembers and memberEndpoints differ on endpoints: " + member.endpointsDetail() + " != " + memberEndpoints);
        }
    }

    public static boolean areSameEndpoints(ClusterMember lhs, ClusterMember rhs) {
        return lhs.clientFacingEndpoint().equals(rhs.clientFacingEndpoint()) && lhs.memberFacingEndpoint().equals(rhs.memberFacingEndpoint()) && lhs.logEndpoint().equals(rhs.logEndpoint()) && lhs.transferEndpoint().equals(rhs.transferEndpoint()) && lhs.archiveEndpoint().equals(rhs.archiveEndpoint());
    }

    public static boolean isUnanimousCandidate(ClusterMember[] clusterMembers, ClusterMember candidate) {
        for (ClusterMember member : clusterMembers) {
            if (-1L != member.logPosition && ClusterMember.compareLog(candidate, member) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isQuorumCandidate(ClusterMember[] clusterMembers, ClusterMember candidate) {
        int possibleVotes = 0;
        for (ClusterMember member : clusterMembers) {
            if (-1L == member.logPosition || ClusterMember.compareLog(candidate, member) < 0) continue;
            ++possibleVotes;
        }
        return possibleVotes >= ClusterMember.quorumThreshold(clusterMembers.length);
    }

    public static int compareLog(long lhsLogLeadershipTermId, long lhsLogPosition, long rhsLogLeadershipTermId, long rhsLogPosition) {
        if (lhsLogLeadershipTermId > rhsLogLeadershipTermId) {
            return 1;
        }
        if (lhsLogLeadershipTermId < rhsLogLeadershipTermId) {
            return -1;
        }
        if (lhsLogPosition > rhsLogPosition) {
            return 1;
        }
        if (lhsLogPosition < rhsLogPosition) {
            return -1;
        }
        return 0;
    }

    public static int compareLog(ClusterMember lhs, ClusterMember rhs) {
        return ClusterMember.compareLog(lhs.leadershipTermId, lhs.logPosition, rhs.leadershipTermId, rhs.logPosition);
    }

    public static boolean isNotDuplicateEndpoints(ClusterMember[] members, String memberEndpoints) {
        for (ClusterMember member : members) {
            if (!member.endpointsDetail().equals(memberEndpoints)) continue;
            return false;
        }
        return true;
    }

    public static int findMemberIndex(ClusterMember[] clusterMembers, int memberId) {
        int length = clusterMembers.length;
        int index = -1;
        for (int i = 0; i < length; ++i) {
            if (clusterMembers[i].id() != memberId) continue;
            index = i;
        }
        return index;
    }

    public static ClusterMember findMember(ClusterMember[] clusterMembers, int memberId) {
        for (ClusterMember member : clusterMembers) {
            if (member.id() != memberId) continue;
            return member;
        }
        return null;
    }

    public static ClusterMember[] addMember(ClusterMember[] oldMembers, ClusterMember newMember) {
        return ArrayUtil.add(oldMembers, newMember);
    }

    public static ClusterMember[] removeMember(ClusterMember[] oldMembers, int memberId) {
        return ArrayUtil.remove(oldMembers, ClusterMember.findMemberIndex(oldMembers, memberId));
    }

    public static int highMemberId(ClusterMember[] clusterMembers) {
        int highId = -1;
        for (ClusterMember member : clusterMembers) {
            highId = Math.max(highId, member.id());
        }
        return highId;
    }

    public String toString() {
        return "ClusterMember{isBallotSent=" + this.isBallotSent + ", isLeader=" + this.isLeader + ", hasRequestedJoin=" + this.hasRequestedJoin + ", id=" + this.id + ", leadershipTermId=" + this.leadershipTermId + ", logPosition=" + this.logPosition + ", candidateTermId=" + this.candidateTermId + ", catchupReplaySessionId=" + this.catchupReplaySessionId + ", correlationId=" + this.changeCorrelationId + ", removalPosition=" + this.removalPosition + ", timeOfLastAppendPositionMs=" + this.timeOfLastAppendPositionMs + ", clientFacingEndpoint='" + this.clientFacingEndpoint + '\'' + ", memberFacingEndpoint='" + this.memberFacingEndpoint + '\'' + ", logEndpoint='" + this.logEndpoint + '\'' + ", transferEndpoint='" + this.transferEndpoint + '\'' + ", archiveEndpoint='" + this.archiveEndpoint + '\'' + ", endpointsDetail='" + this.endpointsDetail + '\'' + ", publication=" + this.publication + ", vote=" + this.vote + '}';
    }
}

