/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.cluster.client.ClusterException;
import io.aeron.exceptions.AeronException;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.nio.charset.StandardCharsets;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;

public class ClusterControl {
    public static final int CONTROL_TOGGLE_TYPE_ID = 202;

    public static CountersReader mapCounters() {
        return ClusterControl.mapCounters(CommonContext.newDefaultCncFile());
    }

    public static CountersReader mapCounters(String filename) {
        return ClusterControl.mapCounters(new File(filename));
    }

    public static CountersReader mapCounters(File cncFile) {
        MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile(cncFile, "cnc");
        UnsafeBuffer cncMetaData = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        int cncVersion = cncMetaData.getInt(CncFileDescriptor.cncVersionOffset(0));
        if (15 != cncVersion) {
            throw new AeronException("Aeron CnC version does not match: version=" + cncVersion + " required=" + 15);
        }
        return new CountersReader(CncFileDescriptor.createCountersMetaDataBuffer(cncByteBuffer, cncMetaData), CncFileDescriptor.createCountersValuesBuffer(cncByteBuffer, cncMetaData), StandardCharsets.US_ASCII);
    }

    public static AtomicCounter findControlToggle(CountersReader counters) {
        AtomicBuffer buffer = counters.metaDataBuffer();
        int size = counters.maxCounterId();
        for (int i = 0; i < size; ++i) {
            int recordOffset = CountersReader.metaDataOffset(i);
            if (counters.getCounterState(i) != 1 || buffer.getInt(recordOffset + 4) != 202) continue;
            return new AtomicCounter(counters.valuesBuffer(), i, null);
        }
        return null;
    }

    public static void main(String[] args) {
        ClusterControl.checkUsage(args);
        ToggleState toggleState = ToggleState.valueOf(args[0].toUpperCase());
        File cncFile = CommonContext.newDefaultCncFile();
        System.out.println("Command `n Control file " + cncFile);
        CountersReader countersReader = ClusterControl.mapCounters(cncFile);
        AtomicCounter controlToggle = ClusterControl.findControlToggle(countersReader);
        if (null == controlToggle) {
            System.out.println("Failed to find control toggle");
            System.exit(0);
        }
        if (toggleState.toggle(controlToggle)) {
            System.out.println((Object)((Object)toggleState) + " toggled successfully");
        } else {
            System.out.println((Object)((Object)toggleState) + " did NOT toggle");
        }
    }

    private static void checkUsage(String[] args) {
        if (1 != args.length) {
            System.out.format("Usage: [-Daeron.dir=<directory containing CnC file>] " + ClusterControl.class.getSimpleName() + " <action>%n", new Object[0]);
            System.exit(0);
        }
    }

    public static enum ToggleState {
        NEUTRAL(0),
        SUSPEND(1),
        RESUME(2),
        SNAPSHOT(3),
        SHUTDOWN(4),
        ABORT(5);

        private final int code;
        private static final ToggleState[] STATES;

        private ToggleState(int code) {
            this.code = code;
        }

        public final int code() {
            return this.code;
        }

        public final boolean toggle(AtomicCounter controlToggle) {
            return controlToggle.compareAndSet(NEUTRAL.code(), this.code());
        }

        public static void reset(AtomicCounter controlToggle) {
            controlToggle.set(NEUTRAL.code());
        }

        public static ToggleState get(AtomicCounter controlToggle) {
            long toggleValue = controlToggle.get();
            if (toggleValue < 0L || toggleValue > (long)(STATES.length - 1)) {
                throw new ClusterException("invalid toggle value: " + toggleValue);
            }
            return STATES[(int)toggleValue];
        }

        static {
            ToggleState[] toggleStates = ToggleState.values();
            STATES = new ToggleState[toggleStates.length];
            ToggleState[] toggleStateArray = toggleStates;
            int n = toggleStateArray.length;
            for (int i = 0; i < n; ++i) {
                ToggleState toggleState;
                ToggleState.STATES[toggleState.code()] = toggleState = toggleStateArray[i];
            }
        }
    }
}

