/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs.mark;

import io.aeron.archive.codecs.mark.MetaAttribute;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class MarkFileHeaderDecoder {
    public static final int BLOCK_LENGTH = 128;
    public static final int TEMPLATE_ID = 200;
    public static final int SCHEMA_ID = 100;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final MarkFileHeaderDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 128;
    }

    public int sbeTemplateId() {
        return 200;
    }

    public int sbeSchemaId() {
        return 100;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public MarkFileHeaderDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int versionId() {
        return 1;
    }

    public static int versionSinceVersion() {
        return 0;
    }

    public static int versionEncodingOffset() {
        return 0;
    }

    public static int versionEncodingLength() {
        return 4;
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int versionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int versionMinValue() {
        return -2147483647;
    }

    public static int versionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int version() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int activityTimestampId() {
        return 2;
    }

    public static int activityTimestampSinceVersion() {
        return 0;
    }

    public static int activityTimestampEncodingOffset() {
        return 8;
    }

    public static int activityTimestampEncodingLength() {
        return 8;
    }

    public static String activityTimestampMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long activityTimestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long activityTimestampMinValue() {
        return -9223372036854775807L;
    }

    public static long activityTimestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public long activityTimestamp() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int startTimestampId() {
        return 3;
    }

    public static int startTimestampSinceVersion() {
        return 0;
    }

    public static int startTimestampEncodingOffset() {
        return 16;
    }

    public static int startTimestampEncodingLength() {
        return 8;
    }

    public static String startTimestampMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long startTimestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long startTimestampMinValue() {
        return -9223372036854775807L;
    }

    public static long startTimestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public long startTimestamp() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int pidId() {
        return 4;
    }

    public static int pidSinceVersion() {
        return 0;
    }

    public static int pidEncodingOffset() {
        return 24;
    }

    public static int pidEncodingLength() {
        return 8;
    }

    public static String pidMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long pidNullValue() {
        return Long.MIN_VALUE;
    }

    public static long pidMinValue() {
        return -9223372036854775807L;
    }

    public static long pidMaxValue() {
        return Long.MAX_VALUE;
    }

    public long pid() {
        return this.buffer.getLong(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static int controlStreamIdId() {
        return 5;
    }

    public static int controlStreamIdSinceVersion() {
        return 0;
    }

    public static int controlStreamIdEncodingOffset() {
        return 32;
    }

    public static int controlStreamIdEncodingLength() {
        return 4;
    }

    public static String controlStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int controlStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int controlStreamIdMinValue() {
        return -2147483647;
    }

    public static int controlStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int controlStreamId() {
        return this.buffer.getInt(this.offset + 32, ByteOrder.LITTLE_ENDIAN);
    }

    public static int localControlStreamIdId() {
        return 6;
    }

    public static int localControlStreamIdSinceVersion() {
        return 0;
    }

    public static int localControlStreamIdEncodingOffset() {
        return 36;
    }

    public static int localControlStreamIdEncodingLength() {
        return 4;
    }

    public static String localControlStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int localControlStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int localControlStreamIdMinValue() {
        return -2147483647;
    }

    public static int localControlStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int localControlStreamId() {
        return this.buffer.getInt(this.offset + 36, ByteOrder.LITTLE_ENDIAN);
    }

    public static int eventsStreamIdId() {
        return 7;
    }

    public static int eventsStreamIdSinceVersion() {
        return 0;
    }

    public static int eventsStreamIdEncodingOffset() {
        return 40;
    }

    public static int eventsStreamIdEncodingLength() {
        return 4;
    }

    public static String eventsStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int eventsStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int eventsStreamIdMinValue() {
        return -2147483647;
    }

    public static int eventsStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int eventsStreamId() {
        return this.buffer.getInt(this.offset + 40, ByteOrder.LITTLE_ENDIAN);
    }

    public static int controlChannelId() {
        return 8;
    }

    public static int controlChannelSinceVersion() {
        return 0;
    }

    public static String controlChannelCharacterEncoding() {
        return "US-ASCII";
    }

    public static String controlChannelMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int controlChannelHeaderLength() {
        return 4;
    }

    public int controlChannelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getControlChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getControlChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapControlChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String controlChannel() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public void getControlChannel(Appendable value) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        for (int i = 0; i < dataLength; ++i) {
            try {
                int c = this.buffer.getByte(dataOffset + i) & 0xFF;
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static int localControlChannelId() {
        return 9;
    }

    public static int localControlChannelSinceVersion() {
        return 0;
    }

    public static String localControlChannelCharacterEncoding() {
        return "US-ASCII";
    }

    public static String localControlChannelMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int localControlChannelHeaderLength() {
        return 4;
    }

    public int localControlChannelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getLocalControlChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getLocalControlChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapLocalControlChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String localControlChannel() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public void getLocalControlChannel(Appendable value) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        for (int i = 0; i < dataLength; ++i) {
            try {
                int c = this.buffer.getByte(dataOffset + i) & 0xFF;
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static int eventsChannelId() {
        return 10;
    }

    public static int eventsChannelSinceVersion() {
        return 0;
    }

    public static String eventsChannelCharacterEncoding() {
        return "US-ASCII";
    }

    public static String eventsChannelMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int eventsChannelHeaderLength() {
        return 4;
    }

    public int eventsChannelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getEventsChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getEventsChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapEventsChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String eventsChannel() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public void getEventsChannel(Appendable value) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        for (int i = 0; i < dataLength; ++i) {
            try {
                int c = this.buffer.getByte(dataOffset + i) & 0xFF;
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static int aeronDirectoryId() {
        return 11;
    }

    public static int aeronDirectorySinceVersion() {
        return 0;
    }

    public static String aeronDirectoryCharacterEncoding() {
        return "US-ASCII";
    }

    public static String aeronDirectoryMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int aeronDirectoryHeaderLength() {
        return 4;
    }

    public int aeronDirectoryLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getAeronDirectory(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getAeronDirectory(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapAeronDirectory(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String aeronDirectory() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public void getAeronDirectory(Appendable value) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        for (int i = 0; i < dataLength; ++i) {
            try {
                int c = this.buffer.getByte(dataOffset + i) & 0xFF;
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[MarkFileHeader](sbeTemplateId=");
        builder.append(200);
        builder.append("|sbeSchemaId=");
        builder.append(100);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 128) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(128);
        builder.append("):");
        builder.append("version=");
        builder.append(this.version());
        builder.append('|');
        builder.append("activityTimestamp=");
        builder.append(this.activityTimestamp());
        builder.append('|');
        builder.append("startTimestamp=");
        builder.append(this.startTimestamp());
        builder.append('|');
        builder.append("pid=");
        builder.append(this.pid());
        builder.append('|');
        builder.append("controlStreamId=");
        builder.append(this.controlStreamId());
        builder.append('|');
        builder.append("localControlStreamId=");
        builder.append(this.localControlStreamId());
        builder.append('|');
        builder.append("eventsStreamId=");
        builder.append(this.eventsStreamId());
        builder.append('|');
        builder.append("controlChannel=");
        builder.append('\'' + this.controlChannel() + '\'');
        builder.append('|');
        builder.append("localControlChannel=");
        builder.append('\'' + this.localControlChannel() + '\'');
        builder.append('|');
        builder.append("eventsChannel=");
        builder.append('\'' + this.eventsChannel() + '\'');
        builder.append('|');
        builder.append("aeronDirectory=");
        builder.append('\'' + this.aeronDirectory() + '\'');
        this.limit(originalLimit);
        return builder;
    }
}

