/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public class StopReplayRequestDecoder {
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 7;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final StopReplayRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 24;
    }

    public int sbeTemplateId() {
        return 7;
    }

    public int sbeSchemaId() {
        return 101;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public StopReplayRequestDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int controlSessionIdId() {
        return 1;
    }

    public static int controlSessionIdSinceVersion() {
        return 0;
    }

    public static int controlSessionIdEncodingOffset() {
        return 0;
    }

    public static int controlSessionIdEncodingLength() {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long controlSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long controlSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long controlSessionId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int replaySessionIdId() {
        return 3;
    }

    public static int replaySessionIdSinceVersion() {
        return 0;
    }

    public static int replaySessionIdEncodingOffset() {
        return 16;
    }

    public static int replaySessionIdEncodingLength() {
        return 8;
    }

    public static String replaySessionIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long replaySessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long replaySessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long replaySessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long replaySessionId() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[StopReplayRequest](sbeTemplateId=");
        builder.append(7);
        builder.append("|sbeSchemaId=");
        builder.append(101);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 24) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(24);
        builder.append("):");
        builder.append("controlSessionId=");
        builder.append(this.controlSessionId());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("replaySessionId=");
        builder.append(this.replaySessionId());
        this.limit(originalLimit);
        return builder;
    }
}

