/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.ControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.ControlResponseDecoder;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

public class ControlResponsePoller
implements ControlledFragmentHandler {
    private static final int FRAGMENT_LIMIT = 10;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ControlResponseDecoder controlResponseDecoder = new ControlResponseDecoder();
    private final Subscription subscription;
    private final ControlledFragmentAssembler fragmentAssembler = new ControlledFragmentAssembler(this);
    private long controlSessionId = -1L;
    private long correlationId = -1L;
    private long relevantId = -1L;
    private int templateId = -1;
    private ControlResponseCode code;
    private String errorMessage;
    private boolean pollComplete = false;

    public ControlResponsePoller(Subscription subscription) {
        this.subscription = subscription;
    }

    public Subscription subscription() {
        return this.subscription;
    }

    public int poll() {
        this.controlSessionId = -1L;
        this.correlationId = -1L;
        this.relevantId = -1L;
        this.templateId = -1;
        this.pollComplete = false;
        return this.subscription.controlledPoll(this.fragmentAssembler, 10);
    }

    public long controlSessionId() {
        return this.controlSessionId;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public long relevantId() {
        return this.relevantId;
    }

    public boolean isPollComplete() {
        return this.pollComplete;
    }

    public int templateId() {
        return this.templateId;
    }

    public ControlResponseCode code() {
        return this.code;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.sbeSchemaId();
        if (schemaId != 101) {
            throw new ArchiveException("expected schemaId=101, actual=" + schemaId);
        }
        this.templateId = this.messageHeaderDecoder.templateId();
        if (this.templateId == 1) {
            this.controlResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            this.controlSessionId = this.controlResponseDecoder.controlSessionId();
            this.correlationId = this.controlResponseDecoder.correlationId();
            this.relevantId = this.controlResponseDecoder.relevantId();
            this.code = this.controlResponseDecoder.code();
            this.errorMessage = ControlResponseCode.ERROR == this.code ? this.controlResponseDecoder.errorMessage() : "";
            this.pollComplete = true;
        }
        return ControlledFragmentHandler.Action.BREAK;
    }
}

