/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.Publication;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.CloseSessionRequestEncoder;
import io.aeron.archive.codecs.ConnectRequestEncoder;
import io.aeron.archive.codecs.ExtendRecordingRequestEncoder;
import io.aeron.archive.codecs.FindLastMatchingRecordingRequestEncoder;
import io.aeron.archive.codecs.ListRecordingRequestEncoder;
import io.aeron.archive.codecs.ListRecordingsForUriRequestEncoder;
import io.aeron.archive.codecs.ListRecordingsRequestEncoder;
import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.RecordingPositionRequestEncoder;
import io.aeron.archive.codecs.ReplayRequestEncoder;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.archive.codecs.StartRecordingRequestEncoder;
import io.aeron.archive.codecs.StopPositionRequestEncoder;
import io.aeron.archive.codecs.StopRecordingRequestEncoder;
import io.aeron.archive.codecs.StopRecordingSubscriptionRequestEncoder;
import io.aeron.archive.codecs.StopReplayRequestEncoder;
import io.aeron.archive.codecs.TruncateRecordingRequestEncoder;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.YieldingIdleStrategy;

public class ArchiveProxy {
    public static final int DEFAULT_RETRY_ATTEMPTS = 3;
    private final long connectTimeoutNs;
    private final int retryAttempts;
    private final IdleStrategy retryIdleStrategy;
    private final NanoClock nanoClock;
    private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(256);
    private final Publication publication;
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final ConnectRequestEncoder connectRequestEncoder = new ConnectRequestEncoder();
    private final CloseSessionRequestEncoder closeSessionRequestEncoder = new CloseSessionRequestEncoder();
    private final StartRecordingRequestEncoder startRecordingRequestEncoder = new StartRecordingRequestEncoder();
    private final ReplayRequestEncoder replayRequestEncoder = new ReplayRequestEncoder();
    private final StopReplayRequestEncoder stopReplayRequestEncoder = new StopReplayRequestEncoder();
    private final StopRecordingRequestEncoder stopRecordingRequestEncoder = new StopRecordingRequestEncoder();
    private final StopRecordingSubscriptionRequestEncoder stopRecordingSubscriptionRequestEncoder = new StopRecordingSubscriptionRequestEncoder();
    private final ListRecordingsRequestEncoder listRecordingsRequestEncoder = new ListRecordingsRequestEncoder();
    private final ListRecordingsForUriRequestEncoder listRecordingsForUriRequestEncoder = new ListRecordingsForUriRequestEncoder();
    private final ListRecordingRequestEncoder listRecordingRequestEncoder = new ListRecordingRequestEncoder();
    private final ExtendRecordingRequestEncoder extendRecordingRequestEncoder = new ExtendRecordingRequestEncoder();
    private final RecordingPositionRequestEncoder recordingPositionRequestEncoder = new RecordingPositionRequestEncoder();
    private final TruncateRecordingRequestEncoder truncateRecordingRequestEncoder = new TruncateRecordingRequestEncoder();
    private final StopPositionRequestEncoder stopPositionRequestEncoder = new StopPositionRequestEncoder();
    private final FindLastMatchingRecordingRequestEncoder findLastMatchingRecordingRequestEncoder = new FindLastMatchingRecordingRequestEncoder();

    public ArchiveProxy(Publication publication) {
        this(publication, new YieldingIdleStrategy(), new SystemNanoClock(), AeronArchive.Configuration.MESSAGE_TIMEOUT_DEFAULT_NS, 3);
    }

    public ArchiveProxy(Publication publication, IdleStrategy retryIdleStrategy, NanoClock nanoClock, long connectTimeoutNs, int retryAttempts) {
        this.publication = publication;
        this.retryIdleStrategy = retryIdleStrategy;
        this.nanoClock = nanoClock;
        this.connectTimeoutNs = connectTimeoutNs;
        this.retryAttempts = retryAttempts;
    }

    public Publication publication() {
        return this.publication;
    }

    public boolean connect(String responseChannel, int responseStreamId, long correlationId) {
        this.connectRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).correlationId(correlationId).responseStreamId(responseStreamId).responseChannel(responseChannel);
        return this.offerWithTimeout(this.connectRequestEncoder.encodedLength(), null);
    }

    public boolean tryConnect(String responseChannel, int responseStreamId, long correlationId) {
        this.connectRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).correlationId(correlationId).responseStreamId(responseStreamId).responseChannel(responseChannel);
        int length = 8 + this.connectRequestEncoder.encodedLength();
        return this.publication.offer(this.buffer, 0, length) > 0L;
    }

    public boolean connect(String responseChannel, int responseStreamId, long correlationId, AgentInvoker aeronClientInvoker) {
        this.connectRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).correlationId(correlationId).responseStreamId(responseStreamId).responseChannel(responseChannel);
        return this.offerWithTimeout(this.connectRequestEncoder.encodedLength(), aeronClientInvoker);
    }

    public boolean closeSession(long controlSessionId) {
        this.closeSessionRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId);
        return this.offer(this.closeSessionRequestEncoder.encodedLength());
    }

    public boolean startRecording(String channel, int streamId, SourceLocation sourceLocation, long correlationId, long controlSessionId) {
        this.startRecordingRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).streamId(streamId).sourceLocation(sourceLocation).channel(channel);
        return this.offer(this.startRecordingRequestEncoder.encodedLength());
    }

    public boolean stopRecording(String channel, int streamId, long correlationId, long controlSessionId) {
        this.stopRecordingRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).streamId(streamId).channel(channel);
        return this.offer(this.stopRecordingRequestEncoder.encodedLength());
    }

    public boolean stopRecording(long subscriptionId, long correlationId, long controlSessionId) {
        this.stopRecordingSubscriptionRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).subscriptionId(subscriptionId);
        return this.offer(this.stopRecordingSubscriptionRequestEncoder.encodedLength());
    }

    public boolean replay(long recordingId, long position, long length, String replayChannel, int replayStreamId, long correlationId, long controlSessionId) {
        this.replayRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId).position(position).length(length).replayStreamId(replayStreamId).replayChannel(replayChannel);
        return this.offer(this.replayRequestEncoder.encodedLength());
    }

    public boolean stopReplay(long replaySessionId, long correlationId, long controlSessionId) {
        this.stopReplayRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).replaySessionId(replaySessionId);
        return this.offer(this.replayRequestEncoder.encodedLength());
    }

    public boolean listRecordings(long fromRecordingId, int recordCount, long correlationId, long controlSessionId) {
        this.listRecordingsRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).fromRecordingId(fromRecordingId).recordCount(recordCount);
        return this.offer(this.listRecordingsRequestEncoder.encodedLength());
    }

    public boolean listRecordingsForUri(long fromRecordingId, int recordCount, String channelFragment, int streamId, long correlationId, long controlSessionId) {
        this.listRecordingsForUriRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).fromRecordingId(fromRecordingId).recordCount(recordCount).streamId(streamId).channel(channelFragment);
        return this.offer(this.listRecordingsForUriRequestEncoder.encodedLength());
    }

    public boolean listRecording(long recordingId, long correlationId, long controlSessionId) {
        this.listRecordingRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId);
        return this.offer(this.listRecordingRequestEncoder.encodedLength());
    }

    public boolean extendRecording(String channel, int streamId, SourceLocation sourceLocation, long recordingId, long correlationId, long controlSessionId) {
        this.extendRecordingRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId).streamId(streamId).sourceLocation(sourceLocation).channel(channel);
        return this.offer(this.extendRecordingRequestEncoder.encodedLength());
    }

    public boolean getRecordingPosition(long recordingId, long correlationId, long controlSessionId) {
        this.recordingPositionRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId);
        return this.offer(this.recordingPositionRequestEncoder.encodedLength());
    }

    public boolean truncateRecording(long recordingId, long position, long correlationId, long controlSessionId) {
        this.truncateRecordingRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId).position(position);
        return this.offer(this.truncateRecordingRequestEncoder.encodedLength());
    }

    public boolean getStopPosition(long recordingId, long correlationId, long controlSessionId) {
        this.stopPositionRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId);
        return this.offer(this.stopPositionRequestEncoder.encodedLength());
    }

    public boolean findLastMatchingRecording(long minRecordingId, String channelFragment, int streamId, int sessionId, long correlationId, long controlSessionId) {
        this.findLastMatchingRecordingRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).minRecordingId(minRecordingId).sessionId(sessionId).streamId(streamId).channel(channelFragment);
        return this.offer(this.findLastMatchingRecordingRequestEncoder.encodedLength());
    }

    private boolean offer(int length) {
        this.retryIdleStrategy.reset();
        int attempts = this.retryAttempts;
        long result;
        while ((result = this.publication.offer(this.buffer, 0, 8 + length)) <= 0L) {
            if (result == -4L) {
                throw new ArchiveException("connection to the archive has been closed");
            }
            if (result == -1L) {
                throw new ArchiveException("connection to the archive is no longer available");
            }
            if (result == -5L) {
                throw new ArchiveException("offer failed due to max position being reached");
            }
            if (--attempts <= 0) {
                return false;
            }
            this.retryIdleStrategy.idle();
        }
        return true;
    }

    private boolean offerWithTimeout(int length, AgentInvoker aeronClientInvoker) {
        this.retryIdleStrategy.reset();
        long deadlineNs = this.nanoClock.nanoTime() + this.connectTimeoutNs;
        long result;
        while ((result = this.publication.offer(this.buffer, 0, 8 + length)) <= 0L) {
            if (result == -4L) {
                throw new ArchiveException("connection to the archive has been closed");
            }
            if (result == -5L) {
                throw new ArchiveException("offer failed due to max position being reached");
            }
            if (deadlineNs - this.nanoClock.nanoTime() < 0L) {
                return false;
            }
            if (null != aeronClientInvoker) {
                aeronClientInvoker.invoke();
            }
            this.retryIdleStrategy.idle();
        }
        return true;
    }
}

