/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.Aeron;
import io.aeron.AvailableImageHandler;
import io.aeron.ChannelUri;
import io.aeron.CommonContext;
import io.aeron.ConcurrentPublication;
import io.aeron.ExclusivePublication;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.UnavailableImageHandler;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.client.ArchiveProxy;
import io.aeron.archive.client.ControlResponsePoller;
import io.aeron.archive.client.RecordingDescriptorConsumer;
import io.aeron.archive.client.RecordingDescriptorPoller;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.exceptions.TimeoutException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;

public class AeronArchive
implements AutoCloseable {
    public static final long NULL_TIMESTAMP = -1L;
    public static final long NULL_POSITION = -1L;
    public static final long NULL_LENGTH = -1L;
    private static final int FRAGMENT_LIMIT = 10;
    private boolean isClosed = false;
    private final long controlSessionId;
    private final long messageTimeoutNs;
    private final Context context;
    private final Aeron aeron;
    private final ArchiveProxy archiveProxy;
    private final IdleStrategy idleStrategy;
    private final ControlResponsePoller controlResponsePoller;
    private final RecordingDescriptorPoller recordingDescriptorPoller;
    private final Lock lock;
    private final NanoClock nanoClock;
    private final AgentInvoker aeronClientInvoker;

    AeronArchive(Context ctx) {
        Subscription subscription = null;
        ExclusivePublication publication = null;
        try {
            ctx.conclude();
            this.context = ctx;
            this.aeron = ctx.aeron();
            this.aeronClientInvoker = this.aeron.conductorAgentInvoker();
            this.idleStrategy = ctx.idleStrategy();
            this.messageTimeoutNs = ctx.messageTimeoutNs();
            this.lock = ctx.lock();
            this.nanoClock = this.aeron.context().nanoClock();
            subscription = this.aeron.addSubscription(ctx.controlResponseChannel(), ctx.controlResponseStreamId());
            this.controlResponsePoller = new ControlResponsePoller(subscription);
            publication = this.aeron.addExclusivePublication(ctx.controlRequestChannel(), ctx.controlRequestStreamId());
            this.archiveProxy = new ArchiveProxy(publication, this.idleStrategy, this.nanoClock, this.messageTimeoutNs, 3);
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.connect(ctx.controlResponseChannel(), ctx.controlResponseStreamId(), correlationId, this.aeronClientInvoker)) {
                throw new ArchiveException("cannot connect to archive: " + ctx.controlRequestChannel());
            }
            this.controlSessionId = this.awaitSessionOpened(correlationId);
            this.recordingDescriptorPoller = new RecordingDescriptorPoller(subscription, ctx.errorHandler(), this.controlSessionId, 10);
        }
        catch (Exception ex) {
            if (!ctx.ownsAeronClient()) {
                CloseHelper.quietClose(subscription);
                CloseHelper.quietClose(publication);
            }
            ctx.close();
            throw ex;
        }
    }

    AeronArchive(Context ctx, ControlResponsePoller controlResponsePoller, ArchiveProxy archiveProxy, RecordingDescriptorPoller recordingDescriptorPoller, long controlSessionId) {
        this.context = ctx;
        this.aeron = ctx.aeron();
        this.aeronClientInvoker = this.aeron.conductorAgentInvoker();
        this.idleStrategy = ctx.idleStrategy();
        this.messageTimeoutNs = ctx.messageTimeoutNs();
        this.lock = ctx.lock();
        this.nanoClock = this.aeron.context().nanoClock();
        this.controlResponsePoller = controlResponsePoller;
        this.archiveProxy = archiveProxy;
        this.recordingDescriptorPoller = recordingDescriptorPoller;
        this.controlSessionId = controlSessionId;
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            if (!this.isClosed) {
                this.isClosed = true;
                this.archiveProxy.closeSession(this.controlSessionId);
                if (!this.context.ownsAeronClient()) {
                    CloseHelper.close(this.controlResponsePoller.subscription());
                    CloseHelper.close(this.archiveProxy.publication());
                }
                this.context.close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public static AeronArchive connect() {
        return new AeronArchive(new Context());
    }

    public static AeronArchive connect(Context context) {
        return new AeronArchive(context);
    }

    public static AsyncConnect asyncConnect() {
        return AeronArchive.asyncConnect(new Context());
    }

    public static AsyncConnect asyncConnect(Context ctx) {
        Subscription subscription = null;
        ExclusivePublication publication = null;
        try {
            ctx.conclude();
            Aeron aeron = ctx.aeron();
            long messageTimeoutNs = ctx.messageTimeoutNs();
            subscription = aeron.addSubscription(ctx.controlResponseChannel(), ctx.controlResponseStreamId());
            ControlResponsePoller controlResponsePoller = new ControlResponsePoller(subscription);
            publication = aeron.addExclusivePublication(ctx.controlRequestChannel(), ctx.controlRequestStreamId());
            ArchiveProxy archiveProxy = new ArchiveProxy(publication, ctx.idleStrategy(), aeron.context().nanoClock(), messageTimeoutNs, 3);
            return new AsyncConnect(ctx, controlResponsePoller, archiveProxy);
        }
        catch (Exception ex) {
            if (!ctx.ownsAeronClient()) {
                CloseHelper.quietClose(subscription);
                CloseHelper.quietClose(publication);
            }
            ctx.close();
            throw ex;
        }
    }

    public Context context() {
        return this.context;
    }

    public long controlSessionId() {
        return this.controlSessionId;
    }

    public ArchiveProxy archiveProxy() {
        return this.archiveProxy;
    }

    public ControlResponsePoller controlResponsePoller() {
        return this.controlResponsePoller;
    }

    public RecordingDescriptorPoller recordingDescriptorPoller() {
        return this.recordingDescriptorPoller;
    }

    public String pollForErrorResponse() {
        this.lock.lock();
        try {
            this.ensureOpen();
            if (this.controlResponsePoller.poll() != 0 && this.controlResponsePoller.isPollComplete() && this.controlResponsePoller.controlSessionId() == this.controlSessionId && this.controlResponsePoller.templateId() == 1 && this.controlResponsePoller.code() == ControlResponseCode.ERROR) {
                String string = this.controlResponsePoller.errorMessage();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void checkForErrorResponse() {
        block4: {
            this.lock.lock();
            try {
                this.ensureOpen();
                if (this.controlResponsePoller.poll() == 0 || !this.controlResponsePoller.isPollComplete() || this.controlResponsePoller.controlSessionId() != this.controlSessionId || this.controlResponsePoller.templateId() != 1 || this.controlResponsePoller.code() != ControlResponseCode.ERROR) break block4;
                ArchiveException ex = new ArchiveException(this.controlResponsePoller.errorMessage(), (int)this.controlResponsePoller.relevantId());
                if (null != this.context.errorHandler()) {
                    this.context.errorHandler().onError(ex);
                    break block4;
                }
                throw ex;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public Publication addRecordedPublication(String channel, int streamId) {
        ConcurrentPublication publication = null;
        this.lock.lock();
        try {
            this.ensureOpen();
            publication = this.aeron.addPublication(channel, streamId);
            if (!publication.isOriginal()) {
                throw new ArchiveException("publication already added for channel=" + channel + " streamId=" + streamId);
            }
            this.startRecording(ChannelUri.addSessionId(channel, publication.sessionId()), streamId, SourceLocation.LOCAL);
        }
        catch (RuntimeException ex) {
            CloseHelper.quietClose(publication);
            throw ex;
        }
        finally {
            this.lock.unlock();
        }
        return publication;
    }

    public ExclusivePublication addRecordedExclusivePublication(String channel, int streamId) {
        ExclusivePublication publication = null;
        this.lock.lock();
        try {
            this.ensureOpen();
            publication = this.aeron.addExclusivePublication(channel, streamId);
            this.startRecording(ChannelUri.addSessionId(channel, publication.sessionId()), streamId, SourceLocation.LOCAL);
        }
        catch (RuntimeException ex) {
            CloseHelper.quietClose(publication);
            throw ex;
        }
        finally {
            this.lock.unlock();
        }
        return publication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long startRecording(String channel, int streamId, SourceLocation sourceLocation) {
        this.lock.lock();
        try {
            this.ensureOpen();
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.startRecording(channel, streamId, sourceLocation, correlationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send start recording request");
            }
            long l = this.pollForResponse(correlationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long extendRecording(long recordingId, String channel, int streamId, SourceLocation sourceLocation) {
        this.lock.lock();
        try {
            this.ensureOpen();
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.extendRecording(channel, streamId, sourceLocation, recordingId, correlationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send extend recording request");
            }
            long l = this.pollForResponse(correlationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording(String channel, int streamId) {
        this.lock.lock();
        try {
            this.ensureOpen();
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.stopRecording(channel, streamId, correlationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send stop recording request");
            }
            this.pollForResponse(correlationId);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stopRecording(Publication publication) {
        String recordingChannel = ChannelUri.addSessionId(publication.channel(), publication.sessionId());
        this.stopRecording(recordingChannel, publication.streamId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording(long subscriptionId) {
        this.lock.lock();
        try {
            this.ensureOpen();
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.stopRecording(subscriptionId, correlationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send stop recording request");
            }
            this.pollForResponse(correlationId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long startReplay(long recordingId, long position, long length, String replayChannel, int replayStreamId) {
        this.lock.lock();
        try {
            this.ensureOpen();
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.replay(recordingId, position, length, replayChannel, replayStreamId, correlationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send replay request");
            }
            long l = this.pollForResponse(correlationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReplay(long replaySessionId) {
        this.lock.lock();
        try {
            this.ensureOpen();
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.stopReplay(replaySessionId, correlationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send stop recording request");
            }
            this.pollForResponse(correlationId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription replay(long recordingId, long position, long length, String replayChannel, int replayStreamId) {
        this.lock.lock();
        try {
            this.ensureOpen();
            ChannelUri replayChannelUri = ChannelUri.parse(replayChannel);
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.replay(recordingId, position, length, replayChannel, replayStreamId, correlationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send replay request");
            }
            int replaySessionId = (int)this.pollForResponse(correlationId);
            replayChannelUri.put("session-id", Integer.toString(replaySessionId));
            Subscription subscription = this.aeron.addSubscription(replayChannelUri.toString(), replayStreamId);
            return subscription;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription replay(long recordingId, long position, long length, String replayChannel, int replayStreamId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        this.lock.lock();
        try {
            this.ensureOpen();
            ChannelUri replayChannelUri = ChannelUri.parse(replayChannel);
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.replay(recordingId, position, length, replayChannel, replayStreamId, correlationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send replay request");
            }
            int replaySessionId = (int)this.pollForResponse(correlationId);
            replayChannelUri.put("session-id", Integer.toString(replaySessionId));
            Subscription subscription = this.aeron.addSubscription(replayChannelUri.toString(), replayStreamId, availableImageHandler, unavailableImageHandler);
            return subscription;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int listRecordings(long fromRecordingId, int recordCount, RecordingDescriptorConsumer consumer) {
        this.lock.lock();
        try {
            this.ensureOpen();
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.listRecordings(fromRecordingId, recordCount, correlationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send list recordings request");
            }
            int n = this.pollForDescriptors(correlationId, recordCount, consumer);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int listRecordingsForUri(long fromRecordingId, int recordCount, String channelFragment, int streamId, RecordingDescriptorConsumer consumer) {
        this.lock.lock();
        try {
            this.ensureOpen();
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.listRecordingsForUri(fromRecordingId, recordCount, channelFragment, streamId, correlationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send list recordings request");
            }
            int n = this.pollForDescriptors(correlationId, recordCount, consumer);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int listRecording(long recordingId, RecordingDescriptorConsumer consumer) {
        this.lock.lock();
        try {
            this.ensureOpen();
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.listRecording(recordingId, correlationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send list recording request");
            }
            int n = this.pollForDescriptors(correlationId, 1, consumer);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRecordingPosition(long recordingId) {
        this.lock.lock();
        try {
            this.ensureOpen();
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.getRecordingPosition(recordingId, correlationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send get recording position request");
            }
            long l = this.pollForResponse(correlationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStopPosition(long recordingId) {
        this.lock.lock();
        try {
            this.ensureOpen();
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.getStopPosition(recordingId, correlationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send get stop position request");
            }
            long l = this.pollForResponse(correlationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long findLastMatchingRecording(long minRecordingId, String channelFragment, int streamId, int sessionId) {
        this.lock.lock();
        try {
            this.ensureOpen();
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.findLastMatchingRecording(minRecordingId, channelFragment, streamId, sessionId, correlationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send find last matching request");
            }
            long l = this.pollForResponse(correlationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateRecording(long recordingId, long position) {
        this.lock.lock();
        try {
            this.ensureOpen();
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.truncateRecording(recordingId, position, correlationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send truncate recording request");
            }
            this.pollForResponse(correlationId);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkDeadline(long deadlineNs, String errorMessage, long correlationId) {
        if (Thread.interrupted()) {
            LangUtil.rethrowUnchecked(new InterruptedException());
        }
        if (deadlineNs - this.nanoClock.nanoTime() < 0L) {
            throw new TimeoutException(errorMessage + " - correlationId=" + correlationId);
        }
    }

    private long awaitSessionOpened(long correlationId) {
        long deadlineNs = this.nanoClock.nanoTime() + this.messageTimeoutNs;
        ControlResponsePoller poller = this.controlResponsePoller;
        this.awaitConnection(deadlineNs, poller, correlationId);
        while (true) {
            this.pollNextResponse(correlationId, deadlineNs, poller);
            if (poller.correlationId() == correlationId && poller.templateId() == 1) break;
            this.invokeAeronClient();
        }
        ControlResponseCode code = poller.code();
        if (code != ControlResponseCode.OK) {
            if (code == ControlResponseCode.ERROR) {
                throw new ArchiveException("error: " + poller.errorMessage(), (int)poller.relevantId());
            }
            throw new ArchiveException("unexpected response: code=" + (Object)((Object)code));
        }
        return poller.controlSessionId();
    }

    private void awaitConnection(long deadlineNs, ControlResponsePoller poller, long correlationId) {
        this.idleStrategy.reset();
        while (!poller.subscription().isConnected()) {
            this.checkDeadline(deadlineNs, "failed to establish response connection", correlationId);
            this.idleStrategy.idle();
            this.invokeAeronClient();
        }
    }

    private long pollForResponse(long correlationId) {
        ControlResponseCode code;
        long deadlineNs = this.nanoClock.nanoTime() + this.messageTimeoutNs;
        ControlResponsePoller poller = this.controlResponsePoller;
        while (true) {
            this.pollNextResponse(correlationId, deadlineNs, poller);
            if (poller.controlSessionId() != this.controlSessionId || poller.templateId() != 1) {
                this.invokeAeronClient();
                continue;
            }
            code = poller.code();
            if (ControlResponseCode.ERROR == code) {
                ArchiveException ex = new ArchiveException("response for correlationId=" + correlationId + ", error: " + poller.errorMessage(), (int)poller.relevantId());
                if (poller.correlationId() == correlationId) {
                    throw ex;
                }
                if (this.context.errorHandler() == null) continue;
                this.context.errorHandler().onError(ex);
                continue;
            }
            if (poller.correlationId() == correlationId) break;
        }
        if (ControlResponseCode.OK != code) {
            throw new ArchiveException("unexpected response code: " + (Object)((Object)code));
        }
        return poller.relevantId();
    }

    private void pollNextResponse(long correlationId, long deadlineNs, ControlResponsePoller poller) {
        this.idleStrategy.reset();
        while (true) {
            int fragments = poller.poll();
            if (poller.isPollComplete()) break;
            if (fragments > 0) continue;
            if (!poller.subscription().isConnected()) {
                throw new ArchiveException("subscription to archive is not connected");
            }
            this.checkDeadline(deadlineNs, "awaiting response", correlationId);
            this.idleStrategy.idle();
            this.invokeAeronClient();
        }
    }

    private int pollForDescriptors(long correlationId, int recordCount, RecordingDescriptorConsumer consumer) {
        int existingRemainCount = recordCount;
        long deadlineNs = this.nanoClock.nanoTime() + this.messageTimeoutNs;
        RecordingDescriptorPoller poller = this.recordingDescriptorPoller;
        poller.reset(correlationId, recordCount, consumer);
        this.idleStrategy.reset();
        while (true) {
            int fragments = poller.poll();
            int remainingRecordCount = poller.remainingRecordCount();
            if (poller.isDispatchComplete()) {
                return recordCount - remainingRecordCount;
            }
            if (remainingRecordCount != existingRemainCount) {
                existingRemainCount = remainingRecordCount;
                deadlineNs = this.nanoClock.nanoTime() + this.messageTimeoutNs;
            }
            this.invokeAeronClient();
            if (fragments > 0) continue;
            if (!poller.subscription().isConnected()) {
                throw new ArchiveException("subscription to archive is not connected");
            }
            this.checkDeadline(deadlineNs, "awaiting recording descriptors", correlationId);
            this.idleStrategy.idle();
        }
    }

    private void invokeAeronClient() {
        if (null != this.aeronClientInvoker) {
            this.aeronClientInvoker.invoke();
        }
    }

    private void ensureOpen() {
        if (this.isClosed) {
            throw new ArchiveException("client is closed");
        }
    }

    public static class AsyncConnect
    implements AutoCloseable {
        private final Context ctx;
        private final ControlResponsePoller controlResponsePoller;
        private final ArchiveProxy archiveProxy;
        private long connectCorrelationId = -1L;
        private int step = 0;

        AsyncConnect(Context ctx, ControlResponsePoller controlResponsePoller, ArchiveProxy archiveProxy) {
            this.ctx = ctx;
            this.controlResponsePoller = controlResponsePoller;
            this.archiveProxy = archiveProxy;
        }

        @Override
        public void close() {
            CloseHelper.close(this.controlResponsePoller.subscription());
            CloseHelper.close(this.archiveProxy.publication());
            this.ctx.close();
        }

        public AeronArchive poll() {
            if (0 == this.step) {
                if (!this.archiveProxy.publication().isConnected()) {
                    return null;
                }
                this.step = 1;
            }
            if (1 == this.step) {
                this.connectCorrelationId = this.ctx.aeron.nextCorrelationId();
                this.step = 2;
            }
            if (2 == this.step) {
                if (!this.archiveProxy.tryConnect(this.ctx.controlResponseChannel(), this.ctx.controlResponseStreamId(), this.connectCorrelationId)) {
                    return null;
                }
                this.step = 3;
            }
            if (3 == this.step) {
                if (!this.controlResponsePoller.subscription().isConnected()) {
                    return null;
                }
                this.step = 4;
            }
            this.controlResponsePoller.poll();
            if (this.controlResponsePoller.isPollComplete() && this.controlResponsePoller.correlationId() == this.connectCorrelationId && this.controlResponsePoller.templateId() == 1) {
                ControlResponseCode code = this.controlResponsePoller.code();
                if (code != ControlResponseCode.OK) {
                    if (code == ControlResponseCode.ERROR) {
                        throw new ArchiveException("error: " + this.controlResponsePoller.errorMessage(), (int)this.controlResponsePoller.relevantId());
                    }
                    throw new ArchiveException("unexpected response: code=" + (Object)((Object)code));
                }
                long controlSessionId = this.controlResponsePoller.controlSessionId();
                Subscription subscription = this.controlResponsePoller.subscription();
                return new AeronArchive(this.ctx, this.controlResponsePoller, this.archiveProxy, new RecordingDescriptorPoller(subscription, this.ctx.errorHandler(), controlSessionId, 10), controlSessionId);
            }
            return null;
        }
    }

    public static class Context
    implements Cloneable {
        private long messageTimeoutNs = Configuration.messageTimeoutNs();
        private String recordingEventsChannel = Configuration.recordingEventsChannel();
        private int recordingEventsStreamId = Configuration.recordingEventsStreamId();
        private String controlRequestChannel = Configuration.controlChannel();
        private int controlRequestStreamId = Configuration.controlStreamId();
        private String controlResponseChannel = Configuration.controlResponseChannel();
        private int controlResponseStreamId = Configuration.controlResponseStreamId();
        private boolean controlTermBufferSparse = Configuration.controlTermBufferSparse();
        private int controlTermBufferLength = Configuration.controlTermBufferLength();
        private int controlMtuLength = Configuration.controlMtuLength();
        private IdleStrategy idleStrategy;
        private Lock lock;
        private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
        private Aeron aeron;
        private ErrorHandler errorHandler;
        private boolean ownsAeronClient = false;

        public Context clone() {
            try {
                return (Context)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void conclude() {
            if (null == this.aeron) {
                this.aeron = Aeron.connect(new Aeron.Context().aeronDirectoryName(this.aeronDirectoryName));
                this.ownsAeronClient = true;
            }
            if (null == this.idleStrategy) {
                this.idleStrategy = new BackoffIdleStrategy(10L, 20L, 1000L, io.aeron.driver.Configuration.IDLE_MAX_PARK_NS);
            }
            if (null == this.lock) {
                this.lock = new ReentrantLock();
            }
            ChannelUri uri = ChannelUri.parse(this.controlRequestChannel);
            uri.put("term-length", Integer.toString(this.controlTermBufferLength));
            uri.put("mtu", Integer.toString(this.controlMtuLength));
            uri.put("sparse", Boolean.toString(this.controlTermBufferSparse));
            this.controlRequestChannel = uri.toString();
        }

        public Context messageTimeoutNs(long messageTimeoutNs) {
            this.messageTimeoutNs = messageTimeoutNs;
            return this;
        }

        public long messageTimeoutNs() {
            return this.messageTimeoutNs;
        }

        public String recordingEventsChannel() {
            return this.recordingEventsChannel;
        }

        public Context recordingEventsChannel(String recordingEventsChannel) {
            this.recordingEventsChannel = recordingEventsChannel;
            return this;
        }

        public int recordingEventsStreamId() {
            return this.recordingEventsStreamId;
        }

        public Context recordingEventsStreamId(int recordingEventsStreamId) {
            this.recordingEventsStreamId = recordingEventsStreamId;
            return this;
        }

        public Context controlRequestChannel(String channel) {
            this.controlRequestChannel = channel;
            return this;
        }

        public String controlRequestChannel() {
            return this.controlRequestChannel;
        }

        public Context controlRequestStreamId(int streamId) {
            this.controlRequestStreamId = streamId;
            return this;
        }

        public int controlRequestStreamId() {
            return this.controlRequestStreamId;
        }

        public Context controlResponseChannel(String channel) {
            this.controlResponseChannel = channel;
            return this;
        }

        public String controlResponseChannel() {
            return this.controlResponseChannel;
        }

        public Context controlResponseStreamId(int streamId) {
            this.controlResponseStreamId = streamId;
            return this;
        }

        public int controlResponseStreamId() {
            return this.controlResponseStreamId;
        }

        public Context controlTermBufferSparse(boolean controlTermBufferSparse) {
            this.controlTermBufferSparse = controlTermBufferSparse;
            return this;
        }

        public boolean controlTermBufferSparse() {
            return this.controlTermBufferSparse;
        }

        public Context controlTermBufferLength(int controlTermBufferLength) {
            this.controlTermBufferLength = controlTermBufferLength;
            return this;
        }

        public int controlTermBufferLength() {
            return this.controlTermBufferLength;
        }

        public Context controlMtuLength(int controlMtuLength) {
            this.controlMtuLength = controlMtuLength;
            return this;
        }

        public int controlMtuLength() {
            return this.controlMtuLength;
        }

        public Context idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Context aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Context aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public Aeron aeron() {
            return this.aeron;
        }

        public Context ownsAeronClient(boolean ownsAeronClient) {
            this.ownsAeronClient = ownsAeronClient;
            return this;
        }

        public boolean ownsAeronClient() {
            return this.ownsAeronClient;
        }

        public Context lock(Lock lock) {
            this.lock = lock;
            return this;
        }

        public Lock lock() {
            return this.lock;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public void close() {
            if (this.ownsAeronClient) {
                CloseHelper.close(this.aeron);
            }
        }
    }

    public static class Configuration {
        public static final String MESSAGE_TIMEOUT_PROP_NAME = "aeron.archive.message.timeout";
        public static final long MESSAGE_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(5L);
        public static final String CONTROL_CHANNEL_PROP_NAME = "aeron.archive.control.channel";
        public static final String CONTROL_CHANNEL_DEFAULT = "aeron:udp?endpoint=localhost:8010";
        public static final String CONTROL_STREAM_ID_PROP_NAME = "aeron.archive.control.stream.id";
        public static final int CONTROL_STREAM_ID_DEFAULT = 10;
        public static final String LOCAL_CONTROL_CHANNEL_PROP_NAME = "aeron.archive.local.control.channel";
        public static final String LOCAL_CONTROL_CHANNEL_DEFAULT = "aeron:ipc";
        public static final String LOCAL_CONTROL_STREAM_ID_PROP_NAME = "aeron.archive.local.control.stream.id";
        public static final int LOCAL_CONTROL_STREAM_ID_DEFAULT = 11;
        public static final String CONTROL_RESPONSE_CHANNEL_PROP_NAME = "aeron.archive.control.response.channel";
        public static final String CONTROL_RESPONSE_CHANNEL_DEFAULT = "aeron:udp?endpoint=localhost:8020";
        public static final String CONTROL_RESPONSE_STREAM_ID_PROP_NAME = "aeron.archive.control.response.stream.id";
        public static final int CONTROL_RESPONSE_STREAM_ID_DEFAULT = 20;
        public static final String RECORDING_EVENTS_CHANNEL_PROP_NAME = "aeron.archive.recording.events.channel";
        public static final String RECORDING_EVENTS_CHANNEL_DEFAULT = "aeron:udp?endpoint=localhost:8030";
        public static final String RECORDING_EVENTS_STREAM_ID_PROP_NAME = "aeron.archive.recording.events.stream.id";
        public static final int RECORDING_EVENTS_STREAM_ID_DEFAULT = 30;
        public static final String CONTROL_TERM_BUFFER_SPARSE_PARAM_NAME = "aeron.archive.control.term.buffer.sparse";
        public static final boolean CONTROL_TERM_BUFFER_SPARSE_DEFAULT = true;
        public static final String CONTROL_TERM_BUFFER_LENGTH_PARAM_NAME = "aeron.archive.control.term.buffer.length";
        public static final int CONTROL_TERM_BUFFER_LENGTH_DEFAULT = 65536;
        public static final String CONTROL_MTU_LENGTH_PARAM_NAME = "aeron.archive.control.mtu.length";
        public static final int CONTROL_MTU_LENGTH_DEFAULT = io.aeron.driver.Configuration.MTU_LENGTH;

        public static long messageTimeoutNs() {
            return SystemUtil.getDurationInNanos(MESSAGE_TIMEOUT_PROP_NAME, MESSAGE_TIMEOUT_DEFAULT_NS);
        }

        public static boolean controlTermBufferSparse() {
            String propValue = System.getProperty(CONTROL_TERM_BUFFER_SPARSE_PARAM_NAME);
            return null != propValue ? "true".equals(propValue) : true;
        }

        public static int controlTermBufferLength() {
            return SystemUtil.getSizeAsInt(CONTROL_TERM_BUFFER_LENGTH_PARAM_NAME, 65536);
        }

        public static int controlMtuLength() {
            return SystemUtil.getSizeAsInt(CONTROL_MTU_LENGTH_PARAM_NAME, CONTROL_MTU_LENGTH_DEFAULT);
        }

        public static String controlChannel() {
            return System.getProperty(CONTROL_CHANNEL_PROP_NAME, CONTROL_CHANNEL_DEFAULT);
        }

        public static int controlStreamId() {
            return Integer.getInteger(CONTROL_STREAM_ID_PROP_NAME, 10);
        }

        public static String localControlChannel() {
            return System.getProperty(LOCAL_CONTROL_CHANNEL_PROP_NAME, LOCAL_CONTROL_CHANNEL_DEFAULT);
        }

        public static int localControlStreamId() {
            return Integer.getInteger(LOCAL_CONTROL_STREAM_ID_PROP_NAME, 11);
        }

        public static String controlResponseChannel() {
            return System.getProperty(CONTROL_RESPONSE_CHANNEL_PROP_NAME, CONTROL_RESPONSE_CHANNEL_DEFAULT);
        }

        public static int controlResponseStreamId() {
            return Integer.getInteger(CONTROL_RESPONSE_STREAM_ID_PROP_NAME, 20);
        }

        public static String recordingEventsChannel() {
            return System.getProperty(RECORDING_EVENTS_CHANNEL_PROP_NAME, RECORDING_EVENTS_CHANNEL_DEFAULT);
        }

        public static int recordingEventsStreamId() {
            return Integer.getInteger(RECORDING_EVENTS_STREAM_ID_PROP_NAME, 30);
        }
    }
}

