/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Session;
import java.util.ArrayList;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayListUtil;
import org.agrona.concurrent.Agent;

class SessionWorker<T extends Session>
implements Agent {
    private final ArrayList<T> sessions = new ArrayList();
    private final String roleName;
    private boolean isClosed = false;
    protected final ErrorHandler errorHandler;

    SessionWorker(String roleName, ErrorHandler errorHandler) {
        this.roleName = roleName;
        this.errorHandler = errorHandler;
    }

    @Override
    public String roleName() {
        return this.roleName;
    }

    @Override
    public final int doWork() {
        int lastIndex;
        int workDone = this.preWork();
        ArrayList<T> sessions = this.sessions;
        for (int i = lastIndex = sessions.size() - 1; i >= 0; --i) {
            Session session = (Session)sessions.get(i);
            workDone += session.doWork();
            if (!session.isDone()) continue;
            ArrayListUtil.fastUnorderedRemove(sessions, i, lastIndex--);
            this.closeSession(session);
        }
        return workDone;
    }

    @Override
    public final void onClose() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.preSessionsClose();
        int size = this.sessions.size();
        for (int i = 0; i < size; ++i) {
            this.closeSession((Session)this.sessions.get(i));
        }
        this.postSessionsClose();
    }

    protected void closeSession(T session) {
        try {
            session.close();
        }
        catch (Exception ex) {
            this.errorHandler.onError(ex);
        }
    }

    protected int preWork() {
        return 0;
    }

    protected void postSessionsClose() {
    }

    protected void preSessionsClose() {
    }

    boolean isClosed() {
        return this.isClosed;
    }

    protected void addSession(T session) {
        this.sessions.add(session);
    }
}

