/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Image;
import io.aeron.archive.Archive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.logbuffer.BlockHandler;
import io.aeron.logbuffer.FrameDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;

class RecordingWriter
implements BlockHandler {
    private final long recordingId;
    private final int segmentLength;
    private final boolean forceWrites;
    private final boolean forceMetadata;
    private final FileChannel archiveDirChannel;
    private final File archiveDir;
    private int segmentOffset;
    private int segmentIndex;
    private FileChannel recordingFileChannel;
    private boolean isClosed = false;

    RecordingWriter(long recordingId, long startPosition, int segmentLength, Image image, Archive.Context ctx, FileChannel archiveDirChannel) {
        this.recordingId = recordingId;
        this.archiveDirChannel = archiveDirChannel;
        this.segmentLength = segmentLength;
        this.archiveDir = ctx.archiveDir();
        this.forceWrites = ctx.fileSyncLevel() > 0;
        this.forceMetadata = ctx.fileSyncLevel() > 1;
        long joinPosition = image.joinPosition();
        long startTermBasePosition = startPosition - (startPosition & (long)(image.termBufferLength() - 1));
        this.segmentOffset = (int)(joinPosition - startTermBasePosition) & segmentLength - 1;
        this.segmentIndex = Archive.segmentFileIndex(startPosition, joinPosition, segmentLength);
    }

    @Override
    public void onBlock(DirectBuffer termBuffer, int termOffset, int length, int sessionId, int termId) {
        try {
            boolean isPaddingFrame = termBuffer.getShort(FrameDescriptor.typeOffset(termOffset)) == 0;
            int dataLength = isPaddingFrame ? 32 : length;
            ByteBuffer byteBuffer = termBuffer.byteBuffer();
            byteBuffer.limit(termOffset + dataLength).position(termOffset);
            do {
                this.recordingFileChannel.write(byteBuffer);
            } while (byteBuffer.remaining() > 0);
            if (this.forceWrites) {
                this.recordingFileChannel.force(this.forceMetadata);
            }
            this.segmentOffset += length;
            if (this.segmentOffset >= this.segmentLength) {
                this.onFileRollOver();
            } else if (isPaddingFrame) {
                this.recordingFileChannel.position(this.segmentOffset);
            }
        }
        catch (ClosedByInterruptException ex) {
            Thread.interrupted();
            this.close();
            throw new ArchiveException("file closed by interrupt, recording aborted", ex, 0);
        }
        catch (Exception ex) {
            this.close();
            LangUtil.rethrowUnchecked(ex);
        }
    }

    void close() {
        if (!this.isClosed) {
            CloseHelper.close(this.recordingFileChannel);
            this.isClosed = true;
        }
    }

    void init() throws IOException {
        this.openRecordingSegmentFile();
        if (this.segmentOffset != 0) {
            this.recordingFileChannel.position(this.segmentOffset);
        }
    }

    boolean isClosed() {
        return this.isClosed;
    }

    private void openRecordingSegmentFile() {
        File file = new File(this.archiveDir, Archive.segmentFileName(this.recordingId, this.segmentIndex));
        RandomAccessFile recordingFile = null;
        try {
            recordingFile = new RandomAccessFile(file, "rw");
            recordingFile.setLength(this.segmentLength);
            this.recordingFileChannel = recordingFile.getChannel();
            if (this.forceWrites && null != this.archiveDirChannel) {
                this.archiveDirChannel.force(this.forceMetadata);
            }
        }
        catch (IOException ex) {
            CloseHelper.close(recordingFile);
            this.close();
            LangUtil.rethrowUnchecked(ex);
        }
    }

    private void onFileRollOver() {
        CloseHelper.close(this.recordingFileChannel);
        this.segmentOffset = 0;
        ++this.segmentIndex;
        this.openRecordingSegmentFile();
    }
}

