/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Counter;
import io.aeron.Image;
import io.aeron.archive.Archive;
import io.aeron.archive.RecordingEventsProxy;
import io.aeron.archive.RecordingWriter;
import io.aeron.archive.Session;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;

class RecordingSession
implements Session {
    private final long recordingId;
    private final int blockLengthLimit;
    private final RecordingEventsProxy recordingEventsProxy;
    private final Image image;
    private final Counter position;
    private final RecordingWriter recordingWriter;
    private State state = State.INIT;
    private final String originalChannel;

    RecordingSession(long recordingId, long startPosition, int segmentLength, String originalChannel, RecordingEventsProxy recordingEventsProxy, Image image, Counter position, FileChannel archiveDirChannel, Archive.Context ctx) {
        this.recordingId = recordingId;
        this.originalChannel = originalChannel;
        this.recordingEventsProxy = recordingEventsProxy;
        this.image = image;
        this.position = position;
        this.blockLengthLimit = Math.min(image.termBufferLength(), 0x200000);
        this.recordingWriter = new RecordingWriter(recordingId, startPosition, segmentLength, image, ctx, archiveDirChannel);
    }

    @Override
    public long sessionId() {
        return this.recordingId;
    }

    @Override
    public boolean isDone() {
        return this.state == State.STOPPED;
    }

    @Override
    public void abort() {
        this.state = State.INACTIVE;
    }

    @Override
    public void close() {
        this.recordingWriter.close();
        CloseHelper.close(this.position);
    }

    public Counter recordingPosition() {
        return this.position;
    }

    @Override
    public int doWork() {
        int workDone = 0;
        if (State.INIT == this.state) {
            workDone += this.init();
        }
        if (State.RECORDING == this.state) {
            workDone += this.record();
        }
        if (State.INACTIVE == this.state) {
            this.state = State.STOPPED;
            this.recordingEventsProxy.stopped(this.recordingId, this.image.joinPosition(), this.image.position());
            this.recordingWriter.close();
            ++workDone;
        }
        return workDone;
    }

    private int init() {
        try {
            this.recordingWriter.init();
        }
        catch (IOException ex) {
            this.close();
            this.state = State.STOPPED;
            LangUtil.rethrowUnchecked(ex);
        }
        this.recordingEventsProxy.started(this.recordingId, this.image.joinPosition(), this.image.sessionId(), this.image.subscription().streamId(), this.originalChannel, this.image.sourceIdentity());
        this.state = State.RECORDING;
        return 1;
    }

    private int record() {
        int workCount = 0;
        try {
            workCount = this.image.blockPoll(this.recordingWriter, this.blockLengthLimit);
            if (workCount > 0) {
                long position = this.image.position();
                this.position.setOrdered(position);
                this.recordingEventsProxy.progress(this.recordingId, this.image.joinPosition(), position);
            } else if (this.image.isEndOfStream() || this.image.isClosed()) {
                this.state = State.INACTIVE;
            }
            if (this.recordingWriter.isClosed()) {
                this.state = State.INACTIVE;
            }
        }
        catch (Exception ex) {
            this.state = State.INACTIVE;
            LangUtil.rethrowUnchecked(ex);
        }
        return workCount;
    }

    private static enum State {
        INIT,
        RECORDING,
        INACTIVE,
        STOPPED;

    }
}

