/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Counter;
import io.aeron.archive.Archive;
import io.aeron.archive.Catalog;
import io.aeron.archive.RecordingSummary;
import io.aeron.archive.SimpleFragmentHandler;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import org.agrona.BitUtil;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;

class RecordingReader
implements AutoCloseable {
    private static final EnumSet<StandardOpenOption> FILE_OPTIONS = EnumSet.of(StandardOpenOption.READ);
    private static final FileAttribute<?>[] NO_ATTRIBUTES = new FileAttribute[0];
    private final File archiveDir;
    private final long recordingId;
    private final int segmentLength;
    private final int termLength;
    private final Catalog catalog;
    private final Counter recordingPosition;
    private final UnsafeBuffer termBuffer;
    private MappedByteBuffer mappedSegmentBuffer;
    private long stopPosition;
    private long replayPosition;
    private long replayLimit;
    private int termOffset;
    private int termBaseSegmentOffset;
    private int segmentFileIndex;
    private boolean isDone = false;

    RecordingReader(Catalog catalog, RecordingSummary recordingSummary, File archiveDir, long position, long length, Counter recordingPosition) {
        long currentPosition;
        long replayLength;
        this.catalog = catalog;
        this.archiveDir = archiveDir;
        this.recordingPosition = recordingPosition;
        this.termLength = recordingSummary.termBufferLength;
        this.segmentLength = recordingSummary.segmentFileLength;
        this.recordingId = recordingSummary.recordingId;
        this.stopPosition = null == recordingPosition ? recordingSummary.stopPosition : recordingPosition.get();
        long startPosition = recordingSummary.startPosition;
        long fromPosition = position == -1L ? startPosition : position;
        long maxLength = null == recordingPosition ? this.stopPosition - fromPosition : Long.MAX_VALUE - fromPosition;
        long l = replayLength = length == -1L ? maxLength : Math.min(length, maxLength);
        if (replayLength < 0L) {
            throw new IllegalArgumentException("length must be positive");
        }
        if (null != recordingPosition && (currentPosition = recordingPosition.get()) < fromPosition) {
            throw new IllegalArgumentException(fromPosition + " after current position of " + currentPosition);
        }
        int positionBitsToShift = LogBufferDescriptor.positionBitsToShift(this.termLength);
        long startTermBasePosition = startPosition - (startPosition & (long)(this.termLength - 1));
        int segmentOffset = (int)(fromPosition - startTermBasePosition) & this.segmentLength - 1;
        int termId = (int)(fromPosition >> positionBitsToShift) + recordingSummary.initialTermId;
        this.segmentFileIndex = Archive.segmentFileIndex(startPosition, fromPosition, this.segmentLength);
        this.openRecordingSegment();
        this.termOffset = (int)(fromPosition & (long)(this.termLength - 1));
        this.termBaseSegmentOffset = segmentOffset - this.termOffset;
        this.termBuffer = new UnsafeBuffer(this.mappedSegmentBuffer, this.termBaseSegmentOffset, this.termLength);
        if (fromPosition > startPosition && fromPosition != this.stopPosition && (DataHeaderFlyweight.termOffset(this.termBuffer, this.termOffset) != this.termOffset || DataHeaderFlyweight.termId(this.termBuffer, this.termOffset) != termId || DataHeaderFlyweight.streamId(this.termBuffer, this.termOffset) != recordingSummary.streamId)) {
            this.close();
            throw new IllegalArgumentException(fromPosition + " position not aligned to valid fragment");
        }
        this.replayPosition = fromPosition;
        this.replayLimit = fromPosition + replayLength;
    }

    @Override
    public void close() {
        this.closeRecordingSegment();
    }

    long recordingId() {
        return this.recordingId;
    }

    boolean isDone() {
        return this.isDone;
    }

    int poll(SimpleFragmentHandler fragmentHandler, int fragmentLimit) {
        int fragments;
        if (this.recordingPosition != null && this.replayPosition == this.stopPosition && this.noNewData(this.replayPosition, this.stopPosition)) {
            return fragments;
        }
        for (fragments = 0; this.replayPosition < this.stopPosition && fragments < fragmentLimit; ++fragments) {
            if (this.termOffset == this.termLength) {
                this.nextTerm();
            }
            int frameOffset = this.termOffset;
            UnsafeBuffer termBuffer = this.termBuffer;
            int frameLength = FrameDescriptor.frameLength(termBuffer, frameOffset);
            int frameType = FrameDescriptor.frameType(termBuffer, frameOffset);
            byte flags = FrameDescriptor.frameFlags(termBuffer, frameOffset);
            long reservedValue = termBuffer.getLong(frameOffset + 24, ByteOrder.LITTLE_ENDIAN);
            int alignedLength = BitUtil.align(frameLength, 32);
            int dataOffset = frameOffset + 32;
            int dataLength = frameLength - 32;
            fragmentHandler.onFragment(termBuffer, dataOffset, dataLength, frameType, flags, reservedValue);
            this.replayPosition += (long)alignedLength;
            this.termOffset += alignedLength;
            if (this.replayPosition < this.replayLimit) continue;
            this.isDone = true;
            this.closeRecordingSegment();
            break;
        }
        return fragments;
    }

    private boolean noNewData(long replayPosition, long oldStopPosition) {
        long newStopPosition;
        long currentRecodingPosition = this.recordingPosition.get();
        boolean hasRecordingStopped = this.recordingPosition.isClosed();
        long l = newStopPosition = hasRecordingStopped ? this.catalog.stopPosition(this.recordingId) : currentRecodingPosition;
        if (hasRecordingStopped && newStopPosition < this.replayLimit) {
            this.replayLimit = newStopPosition;
        }
        if (replayPosition >= this.replayLimit) {
            this.isDone = true;
        } else if (newStopPosition > oldStopPosition) {
            this.stopPosition = newStopPosition;
            return false;
        }
        return true;
    }

    private void nextTerm() {
        this.termOffset = 0;
        this.termBaseSegmentOffset += this.termLength;
        if (this.termBaseSegmentOffset == this.segmentLength) {
            this.closeRecordingSegment();
            ++this.segmentFileIndex;
            this.openRecordingSegment();
            this.termBaseSegmentOffset = 0;
        }
        this.termBuffer.wrap(this.mappedSegmentBuffer, this.termBaseSegmentOffset, this.termLength);
    }

    private void closeRecordingSegment() {
        IoUtil.unmap(this.mappedSegmentBuffer);
        this.mappedSegmentBuffer = null;
    }

    private void openRecordingSegment() {
        String segmentFileName = Archive.segmentFileName(this.recordingId, this.segmentFileIndex);
        File segmentFile = new File(this.archiveDir, segmentFileName);
        if (!segmentFile.exists()) {
            throw new IllegalArgumentException("failed to open recording segment file " + segmentFileName);
        }
        try (FileChannel channel = FileChannel.open(segmentFile.toPath(), FILE_OPTIONS, NO_ATTRIBUTES);){
            this.mappedSegmentBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.segmentLength);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }
}

