/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Archive;
import io.aeron.archive.ArchiveConductor;
import io.aeron.archive.RecordingSession;
import io.aeron.archive.ReplaySession;
import io.aeron.archive.Session;
import io.aeron.archive.SessionWorker;
import java.util.function.Consumer;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.status.AtomicCounter;

final class DedicatedModeArchiveConductor
extends ArchiveConductor {
    private static final int COMMAND_LIMIT = 10;
    private final ManyToOneConcurrentArrayQueue<Session> closeQueue;
    private AgentRunner replayerAgentRunner;
    private AgentRunner recorderAgentRunner;

    DedicatedModeArchiveConductor(Archive.Context ctx) {
        super(ctx);
        this.closeQueue = new ManyToOneConcurrentArrayQueue(ctx.maxConcurrentRecordings() + ctx.maxConcurrentReplays());
    }

    @Override
    public void onStart() {
        super.onStart();
        this.recorderAgentRunner = new AgentRunner(this.ctx.idleStrategy(), this.errorHandler, this.ctx.errorCounter(), this.recorder);
        this.replayerAgentRunner = new AgentRunner(this.ctx.idleStrategy(), this.errorHandler, this.ctx.errorCounter(), this.replayer);
        AgentRunner.startOnThread(this.replayerAgentRunner, this.ctx.threadFactory());
        AgentRunner.startOnThread(this.recorderAgentRunner, this.ctx.threadFactory());
    }

    @Override
    protected SessionWorker<RecordingSession> newRecorder() {
        return new DedicatedModeRecorder(this.errorHandler, this.ctx.errorCounter(), this.closeQueue, this.ctx.maxConcurrentRecordings());
    }

    @Override
    protected SessionWorker<ReplaySession> newReplayer() {
        return new DedicatedModeReplayer(this.errorHandler, this.ctx.errorCounter(), this.closeQueue, this.ctx.maxConcurrentReplays());
    }

    @Override
    protected int preWork() {
        return super.preWork() + this.processCloseQueue();
    }

    @Override
    protected void closeSessionWorkers() {
        try {
            CloseHelper.close(this.recorderAgentRunner);
        }
        catch (Exception ex) {
            this.errorHandler.onError(ex);
        }
        try {
            CloseHelper.close(this.replayerAgentRunner);
        }
        catch (Exception ex) {
            this.errorHandler.onError(ex);
        }
        while (this.processCloseQueue() > 0 || !this.closeQueue.isEmpty()) {
            Thread.yield();
        }
    }

    private int processCloseQueue() {
        Session session;
        int i;
        for (i = 0; i < 10 && (session = this.closeQueue.poll()) != null; ++i) {
            if (session instanceof RecordingSession) {
                this.closeRecordingSession((RecordingSession)session);
                continue;
            }
            if (session instanceof ReplaySession) {
                this.closeReplaySession((ReplaySession)session);
                continue;
            }
            this.closeSession(session);
        }
        return i;
    }

    static class DedicatedModeReplayer
    extends SessionWorker<ReplaySession>
    implements Consumer<ReplaySession> {
        private final OneToOneConcurrentArrayQueue<ReplaySession> sessionsQueue;
        private final ManyToOneConcurrentArrayQueue<Session> closeQueue;
        private final AtomicCounter errorCounter;

        DedicatedModeReplayer(ErrorHandler errorHandler, AtomicCounter errorCounter, ManyToOneConcurrentArrayQueue<Session> closeQueue, int maxConcurrentSessions) {
            super("archive-replayer", errorHandler);
            this.closeQueue = closeQueue;
            this.errorCounter = errorCounter;
            this.sessionsQueue = new OneToOneConcurrentArrayQueue(maxConcurrentSessions);
        }

        @Override
        public void accept(ReplaySession session) {
            super.addSession(session);
        }

        @Override
        protected void addSession(ReplaySession session) {
            this.send(session);
        }

        @Override
        protected int preWork() {
            return this.sessionsQueue.drain(this);
        }

        @Override
        protected void preSessionsClose() {
            this.sessionsQueue.drain(this);
        }

        @Override
        protected void closeSession(ReplaySession session) {
            while (!this.closeQueue.offer(session)) {
                this.errorCounter.increment();
                Thread.yield();
            }
        }

        private void send(ReplaySession session) {
            while (!this.sessionsQueue.offer(session)) {
                this.errorCounter.increment();
                Thread.yield();
            }
        }
    }

    static class DedicatedModeRecorder
    extends SessionWorker<RecordingSession>
    implements Consumer<RecordingSession> {
        private final OneToOneConcurrentArrayQueue<RecordingSession> sessionsQueue;
        private final ManyToOneConcurrentArrayQueue<Session> closeQueue;
        private final AtomicCounter errorCounter;

        DedicatedModeRecorder(ErrorHandler errorHandler, AtomicCounter errorCounter, ManyToOneConcurrentArrayQueue<Session> closeQueue, int maxConcurrentSessions) {
            super("archive-recorder", errorHandler);
            this.closeQueue = closeQueue;
            this.errorCounter = errorCounter;
            this.sessionsQueue = new OneToOneConcurrentArrayQueue(maxConcurrentSessions);
        }

        @Override
        public void accept(RecordingSession session) {
            super.addSession(session);
        }

        @Override
        protected int preWork() {
            return this.sessionsQueue.drain(this);
        }

        @Override
        protected void preSessionsClose() {
            this.sessionsQueue.drain(this);
        }

        @Override
        protected void addSession(RecordingSession session) {
            this.send(session);
        }

        @Override
        protected void closeSession(RecordingSession session) {
            while (!this.closeQueue.offer(session)) {
                this.errorCounter.increment();
                Thread.yield();
            }
        }

        private void send(RecordingSession session) {
            while (!this.sessionsQueue.offer(session)) {
                this.errorCounter.increment();
                Thread.yield();
            }
        }
    }
}

