/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Image;
import io.aeron.ImageFragmentAssembler;
import io.aeron.archive.ArchiveConductor;
import io.aeron.archive.ControlRequestAdapter;
import io.aeron.archive.ControlRequestListener;
import io.aeron.archive.ControlSession;
import io.aeron.archive.Session;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.logbuffer.FragmentHandler;
import org.agrona.collections.Long2ObjectHashMap;

class ControlSessionDemuxer
implements Session,
ControlRequestListener {
    private static final int FRAGMENT_LIMIT = 10;
    private final Image image;
    private final ArchiveConductor conductor;
    private final FragmentHandler adapter = new ImageFragmentAssembler(new ControlRequestAdapter(this));
    private final Long2ObjectHashMap<ControlSession> controlSessionByIdMap = new Long2ObjectHashMap();
    private State state = State.ACTIVE;

    ControlSessionDemuxer(Image image, ArchiveConductor conductor) {
        this.image = image;
        this.conductor = conductor;
    }

    @Override
    public long sessionId() {
        return this.image.correlationId();
    }

    @Override
    public void abort() {
        this.state = State.INACTIVE;
    }

    @Override
    public void close() {
        this.state = State.CLOSED;
    }

    @Override
    public boolean isDone() {
        return this.state == State.INACTIVE;
    }

    @Override
    public int doWork() {
        int workCount = 0;
        if (this.state == State.ACTIVE) {
            if (this.image.isClosed()) {
                this.state = State.INACTIVE;
                for (Session session : this.controlSessionByIdMap.values()) {
                    session.abort();
                }
            } else {
                workCount += this.image.poll(this.adapter, 10);
            }
        }
        return workCount;
    }

    @Override
    public void onConnect(long correlationId, int streamId, String channel) {
        ControlSession session = this.conductor.newControlSession(correlationId, streamId, channel, this);
        this.controlSessionByIdMap.put(session.sessionId(), session);
    }

    @Override
    public void onCloseSession(long controlSessionId) {
        ControlSession session = this.controlSessionByIdMap.get(controlSessionId);
        if (null != session) {
            session.abort();
        }
    }

    @Override
    public void onStartRecording(long controlSessionId, long correlationId, int streamId, String channel, SourceLocation sourceLocation) {
        ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
        controlSession.onStartRecording(correlationId, channel, streamId, sourceLocation);
    }

    @Override
    public void onStopRecording(long controlSessionId, long correlationId, int streamId, String channel) {
        ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
        controlSession.onStopRecording(correlationId, streamId, channel);
    }

    @Override
    public void onStopRecordingSubscription(long controlSessionId, long correlationId, long subscriptionId) {
        ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
        controlSession.onStopRecordingSubscription(correlationId, subscriptionId);
    }

    @Override
    public void onStartReplay(long controlSessionId, long correlationId, long recordingId, long position, long length, int replayStreamId, String replayChannel) {
        ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
        controlSession.onStartReplay(correlationId, recordingId, position, length, replayStreamId, replayChannel);
    }

    @Override
    public void onStopReplay(long controlSessionId, long correlationId, long replaySessionId) {
        ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
        controlSession.onStopReplay(correlationId, replaySessionId);
    }

    @Override
    public void onListRecordingsForUri(long controlSessionId, long correlationId, long fromRecordingId, int recordCount, int streamId, byte[] channelFragment) {
        ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
        controlSession.onListRecordingsForUri(correlationId, fromRecordingId, recordCount, streamId, channelFragment);
    }

    @Override
    public void onListRecordings(long controlSessionId, long correlationId, long fromRecordingId, int recordCount) {
        ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
        controlSession.onListRecordings(correlationId, fromRecordingId, recordCount);
    }

    @Override
    public void onListRecording(long controlSessionId, long correlationId, long recordingId) {
        ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
        controlSession.onListRecording(correlationId, recordingId);
    }

    @Override
    public void onExtendRecording(long controlSessionId, long correlationId, long recordingId, int streamId, String channel, SourceLocation sourceLocation) {
        ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
        controlSession.onExtendRecording(correlationId, recordingId, channel, streamId, sourceLocation);
    }

    @Override
    public void onGetRecordingPosition(long controlSessionId, long correlationId, long recordingId) {
        ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
        controlSession.onGetRecordingPosition(correlationId, recordingId);
    }

    @Override
    public void onTruncateRecording(long controlSessionId, long correlationId, long recordingId, long position) {
        ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
        controlSession.onTruncateRecording(correlationId, recordingId, position);
    }

    @Override
    public void onGetStopPosition(long controlSessionId, long correlationId, long recordingId) {
        ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
        controlSession.onGetStopPosition(correlationId, recordingId);
    }

    @Override
    public void onFindLastMatchingRecording(long controlSessionId, long correlationId, long minRecordingId, int sessionId, int streamId, byte[] channelFragment) {
        ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
        controlSession.onFindLastMatchingRecording(correlationId, minRecordingId, sessionId, streamId, channelFragment);
    }

    void removeControlSession(ControlSession controlSession) {
        this.controlSessionByIdMap.remove(controlSession.sessionId());
    }

    private ControlSession getControlSession(long controlSessionId, long correlationId) {
        ControlSession controlSession = this.controlSessionByIdMap.get(controlSessionId);
        if (controlSession == null) {
            throw new ArchiveException("unknown controlSessionId=" + controlSessionId + " for correlationId=" + correlationId);
        }
        return controlSession;
    }

    static enum State {
        ACTIVE,
        INACTIVE,
        CLOSED;

    }
}

