/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Publication;
import io.aeron.archive.AbstractListRecordingsSession;
import io.aeron.archive.ArchiveConductor;
import io.aeron.archive.ControlResponseProxy;
import io.aeron.archive.ControlSessionDemuxer;
import io.aeron.archive.Session;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.SourceLocation;
import java.util.ArrayDeque;
import java.util.function.BooleanSupplier;
import org.agrona.CloseHelper;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.UnsafeBuffer;

class ControlSession
implements Session {
    private final ArchiveConductor conductor;
    private final EpochClock epochClock;
    private final ArrayDeque<BooleanSupplier> queuedResponses = new ArrayDeque(8);
    private final ControlResponseProxy controlResponseProxy;
    private final long controlSessionId;
    private final long correlationId;
    private final long connectTimeoutMs;
    private long activityDeadlineMs = -1L;
    private final ControlSessionDemuxer demuxer;
    private final Publication controlPublication;
    private State state = State.INIT;
    private AbstractListRecordingsSession activeListRecordingsSession;

    ControlSession(long controlSessionId, long correlationId, long connectTimeoutMs, ControlSessionDemuxer demuxer, Publication controlPublication, ArchiveConductor conductor, EpochClock epochClock, ControlResponseProxy controlResponseProxy) {
        this.controlSessionId = controlSessionId;
        this.correlationId = correlationId;
        this.connectTimeoutMs = connectTimeoutMs;
        this.demuxer = demuxer;
        this.controlPublication = controlPublication;
        this.conductor = conductor;
        this.epochClock = epochClock;
        this.controlResponseProxy = controlResponseProxy;
    }

    @Override
    public long sessionId() {
        return this.controlSessionId;
    }

    @Override
    public void abort() {
        this.state = State.INACTIVE;
    }

    @Override
    public void close() {
        this.state = State.CLOSED;
        this.demuxer.removeControlSession(this);
        CloseHelper.close(this.controlPublication);
    }

    @Override
    public boolean isDone() {
        return this.state == State.INACTIVE;
    }

    @Override
    public int doWork() {
        int workCount = 0;
        if (this.state == State.INIT) {
            workCount += this.waitForConnection();
        }
        if (this.state == State.ACTIVE) {
            workCount = this.sendQueuedResponses();
        }
        return workCount;
    }

    public AbstractListRecordingsSession activeListRecordingsSession() {
        return this.activeListRecordingsSession;
    }

    public void activeListRecordingsSession(AbstractListRecordingsSession session) {
        this.activeListRecordingsSession = session;
    }

    public void onStopRecording(long correlationId, int streamId, String channel) {
        this.conductor.stopRecording(correlationId, this, streamId, channel);
    }

    public void onStopRecordingSubscription(long correlationId, long subscriptionId) {
        this.conductor.stopRecordingSubscription(correlationId, this, subscriptionId);
    }

    public void onStartRecording(long correlationId, String channel, int streamId, SourceLocation sourceLocation) {
        this.conductor.startRecordingSubscription(correlationId, this, streamId, channel, sourceLocation);
    }

    public void onListRecordingsForUri(long correlationId, long fromRecordingId, int recordCount, int streamId, byte[] channelFragment) {
        this.conductor.newListRecordingsForUriSession(correlationId, fromRecordingId, recordCount, streamId, channelFragment, this);
    }

    public void onListRecordings(long correlationId, long fromRecordingId, int recordCount) {
        this.conductor.newListRecordingsSession(correlationId, fromRecordingId, recordCount, this);
    }

    public void onListRecording(long correlationId, long recordingId) {
        this.conductor.listRecording(correlationId, this, recordingId);
    }

    public void onFindLastMatchingRecording(long correlationId, long minRecordingId, int sessionId, int streamId, byte[] channelFragment) {
        this.conductor.findLastMatchingRecording(correlationId, minRecordingId, sessionId, streamId, channelFragment, this);
    }

    public void onStartReplay(long correlationId, long recordingId, long position, long length, int replayStreamId, String replayChannel) {
        this.conductor.startReplay(correlationId, this, recordingId, position, length, replayStreamId, replayChannel);
    }

    public void onStopReplay(long correlationId, long replaySessionId) {
        this.conductor.stopReplay(correlationId, this, replaySessionId);
    }

    public void onExtendRecording(long correlationId, long recordingId, String channel, int streamId, SourceLocation sourceLocation) {
        this.conductor.extendRecording(correlationId, this, recordingId, streamId, channel, sourceLocation);
    }

    public void onGetRecordingPosition(long correlationId, long recordingId) {
        this.conductor.getRecordingPosition(correlationId, this, recordingId);
    }

    public void onTruncateRecording(long correlationId, long recordingId, long position) {
        this.conductor.truncateRecording(correlationId, this, recordingId, position);
    }

    public void onGetStopPosition(long correlationId, long recordingId) {
        this.conductor.getStopPosition(correlationId, this, recordingId);
    }

    void onListRecordingSessionClosed(AbstractListRecordingsSession listRecordingsSession) {
        if (listRecordingsSession != this.activeListRecordingsSession) {
            throw new ArchiveException();
        }
        this.activeListRecordingsSession = null;
    }

    void sendOkResponse(long correlationId, ControlResponseProxy proxy) {
        if (!proxy.sendResponse(this.controlSessionId, correlationId, 0L, ControlResponseCode.OK, null, this.controlPublication)) {
            this.queueResponse(correlationId, 0L, ControlResponseCode.OK, null);
        }
    }

    void sendOkResponse(long correlationId, long relevantId, ControlResponseProxy proxy) {
        if (!proxy.sendResponse(this.controlSessionId, correlationId, relevantId, ControlResponseCode.OK, null, this.controlPublication)) {
            this.queueResponse(correlationId, relevantId, ControlResponseCode.OK, null);
        }
    }

    void sendRecordingUnknown(long correlationId, long recordingId, ControlResponseProxy proxy) {
        if (!proxy.sendResponse(this.controlSessionId, correlationId, recordingId, ControlResponseCode.RECORDING_UNKNOWN, null, this.controlPublication)) {
            this.queueResponse(correlationId, recordingId, ControlResponseCode.RECORDING_UNKNOWN, null);
        }
    }

    void sendErrorResponse(long correlationId, String errorMessage, ControlResponseProxy proxy) {
        if (!proxy.sendResponse(this.controlSessionId, correlationId, 0L, ControlResponseCode.ERROR, errorMessage, this.controlPublication)) {
            this.queueResponse(correlationId, 0L, ControlResponseCode.ERROR, errorMessage);
        }
    }

    void sendErrorResponse(long correlationId, long relevantId, String errorMessage, ControlResponseProxy proxy) {
        if (!proxy.sendResponse(this.controlSessionId, correlationId, relevantId, ControlResponseCode.ERROR, errorMessage, this.controlPublication)) {
            this.queueResponse(correlationId, relevantId, ControlResponseCode.ERROR, errorMessage);
        }
    }

    void attemptErrorResponse(long correlationId, String errorMessage, ControlResponseProxy proxy) {
        proxy.attemptErrorResponse(this.controlSessionId, correlationId, 0L, errorMessage, this.controlPublication);
    }

    void attemptErrorResponse(long correlationId, long relevantId, String errorMessage, ControlResponseProxy proxy) {
        proxy.attemptErrorResponse(this.controlSessionId, correlationId, relevantId, errorMessage, this.controlPublication);
    }

    int sendDescriptor(long correlationId, UnsafeBuffer descriptorBuffer, ControlResponseProxy proxy) {
        return proxy.sendDescriptor(this.controlSessionId, correlationId, descriptorBuffer, this.controlPublication);
    }

    int maxPayloadLength() {
        return this.controlPublication.maxPayloadLength();
    }

    private void sendConnectResponse() {
        if (!this.controlResponseProxy.sendResponse(this.controlSessionId, this.correlationId, this.controlSessionId, ControlResponseCode.OK, null, this.controlPublication)) {
            this.queueResponse(this.correlationId, this.controlSessionId, ControlResponseCode.OK, null);
        }
    }

    private int sendQueuedResponses() {
        int workCount = 0;
        if (!this.controlPublication.isConnected()) {
            this.state = State.INACTIVE;
        } else if (!this.queuedResponses.isEmpty()) {
            if (ControlSession.sendFirst(this.queuedResponses)) {
                this.queuedResponses.pollFirst();
                this.activityDeadlineMs = -1L;
                ++workCount;
            } else if (this.activityDeadlineMs == -1L) {
                this.activityDeadlineMs = this.epochClock.time() + this.connectTimeoutMs;
            } else if (this.hasGoneInactive()) {
                this.state = State.INACTIVE;
            }
        }
        return workCount;
    }

    private static boolean sendFirst(ArrayDeque<BooleanSupplier> responseQueue) {
        return responseQueue.peekFirst().getAsBoolean();
    }

    private int waitForConnection() {
        int workCount = 0;
        if (this.activityDeadlineMs == -1L) {
            this.activityDeadlineMs = this.epochClock.time() + this.connectTimeoutMs;
        } else if (this.controlPublication.isConnected()) {
            this.activityDeadlineMs = -1L;
            this.state = State.ACTIVE;
            this.sendConnectResponse();
            ++workCount;
        } else if (this.hasGoneInactive()) {
            this.state = State.INACTIVE;
        }
        return workCount;
    }

    private boolean hasGoneInactive() {
        return this.activityDeadlineMs != -1L && this.epochClock.time() > this.activityDeadlineMs;
    }

    private void queueResponse(long correlationId, long relevantId, ControlResponseCode code, String message) {
        this.queuedResponses.offer(() -> this.controlResponseProxy.sendResponse(this.controlSessionId, correlationId, relevantId, code, message, this.controlPublication));
    }

    static enum State {
        INIT,
        ACTIVE,
        INACTIVE,
        CLOSED;

    }
}

