/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Publication;
import io.aeron.archive.Catalog;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.ControlResponseEncoder;
import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.RecordingDescriptorEncoder;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

class ControlResponseProxy {
    private static final int MESSAGE_HEADER_LENGTH = 8;
    private static final int DESCRIPTOR_CONTENT_OFFSET = 32 + RecordingDescriptorEncoder.recordingIdEncodingOffset();
    private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(1024);
    private final BufferClaim bufferClaim = new BufferClaim();
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final ControlResponseEncoder responseEncoder = new ControlResponseEncoder();
    private final RecordingDescriptorEncoder recordingDescriptorEncoder = new RecordingDescriptorEncoder();

    ControlResponseProxy() {
    }

    int sendDescriptor(long controlSessionId, long correlationId, UnsafeBuffer descriptorBuffer, Publication controlPublication) {
        int messageLength = Catalog.descriptorLength(descriptorBuffer) + 8;
        int contentLength = messageLength - RecordingDescriptorEncoder.recordingIdEncodingOffset() - 8;
        for (int i = 0; i < 3; ++i) {
            long result = controlPublication.tryClaim(messageLength, this.bufferClaim);
            if (result > 0L) {
                MutableDirectBuffer buffer = this.bufferClaim.buffer();
                int bufferOffset = this.bufferClaim.offset();
                this.recordingDescriptorEncoder.wrapAndApplyHeader(buffer, bufferOffset, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId);
                int contentOffset = bufferOffset + 8 + RecordingDescriptorEncoder.recordingIdEncodingOffset();
                buffer.putBytes(contentOffset, descriptorBuffer, DESCRIPTOR_CONTENT_OFFSET, contentLength);
                this.bufferClaim.commit();
                return messageLength;
            }
            ControlResponseProxy.checkResult(controlPublication, result);
        }
        return 0;
    }

    boolean sendResponse(long controlSessionId, long correlationId, long relevantId, ControlResponseCode code, String errorMessage, Publication controlPublication) {
        this.responseEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).relevantId(relevantId).code(code).errorMessage(null == errorMessage ? "" : errorMessage);
        return this.send(controlPublication, this.buffer, 8 + this.responseEncoder.encodedLength());
    }

    void attemptErrorResponse(long controlSessionId, long correlationId, long relevantId, String errorMessage, Publication controlPublication) {
        long result;
        this.responseEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).relevantId(relevantId).code(ControlResponseCode.ERROR).errorMessage(null == errorMessage ? "" : errorMessage);
        int length = 8 + this.responseEncoder.encodedLength();
        for (int i = 0; i < 3 && (result = controlPublication.offer(this.buffer, 0, length)) <= 0L; ++i) {
        }
    }

    private boolean send(Publication controlPublication, DirectBuffer buffer, int length) {
        for (int i = 0; i < 3; ++i) {
            long result = controlPublication.offer(buffer, 0, length);
            if (result > 0L) {
                return true;
            }
            ControlResponseProxy.checkResult(controlPublication, result);
        }
        return false;
    }

    private static void checkResult(Publication controlPublication, long result) {
        if (result == -1L) {
            throw new ArchiveException("response publication is not connected: " + controlPublication.channel());
        }
        if (result == -4L) {
            throw new ArchiveException("response publication is closed: " + controlPublication.channel());
        }
        if (result == -5L) {
            throw new ArchiveException("response publication at max position: " + controlPublication.channel());
        }
    }
}

