/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.ControlRequestListener;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.CloseSessionRequestDecoder;
import io.aeron.archive.codecs.ConnectRequestDecoder;
import io.aeron.archive.codecs.ExtendRecordingRequestDecoder;
import io.aeron.archive.codecs.FindLastMatchingRecordingRequestDecoder;
import io.aeron.archive.codecs.ListRecordingRequestDecoder;
import io.aeron.archive.codecs.ListRecordingsForUriRequestDecoder;
import io.aeron.archive.codecs.ListRecordingsRequestDecoder;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.RecordingPositionRequestDecoder;
import io.aeron.archive.codecs.ReplayRequestDecoder;
import io.aeron.archive.codecs.StartRecordingRequestDecoder;
import io.aeron.archive.codecs.StopPositionRequestDecoder;
import io.aeron.archive.codecs.StopRecordingRequestDecoder;
import io.aeron.archive.codecs.StopRecordingSubscriptionRequestDecoder;
import io.aeron.archive.codecs.StopReplayRequestDecoder;
import io.aeron.archive.codecs.TruncateRecordingRequestDecoder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.collections.ArrayUtil;

class ControlRequestAdapter
implements FragmentHandler {
    private final ControlRequestListener listener;
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final ConnectRequestDecoder connectRequestDecoder = new ConnectRequestDecoder();
    private final CloseSessionRequestDecoder closeSessionRequestDecoder = new CloseSessionRequestDecoder();
    private final StartRecordingRequestDecoder startRecordingRequestDecoder = new StartRecordingRequestDecoder();
    private final StopRecordingRequestDecoder stopRecordingRequestDecoder = new StopRecordingRequestDecoder();
    private final ReplayRequestDecoder replayRequestDecoder = new ReplayRequestDecoder();
    private final StopReplayRequestDecoder stopReplayRequestDecoder = new StopReplayRequestDecoder();
    private final ListRecordingsRequestDecoder listRecordingsRequestDecoder = new ListRecordingsRequestDecoder();
    private final ListRecordingsForUriRequestDecoder listRecordingsForUriRequestDecoder = new ListRecordingsForUriRequestDecoder();
    private final ListRecordingRequestDecoder listRecordingRequestDecoder = new ListRecordingRequestDecoder();
    private final ExtendRecordingRequestDecoder extendRecordingRequestDecoder = new ExtendRecordingRequestDecoder();
    private final RecordingPositionRequestDecoder recordingPositionRequestDecoder = new RecordingPositionRequestDecoder();
    private final TruncateRecordingRequestDecoder truncateRecordingRequestDecoder = new TruncateRecordingRequestDecoder();
    private final StopRecordingSubscriptionRequestDecoder stopRecordingSubscriptionRequestDecoder = new StopRecordingSubscriptionRequestDecoder();
    private final StopPositionRequestDecoder stopPositionRequestDecoder = new StopPositionRequestDecoder();
    private final FindLastMatchingRecordingRequestDecoder findLastMatchingRecordingRequestDecoder = new FindLastMatchingRecordingRequestDecoder();

    ControlRequestAdapter(ControlRequestListener listener) {
        this.listener = listener;
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.headerDecoder.wrap(buffer, offset);
        int schemaId = this.headerDecoder.sbeSchemaId();
        if (schemaId != 101) {
            throw new ArchiveException("expected schemaId=101, actual=" + schemaId);
        }
        int templateId = this.headerDecoder.templateId();
        switch (templateId) {
            case 2: {
                this.connectRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onConnect(this.connectRequestDecoder.correlationId(), this.connectRequestDecoder.responseStreamId(), this.connectRequestDecoder.responseChannel());
                break;
            }
            case 3: {
                this.closeSessionRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onCloseSession(this.closeSessionRequestDecoder.controlSessionId());
                break;
            }
            case 4: {
                this.startRecordingRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onStartRecording(this.startRecordingRequestDecoder.controlSessionId(), this.startRecordingRequestDecoder.correlationId(), this.startRecordingRequestDecoder.streamId(), this.startRecordingRequestDecoder.channel(), this.startRecordingRequestDecoder.sourceLocation());
                break;
            }
            case 5: {
                this.stopRecordingRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onStopRecording(this.stopRecordingRequestDecoder.controlSessionId(), this.stopRecordingRequestDecoder.correlationId(), this.stopRecordingRequestDecoder.streamId(), this.stopRecordingRequestDecoder.channel());
                break;
            }
            case 6: {
                this.replayRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onStartReplay(this.replayRequestDecoder.controlSessionId(), this.replayRequestDecoder.correlationId(), this.replayRequestDecoder.recordingId(), this.replayRequestDecoder.position(), this.replayRequestDecoder.length(), this.replayRequestDecoder.replayStreamId(), this.replayRequestDecoder.replayChannel());
                break;
            }
            case 7: {
                this.stopReplayRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onStopReplay(this.stopReplayRequestDecoder.controlSessionId(), this.stopReplayRequestDecoder.correlationId(), this.stopReplayRequestDecoder.replaySessionId());
                break;
            }
            case 8: {
                this.listRecordingsRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onListRecordings(this.listRecordingsRequestDecoder.controlSessionId(), this.listRecordingsRequestDecoder.correlationId(), this.listRecordingsRequestDecoder.fromRecordingId(), this.listRecordingsRequestDecoder.recordCount());
                break;
            }
            case 9: {
                this.listRecordingsForUriRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                int channelLength = this.listRecordingsForUriRequestDecoder.channelLength();
                byte[] bytes = 0 == channelLength ? ArrayUtil.EMPTY_BYTE_ARRAY : new byte[channelLength];
                this.listRecordingsForUriRequestDecoder.getChannel(bytes, 0, channelLength);
                this.listener.onListRecordingsForUri(this.listRecordingsForUriRequestDecoder.controlSessionId(), this.listRecordingsForUriRequestDecoder.correlationId(), this.listRecordingsForUriRequestDecoder.fromRecordingId(), this.listRecordingsForUriRequestDecoder.recordCount(), this.listRecordingsForUriRequestDecoder.streamId(), bytes);
                break;
            }
            case 10: {
                this.listRecordingRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onListRecording(this.listRecordingRequestDecoder.controlSessionId(), this.listRecordingRequestDecoder.correlationId(), this.listRecordingRequestDecoder.recordingId());
                break;
            }
            case 11: {
                this.extendRecordingRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onExtendRecording(this.extendRecordingRequestDecoder.controlSessionId(), this.extendRecordingRequestDecoder.correlationId(), this.extendRecordingRequestDecoder.recordingId(), this.extendRecordingRequestDecoder.streamId(), this.extendRecordingRequestDecoder.channel(), this.extendRecordingRequestDecoder.sourceLocation());
                break;
            }
            case 12: {
                this.recordingPositionRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onGetRecordingPosition(this.recordingPositionRequestDecoder.controlSessionId(), this.recordingPositionRequestDecoder.correlationId(), this.recordingPositionRequestDecoder.recordingId());
                break;
            }
            case 13: {
                this.truncateRecordingRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onTruncateRecording(this.truncateRecordingRequestDecoder.controlSessionId(), this.truncateRecordingRequestDecoder.correlationId(), this.truncateRecordingRequestDecoder.recordingId(), this.truncateRecordingRequestDecoder.position());
                break;
            }
            case 14: {
                this.stopRecordingSubscriptionRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onStopRecordingSubscription(this.stopRecordingSubscriptionRequestDecoder.controlSessionId(), this.stopRecordingSubscriptionRequestDecoder.correlationId(), this.stopRecordingSubscriptionRequestDecoder.subscriptionId());
                break;
            }
            case 15: {
                this.stopPositionRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onGetStopPosition(this.stopPositionRequestDecoder.controlSessionId(), this.stopPositionRequestDecoder.correlationId(), this.stopPositionRequestDecoder.recordingId());
                break;
            }
            case 16: {
                this.findLastMatchingRecordingRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                int channelLength = this.findLastMatchingRecordingRequestDecoder.channelLength();
                byte[] bytes = 0 == channelLength ? ArrayUtil.EMPTY_BYTE_ARRAY : new byte[channelLength];
                this.findLastMatchingRecordingRequestDecoder.getChannel(bytes, 0, channelLength);
                this.listener.onFindLastMatchingRecording(this.findLastMatchingRecordingRequestDecoder.controlSessionId(), this.findLastMatchingRecordingRequestDecoder.correlationId(), this.findLastMatchingRecordingRequestDecoder.minRecordingId(), this.findLastMatchingRecordingRequestDecoder.sessionId(), this.findLastMatchingRecordingRequestDecoder.streamId(), bytes);
                break;
            }
        }
    }
}

