/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Archive;
import io.aeron.archive.ArchiveMarkFile;
import io.aeron.archive.Catalog;
import io.aeron.archive.codecs.RecordingDescriptorDecoder;
import io.aeron.archive.codecs.RecordingDescriptorEncoder;
import io.aeron.archive.codecs.RecordingDescriptorHeaderDecoder;
import io.aeron.archive.codecs.RecordingDescriptorHeaderEncoder;
import io.aeron.protocol.DataHeaderFlyweight;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.agrona.AsciiEncoding;
import org.agrona.BitUtil;
import org.agrona.BufferUtil;
import org.agrona.collections.ArrayUtil;

public class CatalogTool {
    private static final ByteBuffer TEMP_BUFFER = BufferUtil.allocateDirectAligned(4096, 32);
    private static final DataHeaderFlyweight HEADER_FLYWEIGHT = new DataHeaderFlyweight(TEMP_BUFFER);
    private static File archiveDir;

    public static void main(String[] args) {
        block118: {
            if (args.length == 0 || args.length > 3) {
                CatalogTool.printHelp();
                System.exit(-1);
            }
            if (!(archiveDir = new File(args[0])).exists()) {
                System.err.println("ERR: Archive folder not found: " + archiveDir.getAbsolutePath());
                CatalogTool.printHelp();
                System.exit(-1);
            }
            if (args.length == 2 && args[1].equals("describe")) {
                try (Catalog catalog = CatalogTool.openCatalog();
                     ArchiveMarkFile markFile = CatalogTool.openMarkFile(System.out::println);){
                    CatalogTool.printMarkInformation(markFile);
                    System.out.println("Catalog Max Entries: " + catalog.maxEntries());
                    catalog.forEach((he, hd, e, d) -> System.out.println(d));
                    break block118;
                }
            }
            if (args.length == 2 && args[1].equals("pid")) {
                try (ArchiveMarkFile markFile = CatalogTool.openMarkFile(null);){
                    System.out.println(markFile.decoder().pid());
                }
            }
            if (args.length == 3 && args[1].equals("describe")) {
                try (Catalog catalog = CatalogTool.openCatalog();){
                    catalog.forEntry((he, hd, e, d) -> System.out.println(d), Long.valueOf(args[2]));
                }
            }
            if (args.length == 2 && args[1].equals("verify")) {
                try (Catalog catalog = CatalogTool.openCatalog();){
                    catalog.forEach(CatalogTool::verify);
                }
            }
            if (args.length == 3 && args[1].equals("verify")) {
                try (Catalog catalog = CatalogTool.openCatalog();){
                    catalog.forEntry(CatalogTool::verify, Long.valueOf(args[2]));
                }
            }
            if (args.length == 2 && args[1].equals("count-entries")) {
                try (Catalog catalog = CatalogTool.openCatalog();){
                    System.out.println(catalog.countEntries());
                }
            }
            if (args.length == 2 && args[1].equals("max-entries")) {
                try (Catalog catalog = CatalogTool.openCatalog();){
                    System.out.println(catalog.maxEntries());
                }
            }
            if (args.length == 3 && args[1].equals("max-entries")) {
                long newMaxEntries = Long.parseLong(args[2]);
                try (Catalog catalog = new Catalog(archiveDir, null, 0, newMaxEntries, System::currentTimeMillis);){
                    System.out.println(catalog.maxEntries());
                }
            }
        }
    }

    private static ArchiveMarkFile openMarkFile(Consumer<String> logger) {
        return new ArchiveMarkFile(archiveDir, "archive-mark.dat", System::currentTimeMillis, TimeUnit.SECONDS.toMillis(5L), logger);
    }

    private static Catalog openCatalog() {
        return new Catalog(archiveDir, System::currentTimeMillis);
    }

    private static void printMarkInformation(ArchiveMarkFile markFile) {
        System.out.format("%1$tH:%1$tM:%1$tS (start: %2tF %2$tH:%2$tM:%2$tS, activity: %3tF %3$tH:%3$tM:%3$tS)%n", new Date(), new Date(markFile.decoder().startTimestamp()), new Date(markFile.activityTimestampVolatile()));
        System.out.println(markFile.decoder());
    }

    private static void verify(RecordingDescriptorHeaderEncoder headerEncoder, RecordingDescriptorHeaderDecoder headerDecoder, RecordingDescriptorEncoder encoder, RecordingDescriptorDecoder decoder) {
        long startOffset;
        long stopSegmentOffset;
        File maxSegmentFile;
        long recordingId = decoder.recordingId();
        int segmentFileLength = decoder.segmentFileLength();
        int termBufferLength = decoder.termBufferLength();
        long startPosition = decoder.startPosition();
        long startSegmentOffset = startPosition & (long)(termBufferLength - 1);
        long stopPosition = decoder.stopPosition();
        int maxSegmentIndex = -1;
        if (-1L == stopPosition) {
            String prefix = recordingId + "-";
            String[] segmentFiles = archiveDir.list((dir, name) -> name.startsWith(prefix) && name.endsWith(".rec"));
            if (null == segmentFiles) {
                segmentFiles = ArrayUtil.EMPTY_STRING_ARRAY;
            }
            for (String filename : segmentFiles) {
                int offset;
                int length = filename.length();
                int remaining = length - (offset = prefix.length()) - ".rec".length();
                if (remaining <= 0) continue;
                try {
                    maxSegmentIndex = Math.max(AsciiEncoding.parseIntAscii(filename, offset, remaining), maxSegmentIndex);
                }
                catch (Exception ignore) {
                    System.err.println("(recordingId=" + recordingId + ") ERR: malformed recording filename:" + filename);
                    headerEncoder.valid((byte)0);
                    return;
                }
            }
            if (maxSegmentIndex < 0) {
                System.err.println("(recordingId=" + recordingId + ") ERR: no recording segment files");
                headerEncoder.valid((byte)0);
                return;
            }
            maxSegmentFile = new File(archiveDir, Archive.segmentFileName(recordingId, maxSegmentIndex));
            stopSegmentOffset = Catalog.recoverStopOffset(maxSegmentFile, segmentFileLength);
            long recordingLength = startSegmentOffset + (long)maxSegmentIndex * (long)segmentFileLength + stopSegmentOffset;
            stopPosition = startPosition + recordingLength;
            encoder.stopPosition(stopPosition);
            encoder.stopTimestamp(System.currentTimeMillis());
        } else {
            long recordingLength = stopPosition - startPosition;
            long dataLength = startSegmentOffset + recordingLength;
            stopSegmentOffset = dataLength & (long)(segmentFileLength - 1);
            maxSegmentIndex = (int)((recordingLength - startSegmentOffset - stopSegmentOffset) / (long)segmentFileLength);
            maxSegmentFile = new File(archiveDir, Archive.segmentFileName(recordingId, maxSegmentIndex));
        }
        if (!maxSegmentFile.exists()) {
            System.err.println("(recordingId=" + recordingId + ") ERR: missing last recording file: " + maxSegmentFile);
            headerEncoder.valid((byte)0);
            return;
        }
        long l = startOffset = stopPosition - startPosition > (long)segmentFileLength ? 0L : startSegmentOffset;
        if (CatalogTool.verifyLastFile(recordingId, maxSegmentFile, startOffset, stopSegmentOffset, decoder)) {
            headerEncoder.valid((byte)0);
            return;
        }
        headerEncoder.valid((byte)1);
        System.out.println("(recordingId=" + recordingId + ") OK");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean verifyLastFile(long recordingId, File lastSegmentFile, long startOffset, long endSegmentOffset, RecordingDescriptorDecoder decoder) {
        try (FileChannel lastFile = FileChannel.open(lastSegmentFile.toPath(), StandardOpenOption.READ);){
            TEMP_BUFFER.clear();
            long position = startOffset;
            do {
                TEMP_BUFFER.clear().limit(32);
                if (lastFile.read(TEMP_BUFFER, position) != 32) {
                    System.err.println("(recordingId=" + recordingId + ") ERR: failed to read fragment header.");
                    boolean bl = true;
                    return bl;
                }
                if (HEADER_FLYWEIGHT.frameLength() != 0) {
                    if (HEADER_FLYWEIGHT.sessionId() != decoder.sessionId()) {
                        System.err.println("(recordingId=" + recordingId + ") ERR: fragment sessionId=" + HEADER_FLYWEIGHT.sessionId() + " (expected=" + decoder.sessionId() + ")");
                        boolean bl = true;
                        return bl;
                    }
                    if (HEADER_FLYWEIGHT.streamId() != decoder.streamId()) {
                        System.err.println("(recordingId=" + recordingId + ") ERR: fragment sessionId=" + HEADER_FLYWEIGHT.streamId() + " (expected=" + decoder.streamId() + ")");
                        boolean bl = true;
                        return bl;
                    }
                }
                position += (long)BitUtil.align(HEADER_FLYWEIGHT.frameLength(), 32);
            } while (HEADER_FLYWEIGHT.frameLength() != 0);
            if (position == endSegmentOffset) return false;
            System.err.println("(recordingId=" + recordingId + ") ERR: end segment offset=" + position + " (expected=" + endSegmentOffset + ")");
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            System.err.println("(recordingId=" + recordingId + ") ERR: failed to verify file:" + lastSegmentFile);
            ex.printStackTrace(System.err);
            return true;
        }
    }

    private static void printHelp() {
        System.out.println("Usage: <archive-dir> <command>");
        System.out.println("  describe <optional recordingId>: prints out descriptor(s) in the catalog.");
        System.out.println("  pid: prints just PID of archive.");
        System.out.println("  verify <optional recordingId>: verifies descriptor(s) in the catalog, checking");
        System.out.println("     recording files availability and contents. Faulty entries are marked as unusable.");
        System.out.println("  count-entries: queries the number of recording entries in the catalog.");
        System.out.println("  max-entries <optional number of entries>: gets or increases the maximum number of");
        System.out.println("     recording entries the catalog can store.");
    }
}

