/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Archive;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.status.SystemCounterDescriptor;
import org.agrona.CloseHelper;
import org.agrona.SystemUtil;
import org.agrona.concurrent.ShutdownSignalBarrier;

public class ArchivingMediaDriver
implements AutoCloseable {
    private final MediaDriver driver;
    private final Archive archive;

    ArchivingMediaDriver(MediaDriver driver, Archive archive) {
        this.driver = driver;
        this.archive = archive;
    }

    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles(args);
        try (ArchivingMediaDriver ignore = ArchivingMediaDriver.launch();){
            new ShutdownSignalBarrier().await();
            System.out.println("Shutdown Archive...");
        }
    }

    public static ArchivingMediaDriver launch() {
        return ArchivingMediaDriver.launch(new MediaDriver.Context(), new Archive.Context());
    }

    public static ArchivingMediaDriver launch(MediaDriver.Context driverCtx, Archive.Context archiveCtx) {
        MediaDriver driver = MediaDriver.launch(driverCtx);
        Archive archive = Archive.launch(archiveCtx.mediaDriverAgentInvoker(driver.sharedAgentInvoker()).errorHandler(driverCtx.errorHandler()).errorCounter(driverCtx.systemCounters().get(SystemCounterDescriptor.ERRORS)));
        return new ArchivingMediaDriver(driver, archive);
    }

    public Archive archive() {
        return this.archive;
    }

    public MediaDriver mediaDriver() {
        return this.driver;
    }

    @Override
    public void close() {
        CloseHelper.close(this.archive);
        CloseHelper.close(this.driver);
    }
}

