/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Archive;
import io.aeron.archive.codecs.mark.MarkFileHeaderDecoder;
import io.aeron.archive.codecs.mark.MarkFileHeaderEncoder;
import io.aeron.archive.codecs.mark.VarAsciiEncodingEncoder;
import java.io.File;
import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.MarkFile;
import org.agrona.SystemUtil;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.UnsafeBuffer;

public class ArchiveMarkFile
implements AutoCloseable {
    public static final String FILENAME = "archive-mark.dat";
    public static final int ALIGNMENT = 1024;
    private final MarkFileHeaderDecoder headerDecoder = new MarkFileHeaderDecoder();
    private final MarkFileHeaderEncoder headerEncoder = new MarkFileHeaderEncoder();
    private final MarkFile markFile;
    private final UnsafeBuffer buffer;

    public ArchiveMarkFile(Archive.Context ctx) {
        this(new File(ctx.archiveDir(), FILENAME), ArchiveMarkFile.alignedTotalFileLength(ctx), ctx.epochClock(), 0L);
        this.encode(ctx);
        this.updateActivityTimestamp(ctx.epochClock().time());
        this.signalReady();
    }

    public ArchiveMarkFile(File file, int totalFileLength, EpochClock epochClock, long timeoutMs) {
        this.markFile = new MarkFile(file, file.exists(), MarkFileHeaderDecoder.versionEncodingOffset(), MarkFileHeaderDecoder.activityTimestampEncodingOffset(), totalFileLength, timeoutMs, epochClock, version -> {
            if (version != 0) {
                throw new IllegalArgumentException("mark file version " + version + " does not match software:" + 0);
            }
        }, null);
        this.buffer = this.markFile.buffer();
        this.headerEncoder.wrap(this.buffer, 0);
        this.headerDecoder.wrap(this.buffer, 0, 128, 0);
        this.headerEncoder.pid(SystemUtil.getPid());
    }

    public ArchiveMarkFile(File directory, String filename, EpochClock epochClock, long timeoutMs, Consumer<String> logger) {
        this.markFile = new MarkFile(directory, filename, MarkFileHeaderDecoder.versionEncodingOffset(), MarkFileHeaderDecoder.activityTimestampEncodingOffset(), timeoutMs, epochClock, version -> {
            if (version != 0) {
                throw new IllegalArgumentException("mark file version " + version + " does not match software:" + 0);
            }
        }, logger);
        this.buffer = this.markFile.buffer();
        this.headerDecoder.wrap(this.buffer, 0, 128, 0);
    }

    @Override
    public void close() {
        CloseHelper.close(this.markFile);
    }

    public void signalReady() {
        this.markFile.signalReady(0);
    }

    public void updateActivityTimestamp(long nowMs) {
        this.markFile.timestampOrdered(nowMs);
    }

    public long activityTimestampVolatile() {
        return this.markFile.timestampVolatile();
    }

    public MarkFileHeaderEncoder encoder() {
        return this.headerEncoder;
    }

    public MarkFileHeaderDecoder decoder() {
        return this.headerDecoder;
    }

    public void encode(Archive.Context ctx) {
        this.headerEncoder.startTimestamp(ctx.epochClock().time()).controlStreamId(ctx.controlStreamId()).localControlStreamId(ctx.localControlStreamId()).eventsStreamId(ctx.recordingEventsStreamId()).controlChannel(ctx.controlChannel()).localControlChannel(ctx.localControlChannel()).eventsChannel(ctx.recordingEventsChannel()).aeronDirectory(ctx.aeron().context().aeronDirectoryName());
    }

    public static int alignedTotalFileLength(Archive.Context ctx) {
        return ArchiveMarkFile.alignedTotalFileLength(1024, ctx.controlChannel(), ctx.localControlChannel(), ctx.recordingEventsChannel(), ctx.aeron().context().aeronDirectoryName());
    }

    private static int alignedTotalFileLength(int alignment, String controlChannel, String localControlChannel, String eventsChannel, String aeronDirectory) {
        return BitUtil.align(128 + 4 * VarAsciiEncodingEncoder.lengthEncodingLength() + controlChannel.length() + localControlChannel.length() + eventsChannel.length() + aeronDirectory.length(), alignment);
    }
}

