/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Catalog;
import io.aeron.archive.ControlResponseProxy;
import io.aeron.archive.ControlSession;
import io.aeron.archive.Session;
import org.agrona.concurrent.UnsafeBuffer;

abstract class AbstractListRecordingsSession
implements Session {
    protected static final int MAX_SCANS_PER_WORK_CYCLE = 256;
    protected final UnsafeBuffer descriptorBuffer;
    protected final Catalog catalog;
    protected final ControlSession controlSession;
    protected final ControlResponseProxy proxy;
    protected final long correlationId;
    protected boolean isDone = false;

    AbstractListRecordingsSession(long correlationId, Catalog catalog, ControlResponseProxy proxy, ControlSession controlSession, UnsafeBuffer descriptorBuffer) {
        this.correlationId = correlationId;
        this.controlSession = controlSession;
        this.catalog = catalog;
        this.proxy = proxy;
        this.descriptorBuffer = descriptorBuffer;
    }

    @Override
    public void abort() {
        this.isDone = true;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public long sessionId() {
        return -1L;
    }

    @Override
    public int doWork() {
        int workCount = 0;
        if (!this.isDone) {
            workCount += this.sendDescriptors();
        }
        return workCount;
    }

    @Override
    public void close() {
        this.controlSession.onListRecordingSessionClosed(this);
    }

    protected abstract int sendDescriptors();
}

