/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.EventCode;
import io.aeron.agent.EventConfiguration;
import io.aeron.agent.EventEncoder;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;

public class EventLogger {
    public static final long ENABLED_EVENT_CODES = EventConfiguration.getEnabledEventCodes();
    public static final boolean IS_FRAME_IN_ENABLED = (ENABLED_EVENT_CODES & EventCode.FRAME_IN.tagBit()) == EventCode.FRAME_IN.tagBit();
    public static final boolean IS_FRAME_OUT_ENABLED = (ENABLED_EVENT_CODES & EventCode.FRAME_OUT.tagBit()) == EventCode.FRAME_OUT.tagBit();
    public static final EventLogger LOGGER = new EventLogger(EventConfiguration.EVENT_RING_BUFFER);
    private static final ThreadLocal<MutableDirectBuffer> ENCODING_BUFFER = ThreadLocal.withInitial(() -> new UnsafeBuffer(ByteBuffer.allocateDirect(EventConfiguration.MAX_EVENT_LENGTH)));
    private final RingBuffer ringBuffer;

    public EventLogger(RingBuffer ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    public void log(EventCode code, DirectBuffer buffer, int offset, int length) {
        if (EventCode.isEnabled(code, ENABLED_EVENT_CODES)) {
            MutableDirectBuffer encodedBuffer = ENCODING_BUFFER.get();
            int encodedLength = EventEncoder.encode(encodedBuffer, buffer, offset, length);
            this.ringBuffer.write(code.id(), encodedBuffer, 0, encodedLength);
        }
    }

    public void logFrameIn(DirectBuffer buffer, int offset, int length, InetSocketAddress dstAddress) {
        if (IS_FRAME_IN_ENABLED) {
            MutableDirectBuffer encodedBuffer = ENCODING_BUFFER.get();
            int encodedLength = EventEncoder.encode(encodedBuffer, buffer, offset, length, dstAddress);
            this.ringBuffer.write(EventCode.FRAME_IN.id(), encodedBuffer, 0, encodedLength);
        }
    }

    public void logFrameOut(ByteBuffer buffer, InetSocketAddress dstAddress) {
        if (IS_FRAME_OUT_ENABLED) {
            MutableDirectBuffer encodedBuffer = ENCODING_BUFFER.get();
            int encodedLength = EventEncoder.encode(encodedBuffer, buffer, buffer.position(), buffer.remaining(), dstAddress);
            this.ringBuffer.write(EventCode.FRAME_OUT.id(), encodedBuffer, 0, encodedLength);
        }
    }

    public void logPublicationRemoval(CharSequence uri, int sessionId, int streamId) {
        if (EventCode.isEnabled(EventCode.REMOVE_PUBLICATION_CLEANUP, ENABLED_EVENT_CODES)) {
            String msg = uri + " " + sessionId + ":" + streamId;
            this.logString(EventCode.REMOVE_PUBLICATION_CLEANUP, msg);
        }
    }

    public void logSubscriptionRemoval(CharSequence uri, int streamId, long id) {
        if (EventCode.isEnabled(EventCode.REMOVE_SUBSCRIPTION_CLEANUP, ENABLED_EVENT_CODES)) {
            String msg = uri + " " + streamId + " [" + id + "]";
            this.logString(EventCode.REMOVE_SUBSCRIPTION_CLEANUP, msg);
        }
    }

    public void logImageRemoval(CharSequence uri, int sessionId, int streamId, long id) {
        if (EventCode.isEnabled(EventCode.REMOVE_IMAGE_CLEANUP, ENABLED_EVENT_CODES)) {
            String msg = uri + " " + sessionId + ":" + streamId + " [" + id + "]";
            this.logString(EventCode.REMOVE_IMAGE_CLEANUP, msg);
        }
    }

    public void logChannelCreated(EventCode code, String description) {
        if (EventCode.isEnabled(code, ENABLED_EVENT_CODES)) {
            this.logString(code, description);
        }
    }

    private void logString(EventCode code, String value) {
        MutableDirectBuffer encodedBuffer = ENCODING_BUFFER.get();
        int encodingLength = EventEncoder.encode(encodedBuffer, value);
        this.ringBuffer.write(code.id(), encodedBuffer, 0, encodingLength);
    }
}

