/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.EventCode;
import io.aeron.agent.EventConfiguration;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.MessageHandler;

public class EventLogReaderAgent
implements Agent,
MessageHandler {
    public static final String LOG_FILENAME_PROP_NAME = "aeron.event.log.filename";
    private final FileChannel fileChannel;
    final CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
    final ByteBuffer byteBuffer = ByteBuffer.allocateDirect(EventConfiguration.MAX_EVENT_LENGTH + System.lineSeparator().length());
    private final StringBuilder builder = new StringBuilder();

    public EventLogReaderAgent() {
        String filename = System.getProperty(LOG_FILENAME_PROP_NAME);
        if (null == filename) {
            this.fileChannel = null;
        } else {
            try {
                this.fileChannel = FileChannel.open(Paths.get(filename, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public void onClose() {
        CloseHelper.close(this.fileChannel);
    }

    @Override
    public String roleName() {
        return "event-log-reader";
    }

    @Override
    public int doWork() {
        return EventConfiguration.EVENT_RING_BUFFER.read(this, 8);
    }

    @Override
    public void onMessage(int msgTypeId, MutableDirectBuffer buffer, int index, int length) {
        this.builder.setLength(0);
        EventCode.get(msgTypeId).decode(buffer, index, this.builder);
        this.builder.append(System.lineSeparator());
        if (null == this.fileChannel) {
            System.out.print(this.builder);
        } else {
            this.write(this.byteBuffer, this.fileChannel);
        }
    }

    private void write(ByteBuffer buffer, FileChannel fileChannel) {
        try {
            buffer.clear();
            this.encoder.reset();
            CoderResult coderResult = this.encoder.encode(CharBuffer.wrap(this.builder), buffer, false);
            if (CoderResult.UNDERFLOW != coderResult) {
                coderResult.throwException();
            }
            buffer.flip();
            do {
                fileChannel.write(buffer);
            } while (buffer.remaining() > 0);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }
}

