/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.ChannelEndpointInterceptor;
import io.aeron.agent.CleanupInterceptor;
import io.aeron.agent.CmdInterceptor;
import io.aeron.agent.EventLogger;
import io.aeron.shadow.net.bytebuddy.ByteBuddy;
import io.aeron.shadow.net.bytebuddy.agent.builder.AgentBuilder;
import io.aeron.shadow.net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import io.aeron.shadow.net.bytebuddy.asm.Advice;
import io.aeron.shadow.net.bytebuddy.description.type.TypeDescription;
import io.aeron.shadow.net.bytebuddy.dynamic.DynamicType;
import io.aeron.shadow.net.bytebuddy.dynamic.scaffold.TypeValidation;
import io.aeron.shadow.net.bytebuddy.matcher.ElementMatcher;
import io.aeron.shadow.net.bytebuddy.matcher.ElementMatchers;
import io.aeron.shadow.net.bytebuddy.utility.JavaModule;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.SleepingMillisIdleStrategy;

public class EventLogAgent {
    public static final String READER_CLASSNAME_PROP_NAME = "aeron.event.log.reader.classname";
    public static final String READER_CLASSNAME_DEFAULT = "io.aeron.agent.EventLogReaderAgent";
    private static final long SLEEP_PERIOD_MS = 1L;
    private static AgentRunner readerAgentRunner;
    private static Instrumentation instrumentation;
    private static volatile ClassFileTransformer logTransformer;
    static final AgentBuilder.Listener LISTENER;

    private static void agent(boolean shouldRedefine, Instrumentation instrumentation) {
        if (EventLogger.ENABLED_EVENT_CODES == 0L) {
            return;
        }
        EventLogAgent.instrumentation = instrumentation;
        readerAgentRunner = new AgentRunner(new SleepingMillisIdleStrategy(1L), Throwable::printStackTrace, null, EventLogAgent.getReaderAgent());
        logTransformer = new AgentBuilder.Default(new ByteBuddy().with(TypeValidation.DISABLED)).with(LISTENER).disableClassFormatChanges().with(shouldRedefine ? AgentBuilder.RedefinitionStrategy.RETRANSFORMATION : AgentBuilder.RedefinitionStrategy.DISABLED).type(ElementMatchers.nameEndsWith("DriverConductor")).transform((builder, typeDescription, classLoader, javaModule) -> builder.visit(Advice.to(CleanupInterceptor.CleanupImage.class).on(ElementMatchers.named("cleanupImage"))).visit(Advice.to(CleanupInterceptor.CleanupPublication.class).on(ElementMatchers.named("cleanupPublication"))).visit(Advice.to(CleanupInterceptor.CleanupSubscriptionLink.class).on(ElementMatchers.named("cleanupSubscriptionLink")))).type(ElementMatchers.nameEndsWith("ClientCommandAdapter")).transform((builder, typeDescription, classLoader, javaModule) -> builder.visit(Advice.to(CmdInterceptor.class).on(ElementMatchers.named("onMessage")))).type(ElementMatchers.nameEndsWith("ClientProxy")).transform((builder, typeDescription, classLoader, javaModule) -> builder.visit(Advice.to(CmdInterceptor.class).on(ElementMatchers.named("transmit")))).type(ElementMatchers.nameEndsWith("SenderProxy")).transform((builder, typeDescription, classLoader, javaModule) -> builder.visit(Advice.to(ChannelEndpointInterceptor.SenderProxyInterceptor.RegisterSendChannelEndpoint.class).on(ElementMatchers.named("registerSendChannelEndpoint"))).visit(Advice.to(ChannelEndpointInterceptor.SenderProxyInterceptor.CloseSendChannelEndpoint.class).on(ElementMatchers.named("closeSendChannelEndpoint")))).type(ElementMatchers.nameEndsWith("ReceiverProxy")).transform((builder, typeDescription, classLoader, javaModule) -> builder.visit(Advice.to(ChannelEndpointInterceptor.ReceiverProxyInterceptor.RegisterReceiveChannelEndpoint.class).on(ElementMatchers.named("registerReceiveChannelEndpoint"))).visit(Advice.to(ChannelEndpointInterceptor.ReceiverProxyInterceptor.CloseReceiveChannelEndpoint.class).on(ElementMatchers.named("closeReceiveChannelEndpoint")))).type(ElementMatchers.nameEndsWith("UdpChannelTransport")).transform((builder, typeDescription, classLoader, javaModule) -> builder.visit(Advice.to(ChannelEndpointInterceptor.UdpChannelTransportInterceptor.SendHook.class).on(ElementMatchers.named("sendHook"))).visit(Advice.to(ChannelEndpointInterceptor.UdpChannelTransportInterceptor.ReceiveHook.class).on(ElementMatchers.named("receiveHook")))).installOn(instrumentation);
        Thread thread = new Thread(readerAgentRunner);
        thread.setName("event-log-reader");
        thread.setDaemon(true);
        thread.start();
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        EventLogAgent.agent(false, instrumentation);
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        EventLogAgent.agent(true, instrumentation);
    }

    public static void removeTransformer() {
        if (logTransformer != null) {
            readerAgentRunner.close();
            instrumentation.removeTransformer(logTransformer);
            ElementMatcher.Junction orClause = ElementMatchers.nameEndsWith("DriverConductor").or(ElementMatchers.nameEndsWith("ClientProxy")).or(ElementMatchers.nameEndsWith("ClientCommandAdapter")).or(ElementMatchers.nameEndsWith("SenderProxy")).or(ElementMatchers.nameEndsWith("ReceiverProxy")).or(ElementMatchers.nameEndsWith("UdpChannelTransport"));
            ResettableClassFileTransformer transformer = new AgentBuilder.Default().type(orClause).transform(AgentBuilder.Transformer.NoOp.INSTANCE).installOn(instrumentation);
            instrumentation.removeTransformer(transformer);
            readerAgentRunner = null;
            instrumentation = null;
            logTransformer = null;
        }
    }

    private static Agent getReaderAgent() {
        try {
            Class<?> aClass = Class.forName(System.getProperty(READER_CLASSNAME_PROP_NAME, READER_CLASSNAME_DEFAULT));
            return (Agent)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        LISTENER = new AgentBuilder.Listener(){

            @Override
            public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
            }

            @Override
            public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
            }

            @Override
            public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded) {
            }

            @Override
            public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
                System.err.println("ERROR " + typeName);
                throwable.printStackTrace(System.out);
            }

            @Override
            public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
            }
        };
    }
}

