/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.EventConfiguration;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class EventEncoder {
    private static final int LOG_HEADER_LENGTH = 16;
    private static final int SOCKET_ADDRESS_MAX_LENGTH = 24;

    public static int encode(MutableDirectBuffer encodingBuffer, DirectBuffer buffer, int offset, int length) {
        int captureLength = EventEncoder.determineCaptureLength(length);
        int relativeOffset = EventEncoder.encodeLogHeader(encodingBuffer, captureLength, length);
        encodingBuffer.putBytes(relativeOffset, buffer, offset, captureLength);
        return relativeOffset += captureLength;
    }

    public static int encode(MutableDirectBuffer encodingBuffer, ByteBuffer buffer, int offset, int bufferLength, InetSocketAddress dstAddress) {
        int captureLength = EventEncoder.determineCaptureLength(bufferLength);
        int relativeOffset = EventEncoder.encodeLogHeader(encodingBuffer, captureLength, bufferLength);
        relativeOffset += EventEncoder.encodeSocketAddress(encodingBuffer, relativeOffset, dstAddress);
        encodingBuffer.putBytes(relativeOffset, buffer, offset, captureLength);
        return relativeOffset += captureLength;
    }

    public static int encode(MutableDirectBuffer encodingBuffer, DirectBuffer buffer, int offset, int bufferLength, InetSocketAddress dstAddress) {
        int captureLength = EventEncoder.determineCaptureLength(bufferLength);
        int relativeOffset = EventEncoder.encodeLogHeader(encodingBuffer, captureLength, bufferLength);
        relativeOffset += EventEncoder.encodeSocketAddress(encodingBuffer, relativeOffset, dstAddress);
        encodingBuffer.putBytes(relativeOffset, buffer, offset, captureLength);
        return relativeOffset += captureLength;
    }

    public static int encode(MutableDirectBuffer encodingBuffer, String value) {
        int length = encodingBuffer.putStringUtf8(16, value, ByteOrder.LITTLE_ENDIAN);
        int recordLength = 16 + length;
        EventEncoder.encodeLogHeader(encodingBuffer, recordLength, recordLength);
        return recordLength;
    }

    private static int encodeLogHeader(MutableDirectBuffer encodingBuffer, int captureLength, int length) {
        int relativeOffset = 0;
        encodingBuffer.putInt(relativeOffset, captureLength, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(relativeOffset += 4, length, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(relativeOffset += 4, System.nanoTime(), ByteOrder.LITTLE_ENDIAN);
        return relativeOffset += 8;
    }

    private static int encodeSocketAddress(MutableDirectBuffer encodingBuffer, int offset, InetSocketAddress dstAddress) {
        int relativeOffset = 0;
        encodingBuffer.putInt(offset + relativeOffset, dstAddress.getPort(), ByteOrder.LITTLE_ENDIAN);
        byte[] addressBytes = dstAddress.getAddress().getAddress();
        encodingBuffer.putInt(offset + (relativeOffset += 4), addressBytes.length, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putBytes(offset + (relativeOffset += 4), addressBytes);
        return relativeOffset += addressBytes.length;
    }

    private static int determineCaptureLength(int bufferLength) {
        return Math.min(bufferLength, EventConfiguration.MAX_EVENT_LENGTH - 16 - 24);
    }
}

