/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.EventCode;
import io.aeron.command.ClientTimeoutFlyweight;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.CounterMessageFlyweight;
import io.aeron.command.CounterUpdateFlyweight;
import io.aeron.command.DestinationMessageFlyweight;
import io.aeron.command.ErrorResponseFlyweight;
import io.aeron.command.ImageBuffersReadyFlyweight;
import io.aeron.command.ImageMessageFlyweight;
import io.aeron.command.OperationSucceededFlyweight;
import io.aeron.command.PublicationBuffersReadyFlyweight;
import io.aeron.command.PublicationMessageFlyweight;
import io.aeron.command.RemoveMessageFlyweight;
import io.aeron.command.SubscriptionMessageFlyweight;
import io.aeron.command.SubscriptionReadyFlyweight;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetAddress;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;

public class EventDissector {
    private static final DataHeaderFlyweight DATA_HEADER = new DataHeaderFlyweight();
    private static final StatusMessageFlyweight SM_HEADER = new StatusMessageFlyweight();
    private static final NakFlyweight NAK_HEADER = new NakFlyweight();
    private static final SetupFlyweight SETUP_HEADER = new SetupFlyweight();
    private static final RttMeasurementFlyweight RTT_MEASUREMENT = new RttMeasurementFlyweight();
    private static final PublicationMessageFlyweight PUB_MSG = new PublicationMessageFlyweight();
    private static final SubscriptionMessageFlyweight SUB_MSG = new SubscriptionMessageFlyweight();
    private static final PublicationBuffersReadyFlyweight PUB_READY = new PublicationBuffersReadyFlyweight();
    private static final ImageBuffersReadyFlyweight IMAGE_READY = new ImageBuffersReadyFlyweight();
    private static final CorrelatedMessageFlyweight CORRELATED_MSG = new CorrelatedMessageFlyweight();
    private static final ImageMessageFlyweight IMAGE_MSG = new ImageMessageFlyweight();
    private static final RemoveMessageFlyweight REMOVE_MSG = new RemoveMessageFlyweight();
    private static final DestinationMessageFlyweight DESTINATION_MSG = new DestinationMessageFlyweight();
    private static final ErrorResponseFlyweight ERROR_MSG = new ErrorResponseFlyweight();
    private static final CounterMessageFlyweight COUNTER_MSG = new CounterMessageFlyweight();
    private static final CounterUpdateFlyweight COUNTER_UPDATE = new CounterUpdateFlyweight();
    private static final OperationSucceededFlyweight OPERATION_SUCCEEDED = new OperationSucceededFlyweight();
    private static final SubscriptionReadyFlyweight SUBSCRIPTION_READY = new SubscriptionReadyFlyweight();
    private static final ClientTimeoutFlyweight CLIENT_TIMEOUT = new ClientTimeoutFlyweight();

    public static void dissectAsFrame(EventCode code, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int relativeOffset = EventDissector.dissectLogHeader(code, buffer, offset, builder);
        builder.append(": ");
        relativeOffset += EventDissector.dissectSocketAddress(buffer, offset + relativeOffset, builder);
        builder.append(" ");
        int frameOffset = offset + relativeOffset;
        switch (EventDissector.frameType(buffer, frameOffset)) {
            case 0: 
            case 1: {
                DataHeaderFlyweight dataFrame = DATA_HEADER;
                dataFrame.wrap(buffer, frameOffset, buffer.capacity() - frameOffset);
                EventDissector.dissect(dataFrame, builder);
                break;
            }
            case 3: {
                StatusMessageFlyweight smFrame = SM_HEADER;
                smFrame.wrap(buffer, frameOffset, buffer.capacity() - frameOffset);
                EventDissector.dissect(smFrame, builder);
                break;
            }
            case 2: {
                NakFlyweight nakFrame = NAK_HEADER;
                nakFrame.wrap(buffer, frameOffset, buffer.capacity() - frameOffset);
                EventDissector.dissect(nakFrame, builder);
                break;
            }
            case 5: {
                SetupFlyweight setupFrame = SETUP_HEADER;
                setupFrame.wrap(buffer, frameOffset, buffer.capacity() - frameOffset);
                EventDissector.dissect(setupFrame, builder);
                break;
            }
            case 6: {
                RttMeasurementFlyweight rttMeasurementFlyweight = RTT_MEASUREMENT;
                rttMeasurementFlyweight.wrap(buffer, frameOffset, buffer.capacity() - frameOffset);
                EventDissector.dissect(rttMeasurementFlyweight, builder);
                break;
            }
            default: {
                builder.append("FRAME_UNKNOWN");
            }
        }
    }

    public static void dissectAsCommand(EventCode code, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int relativeOffset = EventDissector.dissectLogHeader(code, buffer, offset, builder);
        builder.append(": ");
        switch (code) {
            case CMD_IN_ADD_PUBLICATION: 
            case CMD_IN_ADD_EXCLUSIVE_PUBLICATION: {
                PublicationMessageFlyweight pubCommand = PUB_MSG;
                pubCommand.wrap(buffer, offset + relativeOffset);
                EventDissector.dissect(pubCommand, builder);
                break;
            }
            case CMD_IN_ADD_SUBSCRIPTION: {
                SubscriptionMessageFlyweight subCommand = SUB_MSG;
                subCommand.wrap(buffer, offset + relativeOffset);
                EventDissector.dissect(subCommand, builder);
                break;
            }
            case CMD_IN_REMOVE_PUBLICATION: 
            case CMD_IN_REMOVE_SUBSCRIPTION: 
            case CMD_IN_REMOVE_COUNTER: {
                RemoveMessageFlyweight removeCmd = REMOVE_MSG;
                removeCmd.wrap(buffer, offset + relativeOffset);
                EventDissector.dissect(removeCmd, builder);
                break;
            }
            case CMD_OUT_PUBLICATION_READY: 
            case CMD_OUT_EXCLUSIVE_PUBLICATION_READY: {
                PublicationBuffersReadyFlyweight publicationReadyEvent = PUB_READY;
                publicationReadyEvent.wrap(buffer, offset + relativeOffset);
                EventDissector.dissect(publicationReadyEvent, builder);
                break;
            }
            case CMD_OUT_AVAILABLE_IMAGE: {
                ImageBuffersReadyFlyweight imageAvailableEvent = IMAGE_READY;
                imageAvailableEvent.wrap(buffer, offset + relativeOffset);
                EventDissector.dissect(imageAvailableEvent, builder);
                break;
            }
            case CMD_OUT_ON_OPERATION_SUCCESS: {
                OperationSucceededFlyweight operationSucceeded = OPERATION_SUCCEEDED;
                operationSucceeded.wrap(buffer, offset + relativeOffset);
                EventDissector.dissect(operationSucceeded, builder);
                break;
            }
            case CMD_IN_KEEPALIVE_CLIENT: 
            case CMD_IN_CLIENT_CLOSE: {
                CorrelatedMessageFlyweight correlatedEvent = CORRELATED_MSG;
                correlatedEvent.wrap(buffer, offset + relativeOffset);
                EventDissector.dissect(correlatedEvent, builder);
                break;
            }
            case CMD_OUT_ON_UNAVAILABLE_IMAGE: {
                ImageMessageFlyweight imageUnavailableEvent = IMAGE_MSG;
                imageUnavailableEvent.wrap(buffer, offset + relativeOffset);
                EventDissector.dissect(imageUnavailableEvent, builder);
                break;
            }
            case CMD_IN_ADD_DESTINATION: 
            case CMD_IN_REMOVE_DESTINATION: 
            case CMD_IN_ADD_RCV_DESTINATION: 
            case CMD_IN_REMOVE_RCV_DESTINATION: {
                DestinationMessageFlyweight destinationMessageFlyweight = DESTINATION_MSG;
                destinationMessageFlyweight.wrap(buffer, offset + relativeOffset);
                EventDissector.dissect(destinationMessageFlyweight, builder);
                break;
            }
            case CMD_OUT_ERROR: {
                ErrorResponseFlyweight errorResponseFlyweight = ERROR_MSG;
                errorResponseFlyweight.wrap(buffer, offset + relativeOffset);
                EventDissector.dissect(errorResponseFlyweight, builder);
                break;
            }
            case CMD_IN_ADD_COUNTER: {
                CounterMessageFlyweight counterMessage = COUNTER_MSG;
                counterMessage.wrap(buffer, offset + relativeOffset);
                EventDissector.dissect(counterMessage, builder);
                break;
            }
            case CMD_OUT_SUBSCRIPTION_READY: {
                SubscriptionReadyFlyweight subscriptionReady = SUBSCRIPTION_READY;
                subscriptionReady.wrap(buffer, offset + relativeOffset);
                EventDissector.dissect(subscriptionReady, builder);
                break;
            }
            case CMD_OUT_COUNTER_READY: 
            case CMD_OUT_ON_UNAVAILABLE_COUNTER: {
                CounterUpdateFlyweight counterUpdate = COUNTER_UPDATE;
                counterUpdate.wrap(buffer, offset + relativeOffset);
                EventDissector.dissect(counterUpdate, builder);
                break;
            }
            case CMD_OUT_ON_CLIENT_TIMEOUT: {
                ClientTimeoutFlyweight clientTimeout = CLIENT_TIMEOUT;
                clientTimeout.wrap(buffer, offset + relativeOffset);
                EventDissector.dissect(clientTimeout, builder);
                break;
            }
            default: {
                builder.append("COMMAND_UNKNOWN");
            }
        }
    }

    public static void dissectAsInvocation(EventCode code, MutableDirectBuffer buffer, int initialOffset, StringBuilder builder) {
        int relativeOffset = EventDissector.dissectLogHeader(code, buffer, initialOffset, builder);
        builder.append(": ");
        EventDissector.readStackTraceElement(buffer, initialOffset + relativeOffset, builder);
    }

    public static void dissectAsString(EventCode code, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int relativeOffset = EventDissector.dissectLogHeader(code, buffer, offset, builder);
        builder.append(": ");
        builder.append(buffer.getStringUtf8(offset + relativeOffset, ByteOrder.LITTLE_ENDIAN));
    }

    private static void readStackTraceElement(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int i = offset;
        int lineNumber = buffer.getInt(i, ByteOrder.LITTLE_ENDIAN);
        int length = buffer.getInt(i += 4);
        String className = buffer.getStringUtf8(i, length);
        i += 4 + length;
        length = buffer.getInt(i);
        String methodName = buffer.getStringUtf8(i, length);
        i += 4 + length;
        length = buffer.getInt(i);
        String fileName = buffer.getStringUtf8(i, length);
        builder.append(className).append('.').append(methodName).append(' ').append(fileName).append(':').append(lineNumber);
    }

    private static int dissectLogHeader(EventCode code, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int relativeOffset = 0;
        int captureLength = buffer.getInt(offset + relativeOffset, ByteOrder.LITTLE_ENDIAN);
        int bufferLength = buffer.getInt(offset + (relativeOffset += 4), ByteOrder.LITTLE_ENDIAN);
        long timestamp = buffer.getLong(offset + (relativeOffset += 4), ByteOrder.LITTLE_ENDIAN);
        builder.append('[').append((double)timestamp / 1.0E9).append("] ").append(code.name()).append(" [").append(captureLength).append('/').append(bufferLength).append(']');
        return relativeOffset += 8;
    }

    private static int dissectSocketAddress(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int relativeOffset = 0;
        int port = buffer.getInt(offset + relativeOffset, ByteOrder.LITTLE_ENDIAN);
        byte[] addressBuffer = new byte[buffer.getInt(offset + (relativeOffset += 4))];
        buffer.getBytes(offset + (relativeOffset += 4), addressBuffer);
        relativeOffset += addressBuffer.length;
        try {
            builder.append(InetAddress.getByAddress(addressBuffer).getHostAddress()).append('.').append(port);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return relativeOffset;
    }

    private static void dissect(DataHeaderFlyweight msg, StringBuilder builder) {
        builder.append(msg.headerType() == 0 ? "PAD" : "DATA").append(' ').append(msg.flags()).append(" len ").append(msg.frameLength()).append(' ').append(msg.sessionId()).append(':').append(msg.streamId()).append(':').append(msg.termId()).append(" @").append(msg.termOffset());
    }

    private static void dissect(StatusMessageFlyweight msg, StringBuilder builder) {
        builder.append("SM ").append(msg.flags()).append(" len ").append(msg.frameLength()).append(' ').append(msg.sessionId()).append(':').append(msg.streamId()).append(':').append(msg.consumptionTermId()).append(" @").append(msg.consumptionTermOffset()).append(' ').append(msg.receiverWindowLength()).append(' ').append(msg.receiverId());
    }

    private static void dissect(NakFlyweight msg, StringBuilder builder) {
        builder.append("NAK ").append(msg.flags()).append(" len ").append(msg.frameLength()).append(' ').append(msg.sessionId()).append(':').append(msg.streamId()).append(':').append(msg.termId()).append(" @").append(msg.termOffset()).append(' ').append(msg.length());
    }

    private static void dissect(SetupFlyweight msg, StringBuilder builder) {
        builder.append("SETUP ").append(msg.flags()).append(" len ").append(msg.frameLength()).append(' ').append(msg.sessionId()).append(':').append(msg.streamId()).append(':').append(msg.activeTermId()).append(' ').append(msg.initialTermId()).append(" @").append(msg.termOffset()).append(' ').append(msg.termLength()).append(" MTU ").append(msg.mtuLength()).append(" TTL ").append(msg.ttl());
    }

    private static void dissect(RttMeasurementFlyweight msg, StringBuilder builder) {
        builder.append("RTT ").append(msg.flags()).append(" len ").append(msg.frameLength()).append(' ').append(msg.sessionId()).append(':').append(msg.streamId()).append(' ').append(msg.echoTimestampNs()).append(' ').append(msg.receptionDelta()).append(' ').append(msg.receiverId());
    }

    private static void dissect(PublicationMessageFlyweight msg, StringBuilder builder) {
        builder.append(msg.channel()).append(' ').append(msg.streamId()).append(" [").append(msg.clientId()).append(':').append(msg.correlationId()).append(']');
    }

    private static void dissect(SubscriptionMessageFlyweight msg, StringBuilder builder) {
        builder.append(msg.channel()).append(' ').append(msg.streamId()).append(" [").append(msg.registrationCorrelationId()).append("][").append(msg.clientId()).append(':').append(msg.correlationId()).append(']');
    }

    private static void dissect(PublicationBuffersReadyFlyweight msg, StringBuilder builder) {
        builder.append(msg.sessionId()).append(':').append(msg.streamId()).append(' ').append(msg.publicationLimitCounterId()).append(' ').append(msg.channelStatusCounterId()).append(" [").append(msg.correlationId()).append(' ').append(msg.registrationId()).append("] ").append(msg.logFileName());
    }

    private static void dissect(ImageBuffersReadyFlyweight msg, StringBuilder builder) {
        builder.append(msg.sessionId()).append(':').append(msg.streamId()).append(" [").append(msg.subscriberPositionId()).append(':').append(msg.subscriptionRegistrationId()).append("] \"").append(msg.sourceIdentity()).append("\" [").append(msg.correlationId()).append("] ").append(msg.logFileName());
    }

    private static void dissect(CorrelatedMessageFlyweight msg, StringBuilder builder) {
        builder.append('[').append(msg.clientId()).append(':').append(msg.correlationId()).append(']');
    }

    private static void dissect(ImageMessageFlyweight msg, StringBuilder builder) {
        builder.append(msg.channel()).append(' ').append(msg.streamId()).append(" [").append(msg.correlationId()).append(' ').append(msg.subscriptionRegistrationId()).append(']');
    }

    private static void dissect(RemoveMessageFlyweight msg, StringBuilder builder) {
        builder.append(msg.registrationId()).append(" [").append(msg.clientId()).append(':').append(msg.correlationId()).append(']');
    }

    private static void dissect(DestinationMessageFlyweight msg, StringBuilder builder) {
        builder.append(msg.channel()).append(' ').append(msg.registrationCorrelationId()).append(" [").append(msg.clientId()).append(':').append(msg.correlationId()).append(']');
    }

    private static void dissect(ErrorResponseFlyweight msg, StringBuilder builder) {
        builder.append(msg.offendingCommandCorrelationId()).append(' ').append(msg.errorCode().toString()).append(' ').append(msg.errorMessage());
    }

    private static void dissect(CounterMessageFlyweight msg, StringBuilder builder) {
        builder.append(msg.typeId()).append(" [").append(msg.keyBufferOffset()).append(' ').append(msg.keyBufferLength()).append("][").append(msg.labelBufferOffset()).append(' ').append(msg.labelBufferLength()).append("][").append(msg.clientId()).append(':').append(msg.correlationId()).append(']');
    }

    private static void dissect(CounterUpdateFlyweight msg, StringBuilder builder) {
        builder.append(msg.correlationId()).append(' ').append(msg.counterId());
    }

    private static void dissect(OperationSucceededFlyweight msg, StringBuilder builder) {
        builder.append(msg.correlationId());
    }

    private static void dissect(SubscriptionReadyFlyweight msg, StringBuilder builder) {
        builder.append(msg.correlationId()).append(' ').append(msg.channelStatusCounterId());
    }

    private static void dissect(ClientTimeoutFlyweight msg, StringBuilder builder) {
        builder.append(msg.clientId());
    }

    public static int frameType(MutableDirectBuffer buffer, int termOffset) {
        return buffer.getShort(FrameDescriptor.typeOffset(termOffset), ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }
}

