/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.EventCode;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.agrona.SystemUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;

public class EventConfiguration {
    public static final String BUFFER_LENGTH_PROP_NAME = "aeron.event.buffer.length";
    public static final String ENABLED_EVENT_CODES_PROP_NAME = "aeron.event.log";
    public static final Set<EventCode> ADMIN_ONLY_EVENT_CODES = EnumSet.of(EventCode.CMD_IN_ADD_PUBLICATION, new EventCode[]{EventCode.CMD_IN_ADD_SUBSCRIPTION, EventCode.CMD_IN_KEEPALIVE_CLIENT, EventCode.CMD_IN_REMOVE_PUBLICATION, EventCode.CMD_IN_REMOVE_SUBSCRIPTION, EventCode.CMD_IN_ADD_COUNTER, EventCode.CMD_IN_REMOVE_COUNTER, EventCode.CMD_IN_CLIENT_CLOSE, EventCode.CMD_IN_ADD_RCV_DESTINATION, EventCode.CMD_IN_REMOVE_RCV_DESTINATION, EventCode.REMOVE_IMAGE_CLEANUP, EventCode.REMOVE_PUBLICATION_CLEANUP, EventCode.REMOVE_SUBSCRIPTION_CLEANUP, EventCode.CMD_OUT_PUBLICATION_READY, EventCode.CMD_OUT_AVAILABLE_IMAGE, EventCode.CMD_OUT_ON_UNAVAILABLE_IMAGE, EventCode.CMD_OUT_ON_OPERATION_SUCCESS, EventCode.CMD_OUT_ERROR, EventCode.CMD_OUT_SUBSCRIPTION_READY, EventCode.CMD_OUT_COUNTER_READY, EventCode.CMD_OUT_ON_UNAVAILABLE_COUNTER, EventCode.CMD_OUT_ON_CLIENT_TIMEOUT, EventCode.SEND_CHANNEL_CREATION, EventCode.RECEIVE_CHANNEL_CREATION, EventCode.SEND_CHANNEL_CLOSE, EventCode.RECEIVE_CHANNEL_CLOSE});
    public static final Set<EventCode> ALL_LOGGER_EVENT_CODES = EnumSet.allOf(EventCode.class);
    public static final int BUFFER_LENGTH_DEFAULT = 0x200000;
    public static final int MAX_EVENT_LENGTH = 4096 + System.lineSeparator().length();
    public static final int EVENT_READER_FRAME_LIMIT = 8;
    public static final ManyToOneRingBuffer EVENT_RING_BUFFER;

    public static long getEnabledEventCodes() {
        return EventConfiguration.makeTagBitSet(EventConfiguration.getEnabledEventCodes(System.getProperty(ENABLED_EVENT_CODES_PROP_NAME)));
    }

    static long makeTagBitSet(Set<EventCode> eventCodes) {
        long result = 0L;
        for (EventCode eventCode : eventCodes) {
            result |= eventCode.tagBit();
        }
        return result;
    }

    static Set<EventCode> getEnabledEventCodes(String enabledLoggerEventCodes) {
        String[] codeIds;
        if (null == enabledLoggerEventCodes || "".equals(enabledLoggerEventCodes)) {
            return EnumSet.noneOf(EventCode.class);
        }
        HashSet<EventCode> eventCodeSet = new HashSet<EventCode>();
        String[] stringArray = codeIds = enabledLoggerEventCodes.split(",");
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String codeId;
            switch (codeId = stringArray[i]) {
                case "all": {
                    eventCodeSet.addAll(ALL_LOGGER_EVENT_CODES);
                    continue block12;
                }
                case "admin": {
                    eventCodeSet.addAll(ADMIN_ONLY_EVENT_CODES);
                    continue block12;
                }
                default: {
                    EventCode code = null;
                    try {
                        code = EventCode.valueOf(codeId);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (null == code) {
                        try {
                            code = EventCode.get(Integer.parseInt(codeId));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    if (null != code) {
                        eventCodeSet.add(code);
                        continue block12;
                    }
                    System.err.println("unknown event code: " + codeId);
                }
            }
        }
        return eventCodeSet;
    }

    static {
        int bufferLength = SystemUtil.getSizeAsInt(BUFFER_LENGTH_PROP_NAME, 0x200000) + RingBufferDescriptor.TRAILER_LENGTH;
        EVENT_RING_BUFFER = new ManyToOneRingBuffer(new UnsafeBuffer(ByteBuffer.allocateDirect(bufferLength)));
    }
}

