/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.EventDissector;
import org.agrona.MutableDirectBuffer;

public enum EventCode {
    FRAME_IN(1, EventDissector::dissectAsFrame),
    FRAME_OUT(2, EventDissector::dissectAsFrame),
    CMD_IN_ADD_PUBLICATION(3, EventDissector::dissectAsCommand),
    CMD_IN_REMOVE_PUBLICATION(4, EventDissector::dissectAsCommand),
    CMD_IN_ADD_SUBSCRIPTION(5, EventDissector::dissectAsCommand),
    CMD_IN_REMOVE_SUBSCRIPTION(6, EventDissector::dissectAsCommand),
    CMD_OUT_PUBLICATION_READY(7, EventDissector::dissectAsCommand),
    CMD_OUT_AVAILABLE_IMAGE(8, EventDissector::dissectAsCommand),
    INVOCATION(9, EventDissector::dissectAsInvocation),
    CMD_OUT_ON_OPERATION_SUCCESS(12, EventDissector::dissectAsCommand),
    CMD_IN_KEEPALIVE_CLIENT(13, EventDissector::dissectAsCommand),
    REMOVE_PUBLICATION_CLEANUP(14, EventDissector::dissectAsString),
    REMOVE_SUBSCRIPTION_CLEANUP(15, EventDissector::dissectAsString),
    REMOVE_IMAGE_CLEANUP(16, EventDissector::dissectAsString),
    CMD_OUT_ON_UNAVAILABLE_IMAGE(17, EventDissector::dissectAsCommand),
    SEND_CHANNEL_CREATION(23, EventDissector::dissectAsString),
    RECEIVE_CHANNEL_CREATION(24, EventDissector::dissectAsString),
    SEND_CHANNEL_CLOSE(25, EventDissector::dissectAsString),
    RECEIVE_CHANNEL_CLOSE(26, EventDissector::dissectAsString),
    CMD_IN_ADD_DESTINATION(30, EventDissector::dissectAsCommand),
    CMD_IN_REMOVE_DESTINATION(31, EventDissector::dissectAsCommand),
    CMD_IN_ADD_EXCLUSIVE_PUBLICATION(32, EventDissector::dissectAsCommand),
    CMD_OUT_EXCLUSIVE_PUBLICATION_READY(33, EventDissector::dissectAsCommand),
    CMD_OUT_ERROR(34, EventDissector::dissectAsCommand),
    CMD_IN_ADD_COUNTER(35, EventDissector::dissectAsCommand),
    CMD_IN_REMOVE_COUNTER(36, EventDissector::dissectAsCommand),
    CMD_OUT_SUBSCRIPTION_READY(37, EventDissector::dissectAsCommand),
    CMD_OUT_COUNTER_READY(38, EventDissector::dissectAsCommand),
    CMD_OUT_ON_UNAVAILABLE_COUNTER(39, EventDissector::dissectAsCommand),
    CMD_IN_CLIENT_CLOSE(40, EventDissector::dissectAsCommand),
    CMD_IN_ADD_RCV_DESTINATION(41, EventDissector::dissectAsCommand),
    CMD_IN_REMOVE_RCV_DESTINATION(42, EventDissector::dissectAsCommand),
    CMD_OUT_ON_CLIENT_TIMEOUT(43, EventDissector::dissectAsCommand);

    private static final int MAX_ID = 63;
    private static final EventCode[] EVENT_CODE_BY_ID;
    private final long tagBit;
    private final int id;
    private final DissectFunction dissector;

    private EventCode(int id, DissectFunction dissector) {
        this.id = id;
        this.tagBit = 1L << id;
        this.dissector = dissector;
    }

    public int id() {
        return this.id;
    }

    public long tagBit() {
        return this.tagBit;
    }

    public static EventCode get(int id) {
        if (id < 0 || id > 63) {
            throw new IllegalArgumentException("no EventCode for id: " + id);
        }
        EventCode code = EVENT_CODE_BY_ID[id];
        if (null == code) {
            throw new IllegalArgumentException("no EventCode for id: " + id);
        }
        return code;
    }

    public static boolean isEnabled(EventCode code, long mask) {
        return (mask & code.tagBit()) == code.tagBit();
    }

    public void decode(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        this.dissector.dissect(this, buffer, offset, builder);
    }

    static {
        EVENT_CODE_BY_ID = new EventCode[63];
        for (EventCode code : EventCode.values()) {
            int id = code.id();
            if (null != EVENT_CODE_BY_ID[id]) {
                throw new IllegalArgumentException("id already in use: " + id);
            }
            EventCode.EVENT_CODE_BY_ID[id] = code;
        }
    }

    @FunctionalInterface
    static interface DissectFunction {
        public void dissect(EventCode var1, MutableDirectBuffer var2, int var3, StringBuilder var4);
    }
}

